/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.config.annotation;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.faces.FacesException;
import javax.faces.bean.ApplicationScoped;
import javax.faces.bean.CustomScoped;
import javax.faces.bean.ManagedBean;
import javax.faces.bean.NoneScoped;
import javax.faces.bean.RequestScoped;
import javax.faces.bean.SessionScoped;
import javax.faces.bean.ViewScoped;
import javax.faces.component.FacesComponent;
import javax.faces.component.behavior.FacesBehavior;
import javax.faces.context.ExternalContext;
import javax.faces.convert.FacesConverter;
import javax.faces.event.ComponentSystemEvent;
import javax.faces.event.NamedEvent;
import javax.faces.render.FacesBehaviorRenderer;
import javax.faces.render.FacesRenderer;
import javax.faces.validator.FacesValidator;
import org.apache.myfaces.config.impl.digester.elements.Application;
import org.apache.myfaces.config.impl.digester.elements.Behavior;
import org.apache.myfaces.config.impl.digester.elements.ClientBehaviorRenderer;
import org.apache.myfaces.config.impl.digester.elements.Converter;
import org.apache.myfaces.config.impl.digester.elements.FacesConfig;
import org.apache.myfaces.config.impl.digester.elements.ManagedProperty;
import org.apache.myfaces.config.impl.digester.elements.RenderKit;
import org.apache.myfaces.config.impl.digester.elements.Renderer;
import org.apache.myfaces.spi.AnnotationProvider;
import org.apache.myfaces.spi.AnnotationProviderFactory;

public class AnnotationConfigurator {
    private static final Logger log = Logger.getLogger(AnnotationConfigurator.class.getName());

    public FacesConfig createFacesConfig(ExternalContext externalcontext, boolean metadataComplete) {
        if (!metadataComplete) {
            AnnotationProvider provider = AnnotationProviderFactory.getAnnotationProviderFactory(externalcontext).getAnnotationProvider(externalcontext);
            Map<Class<? extends Annotation>, Set<Class<?>>> map = provider.getAnnotatedClasses(externalcontext);
            return this.createFacesConfig(map);
        }
        return null;
    }

    protected FacesConfig createFacesConfig(Map<Class<? extends Annotation>, Set<Class<?>>> map) {
        FacesConfig facesConfig = new FacesConfig();
        Set<Class<?>> classes = map.get(FacesComponent.class);
        if (classes != null && !classes.isEmpty()) {
            for (Class<?> clazz : classes) {
                FacesComponent comp = clazz.getAnnotation(FacesComponent.class);
                if (comp == null) continue;
                if (log.isLoggable(Level.FINEST)) {
                    log.finest("addComponent(" + comp.value() + "," + clazz.getName() + ")");
                }
                facesConfig.addComponent(comp.value(), clazz.getName());
            }
        }
        if ((classes = map.get(FacesConverter.class)) != null && !classes.isEmpty()) {
            for (Class<?> clazz : classes) {
                boolean hasValue;
                FacesConverter conv = clazz.getAnnotation(FacesConverter.class);
                if (conv == null) continue;
                if (log.isLoggable(Level.FINEST)) {
                    log.finest("addConverter(" + conv.value() + "," + clazz.getName() + ")");
                }
                boolean hasForClass = !Object.class.equals((Object)conv.forClass());
                boolean bl = hasValue = conv.value().length() > 0;
                if (hasForClass || hasValue) {
                    Converter converter = new Converter();
                    if (hasForClass) {
                        converter.setForClass(conv.forClass().getName());
                    }
                    if (hasValue) {
                        converter.setConverterId(conv.value());
                    }
                    converter.setConverterClass(clazz.getName());
                    facesConfig.addConverter(converter);
                    continue;
                }
                throw new FacesException("@FacesConverter must have value, forClass or both. Check annotation @FacesConverter on class: " + clazz.getName());
            }
        }
        if ((classes = map.get(FacesValidator.class)) != null && !classes.isEmpty()) {
            for (Class<?> clazz : classes) {
                FacesValidator val = clazz.getAnnotation(FacesValidator.class);
                if (val == null) continue;
                if (log.isLoggable(Level.FINEST)) {
                    log.finest("addValidator(" + val.value() + "," + clazz.getName() + ")");
                }
                facesConfig.addValidator(val.value(), clazz.getName());
                if (!val.isDefault()) continue;
                Application app = null;
                app = facesConfig.getApplications().isEmpty() ? new Application() : (Application)facesConfig.getApplications().get(0);
                app.addDefaultValidatorId(val.value());
            }
        }
        if ((classes = map.get(FacesRenderer.class)) != null && !classes.isEmpty()) {
            for (Class<?> clazz : classes) {
                RenderKit renderKit;
                FacesRenderer rend = clazz.getAnnotation(FacesRenderer.class);
                if (rend == null) continue;
                String renderKitId = rend.renderKitId();
                if (renderKitId == null) {
                    renderKitId = "HTML_BASIC";
                }
                if (log.isLoggable(Level.FINEST)) {
                    log.finest("addRenderer(" + renderKitId + ", " + rend.componentFamily() + ", " + rend.rendererType() + ", " + clazz.getName() + ")");
                }
                if ((renderKit = (RenderKit)facesConfig.getRenderKit(renderKitId)) == null) {
                    renderKit = new RenderKit();
                    facesConfig.addRenderKit(renderKit);
                }
                Renderer renderer = new Renderer();
                renderer.setComponentFamily(rend.componentFamily());
                renderer.setRendererClass(clazz.getName());
                renderer.setRendererType(rend.rendererType());
                renderKit.addRenderer(renderer);
            }
        }
        if ((classes = map.get(ManagedBean.class)) != null && !classes.isEmpty()) {
            this.handleManagedBean(facesConfig, classes);
        }
        if ((classes = map.get(NamedEvent.class)) != null && !classes.isEmpty()) {
            this.handleNamedEvent(facesConfig, classes);
        }
        if ((classes = map.get(FacesBehavior.class)) != null && !classes.isEmpty()) {
            this.handleFacesBehavior(facesConfig, classes);
        }
        if ((classes = map.get(FacesBehaviorRenderer.class)) != null && !classes.isEmpty()) {
            this.handleFacesBehaviorRenderer(facesConfig, classes);
        }
        return facesConfig;
    }

    private void handleManagedBean(FacesConfig facesConfig, Set<Class<?>> classes) {
        for (Class<?> clazz : classes) {
            Field[] fields;
            ManagedBean bean = clazz.getAnnotation(ManagedBean.class);
            if (bean == null) continue;
            if (log.isLoggable(Level.FINE)) {
                log.fine("Class '" + clazz.getName() + "' has an @ManagedBean annotation");
            }
            org.apache.myfaces.config.impl.digester.elements.ManagedBean mbc = new org.apache.myfaces.config.impl.digester.elements.ManagedBean();
            String beanName = bean.name();
            if (beanName == null || beanName.equals("")) {
                beanName = clazz.getName();
                int index = beanName.lastIndexOf(".");
                if (index != -1) {
                    beanName = beanName.substring(index + 1);
                }
                beanName = String.valueOf(Character.toLowerCase(beanName.charAt(0))) + beanName.substring(1);
            }
            mbc.setName(beanName);
            mbc.setEager(Boolean.toString(bean.eager()));
            mbc.setBeanClass(clazz.getName());
            ApplicationScoped appScoped = clazz.getAnnotation(ApplicationScoped.class);
            if (appScoped != null) {
                mbc.setScope("application");
            } else {
                NoneScoped noneScoped = clazz.getAnnotation(NoneScoped.class);
                if (noneScoped != null) {
                    mbc.setScope("none");
                } else {
                    RequestScoped requestScoped = clazz.getAnnotation(RequestScoped.class);
                    if (requestScoped != null) {
                        mbc.setScope("request");
                    } else {
                        SessionScoped sessionScoped = clazz.getAnnotation(SessionScoped.class);
                        if (sessionScoped != null) {
                            mbc.setScope("session");
                        } else {
                            ViewScoped viewScoped = clazz.getAnnotation(ViewScoped.class);
                            if (viewScoped != null) {
                                mbc.setScope("view");
                            } else {
                                CustomScoped customScoped = clazz.getAnnotation(CustomScoped.class);
                                if (customScoped != null) {
                                    mbc.setScope(customScoped.value());
                                } else {
                                    mbc.setScope("request");
                                }
                            }
                        }
                    }
                }
            }
            Field[] fieldArray = fields = this.fields(clazz);
            int n = fields.length;
            int n2 = 0;
            while (n2 < n) {
                javax.faces.bean.ManagedProperty property;
                Field field = fieldArray[n2];
                if (log.isLoggable(Level.FINEST)) {
                    log.finest("  Scanning field '" + field.getName() + "'");
                }
                if ((property = field.getAnnotation(javax.faces.bean.ManagedProperty.class)) != null) {
                    if (log.isLoggable(Level.FINE)) {
                        log.fine("  Field '" + field.getName() + "' has a @ManagedProperty annotation");
                    }
                    ManagedProperty mpc = new ManagedProperty();
                    String name = property.name();
                    if (name == null || "".equals(name)) {
                        name = field.getName();
                    }
                    mpc.setPropertyName(name);
                    mpc.setPropertyClass(field.getType().getName());
                    mpc.setValue(property.value());
                    mbc.addProperty(mpc);
                }
                ++n2;
            }
            facesConfig.addManagedBean(mbc);
        }
    }

    private void handleNamedEvent(FacesConfig facesConfig, Set<Class<?>> classes) {
        for (Class<?> clazz : classes) {
            NamedEvent namedEvent = clazz.getAnnotation(NamedEvent.class);
            if (namedEvent == null) continue;
            if (!ComponentSystemEvent.class.isAssignableFrom(clazz) && log.isLoggable(Level.WARNING)) {
                log.warning(String.valueOf(clazz.getName()) + " is annotated with @javax.faces.event.NamedEvent, but does " + "not extend javax.faces.event.ComponentSystemEvent");
            }
            org.apache.myfaces.config.impl.digester.elements.NamedEvent namedEventConfig = new org.apache.myfaces.config.impl.digester.elements.NamedEvent();
            namedEventConfig.setEventClass(clazz.getName());
            namedEventConfig.setShortName(namedEvent.shortName());
            facesConfig.addNamedEvent(namedEventConfig);
        }
    }

    private void handleFacesBehavior(FacesConfig facesConfig, Set<Class<?>> classes) {
        for (Class<?> clazz : classes) {
            FacesBehavior facesBehavior = clazz.getAnnotation(FacesBehavior.class);
            if (facesBehavior == null) continue;
            if (!javax.faces.component.behavior.Behavior.class.isAssignableFrom(clazz) && log.isLoggable(Level.WARNING)) {
                log.warning(String.valueOf(clazz.getName()) + " is annotated with @javax.faces.component.behavior.FacesBehavior, " + "but does not implement javax.faces.component.behavior.Behavior");
            }
            if (log.isLoggable(Level.FINEST)) {
                log.finest("addBehavior(" + facesBehavior.value() + ", " + clazz.getName() + ")");
            }
            Behavior behavior = new Behavior();
            behavior.setBehaviorId(facesBehavior.value());
            behavior.setBehaviorClass(clazz.getName());
            facesConfig.addBehavior(behavior);
        }
    }

    private void handleFacesBehaviorRenderer(FacesConfig facesConfig, Set<Class<?>> classes) {
        for (Class<?> clazz : classes) {
            RenderKit renderKit;
            FacesBehaviorRenderer facesBehaviorRenderer = clazz.getAnnotation(FacesBehaviorRenderer.class);
            if (facesBehaviorRenderer == null) continue;
            String renderKitId = facesBehaviorRenderer.renderKitId();
            if (log.isLoggable(Level.FINEST)) {
                log.finest("addClientBehaviorRenderer(" + renderKitId + ", " + facesBehaviorRenderer.rendererType() + ", " + clazz.getName() + ")");
            }
            if ((renderKit = (RenderKit)facesConfig.getRenderKit(renderKitId)) == null) {
                renderKit = new RenderKit();
                facesConfig.addRenderKit(renderKit);
            }
            ClientBehaviorRenderer cbr = new ClientBehaviorRenderer();
            cbr.setRendererType(facesBehaviorRenderer.rendererType());
            cbr.setRendererClass(clazz.getName());
            renderKit.addClientBehaviorRenderer(cbr);
        }
    }

    private Field[] fields(Class<?> clazz) {
        HashMap<String, Field> fields = new HashMap<String, Field>();
        do {
            Field[] fieldArray = clazz.getDeclaredFields();
            int n = fieldArray.length;
            int n2 = 0;
            while (n2 < n) {
                Field field = fieldArray[n2];
                if (!fields.containsKey(field.getName())) {
                    fields.put(field.getName(), field);
                }
                ++n2;
            }
        } while ((clazz = clazz.getSuperclass()) != Object.class);
        return fields.values().toArray(new Field[fields.size()]);
    }
}

