/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.webtier.jsf.facelet.dtcontext;

import oracle.eclipse.tools.webtier.jsf.facelet.dtcontext.TextLocation;
import oracle.eclipse.tools.webtier.jsf.facelet.dtcontext.XMLTextRange;

public class LocationBasedXMLTextRange
extends XMLTextRange {
    protected TextLocation.TextLocationWorkingCopy startLocation;
    protected TextLocation.TextLocationWorkingCopy endLocation;

    public static LocationBasedXMLTextRange create(int startOffset, int endOffset) {
        TextLocation.TextLocationWorkingCopy valueLocationStart = new TextLocation.TextLocationWorkingCopy();
        valueLocationStart.setAbsOffset(startOffset);
        TextLocation.TextLocationWorkingCopy valueLocationEnd = new TextLocation.TextLocationWorkingCopy();
        valueLocationEnd.setAbsOffset(endOffset);
        LocationBasedXMLTextRange valueRange = new LocationBasedXMLTextRange(valueLocationStart, valueLocationEnd);
        return valueRange;
    }

    public LocationBasedXMLTextRange() {
        this.startLocation = new TextLocation.TextLocationWorkingCopy();
        this.endLocation = new TextLocation.TextLocationWorkingCopy();
    }

    public LocationBasedXMLTextRange(TextLocation.TextLocationWorkingCopy startLocation, TextLocation.TextLocationWorkingCopy endLocation) {
        this.startLocation = startLocation;
        this.endLocation = endLocation;
    }

    @Override
    public int getStartOffset() {
        return this.startLocation.getAbsOffset();
    }

    @Override
    public int getEndOffset() {
        return this.endLocation.getAbsOffset();
    }

    @Override
    public int getStartLine() {
        return this.startLocation.getLine();
    }

    @Override
    public int getStartColumn() {
        return this.startLocation.getColumn();
    }

    @Override
    public int getEndLine() {
        return this.endLocation.getLine();
    }

    @Override
    public int getEndColumn() {
        return this.endLocation.getColumn();
    }

    @Override
    public int getLength() {
        return this.getEndOffset() - this.getStartOffset();
    }

    @Override
    protected void setStartLine(int startLine) {
        this.startLocation.setLine(startLine);
    }

    @Override
    protected void setStartColumn(int startColumn) {
        this.startLocation.setColumn(startColumn);
    }

    @Override
    protected void setEndLine(int endLine) {
        this.endLocation.setLine(endLine);
    }

    @Override
    protected void setEndColumn(int endColumn) {
        this.endLocation.setColumn(endColumn);
    }

    @Override
    protected void setStartOffset(int startOffset) {
        this.startLocation.setAbsOffset(startOffset);
    }

    @Override
    protected void setEndOffset(int endOffset) {
        this.endLocation.setAbsOffset(endOffset);
    }

    public static class XMLTextRangeWorkingCopy
    extends LocationBasedXMLTextRange {
        @Override
        public void setStartLine(int startLine) {
            this.startLocation.setLine(startLine);
        }

        @Override
        public void setStartColumn(int startColumn) {
            this.startLocation.setColumn(startColumn);
        }

        @Override
        public void setEndLine(int endLine) {
            this.endLocation.setLine(endLine);
        }

        @Override
        public void setEndColumn(int endColumn) {
            this.endLocation.setColumn(endColumn);
        }

        @Override
        public void setStartOffset(int startOffset) {
            this.startLocation.setAbsOffset(startOffset);
        }

        @Override
        public void setEndOffset(int endOffset) {
            this.endLocation.setAbsOffset(endOffset);
        }
    }
}

