/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.webtier.jsf.facelet.dtcontext;

import de.odysseus.el.tree.TreeBuilderException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.el.ELException;
import javax.faces.view.facelets.TagAttribute;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElements;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.adapters.XmlAdapter;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import oracle.eclipse.tools.webtier.jsf.facelet.dtcompiler.el.ELParser;
import oracle.eclipse.tools.webtier.jsf.facelet.dtcontext.ELModelObjectSubExpression;
import oracle.eclipse.tools.webtier.jsf.facelet.dtcontext.LocationBasedXMLTextRange;
import oracle.eclipse.tools.webtier.jsf.facelet.dtcontext.ParseError;
import oracle.eclipse.tools.webtier.jsf.facelet.dtcontext.TagError;
import oracle.eclipse.tools.webtier.jsf.facelet.dtcontext.TagIncludeError;
import oracle.eclipse.tools.webtier.jsf.facelet.dtcontext.TextLocation;
import oracle.eclipse.tools.webtier.jsf.facelet.dtcontext.XMLTextRange;
import oracle.eclipse.tools.webtier.jsf.facelet.dtcontext.jaxb.ListOfSerializableMapEntry;
import oracle.eclipse.tools.webtier.jsf.facelet.dtcontext.jaxb.MapOfListXmlAdapter;
import oracle.eclipse.tools.webtier.jsf.facelet.dtcontext.jaxb.SerializableMapEntry;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;

@XmlRootElement(name="faceletTagReport")
public class DesignTimeContextData {
    @XmlElement(name="compilationUnit")
    private URL compileUnitRoot;
    @XmlElements(value={@XmlElement(name="tagerror")})
    private List<TagError> tagErrors;
    @XmlElement
    private List<TagIncludeError> tagIncludeErrors;
    @XmlJavaTypeAdapter(value=IncludeReferenceMapAdapter.class)
    private Map<URL, List<IncludeReference>> references;
    @XmlJavaTypeAdapter(value=NamespaceRangeMapAdapter.class)
    private Map<String, List<NsRange>> namespaceRanges;
    @XmlJavaTypeAdapter(value=TagRangeMapAdapter.class)
    private Map<TagId, List<TagRange>> tagRanges;
    @XmlElement
    private List<ELRange> elTextRanges;
    @XmlElements(value={@XmlElement(name="parseerror")})
    private List<ParseError> parseErrors;

    public DesignTimeContextData() {
    }

    public DesignTimeContextData(URL compileUnitRoot) {
        this.references = new HashMap<URL, List<IncludeReference>>();
        this.namespaceRanges = new HashMap<String, List<NsRange>>();
        this.compileUnitRoot = compileUnitRoot;
        this.tagErrors = new ArrayList<TagError>(3);
        this.tagIncludeErrors = new ArrayList<TagIncludeError>(3);
        this.tagRanges = new HashMap<TagId, List<TagRange>>();
    }

    public List<TagError> getTagErrors() {
        return Collections.unmodifiableList(this.tagErrors);
    }

    public List<ParseError> getParseErrors() {
        if (this.parseErrors == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(this.parseErrors);
    }

    public List<TagIncludeError> getTagIncludeErrors() {
        return Collections.unmodifiableList(this.tagIncludeErrors);
    }

    public Map<URL, List<IncludeReference>> getReferences() {
        return Collections.unmodifiableMap(this.references);
    }

    public Map<String, List<NsRange>> getNamespaceRanges() {
        return Collections.unmodifiableMap(this.namespaceRanges);
    }

    public URL getCompileUnitRoot() {
        return this.compileUnitRoot;
    }

    public void addIncludeReference(URL includingFile, IncludeReference includeReference) {
        List<IncludeReference> refs = this.getOrCreateReferences(includingFile);
        refs.add(includeReference);
    }

    public void addNamespaceRange(NsRange pop) {
        this.getOrCreateNamespaceRanges(pop.getUri()).add(pop);
    }

    public void addTagIncludeError(TagIncludeError includeError) {
        this.tagIncludeErrors.add(includeError);
    }

    public void addTagError(TagError tagError) {
        this.tagErrors.add(tagError);
    }

    public void addParseError(ParseError parseError) {
        if (this.parseErrors == null) {
            this.parseErrors = new ArrayList<ParseError>(2);
        }
        this.parseErrors.add(parseError);
    }

    public void addTagRange(TagRange pop) {
        this.getOrCreateTagRanges(pop.getTagIdentifier()).add(pop);
    }

    public Map<TagId, List<TagRange>> getTagRanges() {
        return Collections.unmodifiableMap(this.tagRanges);
    }

    public TagRange getTagRangeFor(TagError tagError) {
        List<TagRange> list;
        String uri = tagError.getUri();
        String name = tagError.getTagName();
        int startOffset = tagError.getStartOffset();
        TagRange tagRange = null;
        if (uri != null && name != null && (list = this.tagRanges.get(new TagId(uri, name))) != null) {
            for (TagRange testRange : list) {
                if (testRange.getStartOffset() > startOffset || testRange.getEndOffsetOpenTag() <= startOffset) continue;
                tagRange = testRange;
                break;
            }
        }
        return tagRange;
    }

    private List<TagRange> getOrCreateTagRanges(TagId tagIdentifier) {
        List<TagRange> ranges = this.tagRanges.get(tagIdentifier);
        if (ranges == null) {
            ranges = new ArrayList<TagRange>(5);
            this.tagRanges.put(tagIdentifier, ranges);
        }
        return ranges;
    }

    public void addELTextRange(ELRange elRange, ELParser elParser) {
        if (this.elTextRanges == null) {
            this.elTextRanges = new ArrayList<ELRange>(5);
        }
        this.elTextRanges.add(elRange);
        if (elParser != null) {
            String elText = elRange.getELText();
            try {
                List<ELModelObjectSubExpression> modelObjects = elParser.getModelObjects(elText, elRange.getStartOffset());
                elRange.addModelSubExprs(modelObjects);
            }
            catch (TreeBuilderException tbe) {
                elRange.addError((ELException)((Object)tbe));
            }
        }
    }

    public List<ELRange> getElTextRanges() {
        if (this.elTextRanges == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(this.elTextRanges);
    }

    public boolean hasReportableProblems() {
        return !this.getTagErrors().isEmpty() || !this.getTagIncludeErrors().isEmpty();
    }

    private List<IncludeReference> getOrCreateReferences(URL url) {
        List<IncludeReference> list = this.references.get(url);
        if (list == null) {
            list = new ArrayList<IncludeReference>(3);
            this.references.put(url, list);
        }
        return list;
    }

    private List<NsRange> getOrCreateNamespaceRanges(String uri) {
        List<NsRange> list = this.namespaceRanges.get(uri);
        if (list == null) {
            list = new ArrayList<NsRange>(3);
            this.namespaceRanges.put(uri, list);
        }
        return list;
    }

    public static class AttributeRange {
        private TagAttribute attr;
        private List<ELRange> elOffsets;
        private XMLTextRange valueRange;
        private XMLTextRange nameRange;
        private TagRange parent;

        private AttributeRange() {
            throw new UnsupportedOperationException("Satisfies JAXB; don't call");
        }

        public AttributeRange(TagRange parent, TagAttribute attr, XMLTextRange nameRange, XMLTextRange valueRange) {
            this.parent = parent;
            this.attr = attr;
            this.valueRange = valueRange;
            this.nameRange = nameRange;
        }

        @XmlAttribute(name="name")
        public String getName() {
            return this.attr.getLocalName();
        }

        public void setELRanges(List<ELRange> ranges) {
            this.elOffsets = ranges;
        }

        @XmlElements(value={@XmlElement(name="elRange")})
        public List<ELRange> getELRanges() {
            return Collections.unmodifiableList(this.elOffsets);
        }

        @XmlTransient
        public TagAttribute getAttr() {
            return this.attr;
        }

        @XmlElement
        public XMLTextRange getValueRange() {
            return this.valueRange;
        }

        @XmlElement
        public XMLTextRange getNameRange() {
            return this.nameRange;
        }

        public TagRange getParent() {
            return this.parent;
        }
    }

    public static class ELRange {
        private boolean isHash;
        private int startOffset;
        private int endOffset = -1;
        private String ELText;
        private List<ELModelObjectSubExpression> modelSubExprs;
        private List<ELException> errors;

        private ELRange() {
            throw new UnsupportedOperationException("Satisfies JAXB; don't call");
        }

        public void addError(ELException e) {
            if (this.errors == null) {
                this.errors = new ArrayList<ELException>(1);
            }
            this.errors.add(e);
        }

        public ELRange(boolean isHash, int startOffset) {
            this.isHash = isHash;
            this.startOffset = startOffset;
        }

        @XmlAttribute
        public int getStartOffset() {
            return this.startOffset;
        }

        public void setStartOffset(int startOffset) {
            this.startOffset = startOffset;
        }

        @XmlAttribute
        public int getEndOffset() {
            return this.endOffset;
        }

        public void setEndOffset(int endOffset) {
            this.endOffset = endOffset;
        }

        @XmlAttribute
        public boolean isHash() {
            return this.isHash;
        }

        public void setELText(String eLText) {
            this.ELText = eLText;
        }

        @XmlElement
        public String getELText() {
            return this.ELText;
        }

        @XmlElements(value={@XmlElement})
        public List<ELModelObjectSubExpression> getModelSubExprs() {
            if (this.modelSubExprs == null) {
                return Collections.emptyList();
            }
            return Collections.unmodifiableList(this.modelSubExprs);
        }

        @XmlElements(value={@XmlElement})
        public List<ELException> getErrors() {
            if (this.errors == null) {
                return Collections.emptyList();
            }
            return Collections.unmodifiableList(this.errors);
        }

        public void addModelSubExprs(List<ELModelObjectSubExpression> modelSubExprs) {
            if (this.modelSubExprs == null) {
                this.modelSubExprs = new ArrayList<ELModelObjectSubExpression>(2);
            }
            for (ELModelObjectSubExpression e : modelSubExprs) {
                this.modelSubExprs.add(e);
            }
        }

        public void addModelSubExprs(ELModelObjectSubExpression modelSubExpr) {
            if (this.modelSubExprs == null) {
                this.modelSubExprs = new ArrayList<ELModelObjectSubExpression>(2);
            }
            this.modelSubExprs.add(modelSubExpr);
        }
    }

    public static class IncludeReference {
        @XmlElement
        private URL root;
        @XmlElement
        private URL includingDoc;
        @XmlElement
        private URL includedDoc;
        @XmlElement
        private String relativePathToIncluded;

        public IncludeReference() {
            throw new UnsupportedOperationException();
        }

        public IncludeReference(URL root, URL includingDoc, URL includedDoc) {
            this.root = root;
            this.includingDoc = includingDoc;
            this.includedDoc = includedDoc;
            IPath includingPath = new Path(includingDoc.toString()).removeLastSegments(1);
            Path path = new Path(includedDoc.toString());
            IPath includedPath = path.removeLastSegments(1);
            IPath relativePath = includedPath.makeRelativeTo(includingPath);
            relativePath = relativePath.append(path.lastSegment());
            this.relativePathToIncluded = relativePath.toString();
        }
    }

    private static class IncludeReferenceMapAdapter
    extends XmlAdapter<MyHashMapAdapterType, Map<URL, List<IncludeReference>>> {
        private IncludeReferenceMapAdapter() {
        }

        public Map<URL, List<IncludeReference>> unmarshal(MyHashMapAdapterType v) throws Exception {
            throw new UnsupportedOperationException();
        }

        public MyHashMapAdapterType marshal(Map<URL, List<IncludeReference>> v) throws Exception {
            MyHashMapAdapterType newValue = new MyHashMapAdapterType();
            newValue.entries = new ArrayList<MyHashMapEntryType>(v.size());
            for (Map.Entry<URL, List<IncludeReference>> entry : v.entrySet()) {
                MyHashMapEntryType e = new MyHashMapEntryType();
                e.source = entry.getKey();
                e.references = entry.getValue();
                newValue.entries.add(e);
            }
            return newValue;
        }
    }

    public static class ListOfTagRangeEntry
    extends ListOfSerializableMapEntry {
        @XmlElement
        public List<TagRangeEntry> getRanges() {
            return this.entries();
        }
    }

    private static class MyHashMapAdapterType {
        @XmlElements(value={@XmlElement(name="includeReferences")})
        List<MyHashMapEntryType> entries;

        private MyHashMapAdapterType() {
        }
    }

    private static class MyHashMapEntryType {
        @XmlElement
        private URL source;
        @XmlElement
        private List<IncludeReference> references;

        private MyHashMapEntryType() {
        }
    }

    private static class MyNamespaceRangeAdapterType {
        @XmlElements(value={@XmlElement(name="namespaceRange")})
        List<MyNamespaceRangeEntryType> entries;

        private MyNamespaceRangeAdapterType() {
        }
    }

    private static class MyNamespaceRangeEntryType {
        @XmlElement
        private String uri;
        @XmlElement
        private List<NsRange> ranges;

        private MyNamespaceRangeEntryType() {
        }
    }

    private static class NamespaceRangeMapAdapter
    extends XmlAdapter<MyNamespaceRangeAdapterType, Map<String, List<NsRange>>> {
        private NamespaceRangeMapAdapter() {
        }

        public Map<String, List<NsRange>> unmarshal(MyNamespaceRangeAdapterType v) throws Exception {
            throw new UnsupportedOperationException();
        }

        public MyNamespaceRangeAdapterType marshal(Map<String, List<NsRange>> v) throws Exception {
            MyNamespaceRangeAdapterType newValue = new MyNamespaceRangeAdapterType();
            newValue.entries = new ArrayList<MyNamespaceRangeEntryType>(v.size());
            for (Map.Entry<String, List<NsRange>> entry : v.entrySet()) {
                MyNamespaceRangeEntryType e = new MyNamespaceRangeEntryType();
                e.uri = entry.getKey();
                e.ranges = entry.getValue();
                newValue.entries.add(e);
            }
            return newValue;
        }
    }

    public static class NsRange
    extends LocationBasedXMLTextRange {
        private String uri;

        public void setStartLocation(TextLocation location) {
            this.startLocation = location.getWorkingCopy();
        }

        public void setEndLocation(TextLocation location) {
            this.endLocation = location.getWorkingCopy();
        }

        @Override
        public int getStartOffset() {
            return super.getStartOffset();
        }

        @Override
        public int getEndOffset() {
            return super.getEndOffset();
        }

        @Override
        public int getStartLine() {
            return super.getStartLine();
        }

        @Override
        public int getStartColumn() {
            return super.getStartColumn();
        }

        @Override
        public int getEndLine() {
            return super.getEndLine();
        }

        @Override
        public int getEndColumn() {
            return super.getEndColumn();
        }

        @XmlElement
        public String getUri() {
            return this.uri;
        }

        public void setUri(String uri) {
            this.uri = uri;
        }
    }

    public static class TagId {
        @XmlElement
        private String uri;
        @XmlElement
        private String name;

        private TagId() {
        }

        public TagId(String uri, String name) {
            assert (uri != null && name != null);
            this.uri = uri;
            this.name = name;
        }

        public String getUri() {
            return this.uri;
        }

        public String getName() {
            return this.name;
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (other instanceof TagId) {
                return this.uri.equals(((TagId)other).uri) && this.name.equals(((TagId)other).name);
            }
            return false;
        }

        public int hashCode() {
            int h = 31 * this.uri.hashCode() + this.name.hashCode();
            return h;
        }

        public String toString() {
            return String.format("[Tag uri=%s, name=%s]", this.uri != null ? this.uri : "null", this.name != null ? this.name : "null");
        }
    }

    public static class TagRange {
        private TagId tagIdentifier;
        private String tagId;
        private boolean trimmed;
        private XMLTextRange elementStartRange;
        private XMLTextRange elementEndRange;
        private Map<String, AttributeRange> attrIndex;
        private TagRange parent;
        @XmlElement
        private List<AttributeRange> attributes;

        private TagRange() {
            throw new UnsupportedOperationException();
        }

        public TagRange(XMLTextRange elementStartRange) {
            this.elementStartRange = elementStartRange;
        }

        public void setEndTagRange(XMLTextRange endRange) {
            this.elementEndRange = endRange;
        }

        @XmlAttribute
        public int getStartOffset() {
            return this.elementStartRange.getStartOffset();
        }

        @XmlAttribute
        public int getEndOffset() {
            return this.elementEndRange.getEndOffset();
        }

        @XmlAttribute
        public int getStartLine() {
            return this.elementStartRange.getStartLine();
        }

        @XmlAttribute
        public int getStartColumn() {
            return this.elementStartRange.getStartColumn();
        }

        @XmlAttribute
        public int getEndLine() {
            return this.elementEndRange.getEndLine();
        }

        @XmlAttribute
        public int getEndColumn() {
            return this.elementEndRange.getEndColumn();
        }

        @XmlAttribute
        public int getEndOffsetOpenTag() {
            return this.elementStartRange.getEndOffset();
        }

        @XmlAttribute
        public int getStartOffsetCloseTag() {
            return this.elementEndRange.getStartOffset();
        }

        public String getTagId() {
            return this.tagId;
        }

        public void setTagId(String tagId) {
            this.tagId = tagId;
        }

        public TagId getTagIdentifier() {
            return this.tagIdentifier;
        }

        public void setTagIdentifier(TagId tagIdentifier) {
            this.tagIdentifier = tagIdentifier;
        }

        public boolean isTrimmed() {
            return this.trimmed;
        }

        public void setTrimmed(boolean trimmed) {
            this.trimmed = trimmed;
        }

        public TagRange getParent() {
            return this.parent;
        }

        public void setParent(TagRange parent) {
            this.parent = parent;
        }

        public void addELAttribute(TagAttribute attr, XMLTextRange nameRange, XMLTextRange valueRange, List<ELRange> elOffsets, ELParser elParser) {
            if (this.attributes == null) {
                this.attributes = new ArrayList<AttributeRange>(4);
            }
            AttributeRange attrRange = new AttributeRange(this, attr, nameRange, valueRange);
            attrRange.setELRanges(elOffsets);
            this.attributes.add(attrRange);
            this.getOrCreateAttrIndex().put(attr.getLocalName(), attrRange);
            if (elParser != null && elOffsets != null) {
                for (ELRange elRange : elOffsets) {
                    try {
                        String elText = elRange.getELText();
                        List<ELModelObjectSubExpression> modelObjects = elParser.getModelObjects(elText, elRange.getStartOffset());
                        elRange.addModelSubExprs(modelObjects);
                    }
                    catch (ELException e) {
                        elRange.addError(e);
                    }
                }
            }
        }

        public List<AttributeRange> getAttributes() {
            if (this.attributes == null) {
                return Collections.emptyList();
            }
            return Collections.unmodifiableList(this.attributes);
        }

        public AttributeRange getAttribute(String name) {
            return this.getOrCreateAttrIndex().get(name);
        }

        private Map<String, AttributeRange> getOrCreateAttrIndex() {
            if (this.attrIndex == null) {
                this.attrIndex = new HashMap<String, AttributeRange>();
            }
            return this.attrIndex;
        }
    }

    public static class TagRangeEntry
    extends SerializableMapEntry<Object, Object> {
        @XmlElement(name="tagid")
        public TagId getTagId() {
            return (TagId)this.getKey();
        }

        @XmlElements(value={@XmlElement(name="range")})
        public List<TagRange> getRanges() {
            return this.getValue();
        }
    }

    public static class TagRangeMapAdapter
    extends MapOfListXmlAdapter<ListOfTagRangeEntry, Map<Object, List<Object>>> {
        public TagRangeMapAdapter() {
            super(new MapOfListXmlAdapter.SerializableTypeFactory(){

                @Override
                protected SerializableMapEntry<Object, Object> createEntry() {
                    return new TagRangeEntry();
                }

                @Override
                protected ListOfSerializableMapEntry createListOfEntries() {
                    return new ListOfTagRangeEntry();
                }
            });
        }
    }
}

