/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.webtier.jsf.facelet.dtcontext;

import java.io.OutputStream;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import javax.faces.component.UIComponent;
import javax.faces.component.UIOutput;
import javax.faces.component.UIViewRoot;
import javax.faces.view.facelets.Tag;
import javax.faces.view.facelets.TagAttribute;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import oracle.eclipse.tools.webtier.jsf.facelet.DTFaceletContext;
import oracle.eclipse.tools.webtier.jsf.facelet.dtcompiler.DTLocation;
import oracle.eclipse.tools.webtier.jsf.facelet.dtcompiler.cu.DTCompilationUnit;
import oracle.eclipse.tools.webtier.jsf.facelet.dtcompiler.cu.DTIgnoredUnit;
import oracle.eclipse.tools.webtier.jsf.facelet.dtcompiler.cu.DTTagUnit;
import oracle.eclipse.tools.webtier.jsf.facelet.dtcompiler.el.ELParser;
import oracle.eclipse.tools.webtier.jsf.facelet.dtcontext.DesignTimeContextData;
import oracle.eclipse.tools.webtier.jsf.facelet.dtcontext.LocationBasedXMLTextRange;
import oracle.eclipse.tools.webtier.jsf.facelet.dtcontext.ParseError;
import oracle.eclipse.tools.webtier.jsf.facelet.dtcontext.TagError;
import oracle.eclipse.tools.webtier.jsf.facelet.dtcontext.TagIncludeError;
import oracle.eclipse.tools.webtier.jsf.facelet.dtcontext.TextLocation;
import oracle.eclipse.tools.webtier.jsf.facelet.dtcontext.XMLTextRange;
import org.apache.myfaces.view.facelets.AbstractFaceletContext;

public class DesignTimeContext {
    private DesignTimeContextData data = new DesignTimeContextData();
    private Map<String, Stack<DesignTimeContextData.NsRange>> prefixToNamespaceMappings;
    private Map<DesignTimeContextData.TagId, Stack<DesignTimeContextData.TagRange>> tagUsageRanges;
    private ELParser elParser = new ELParser();
    private Stack<DesignTimeContextData.TagRange> tagRangeStack = new Stack();
    private Object resourceKey;
    private static ThreadLocal<DesignTimeContext> curInstance = new ThreadLocal();

    public static DesignTimeContext getCurrentInstance() {
        DesignTimeContext designTimeContext = curInstance.get();
        return designTimeContext;
    }

    public static void setCurrentInstance(DesignTimeContext dtContext) {
        curInstance.set(dtContext);
    }

    public DesignTimeContext() {
    }

    public Object getResourceKey() {
        return this.resourceKey;
    }

    public void setResourceKey(Object resourceKey) {
        this.resourceKey = resourceKey;
    }

    public DesignTimeContext(URL compileUnitRoot) {
        this.data = new DesignTimeContextData(compileUnitRoot);
        this.prefixToNamespaceMappings = new HashMap<String, Stack<DesignTimeContextData.NsRange>>();
        this.tagUsageRanges = new HashMap<DesignTimeContextData.TagId, Stack<DesignTimeContextData.TagRange>>();
    }

    public DesignTimeContextData getData() {
        return this.data;
    }

    public void setData(DesignTimeContextData data) {
        this.data = data;
    }

    public void reportTagError(TagError tagError) {
        this.data.addTagError(tagError);
    }

    public void reportParseError(ParseError parseError) {
        this.data.addParseError(parseError);
    }

    public void reportIncludeError(TagIncludeError includeError) {
        this.data.addTagIncludeError(includeError);
    }

    public void reportInclude(AbstractFaceletContext ctx, URL root, URL includedFile) {
        if (root == null) {
            root = this.data.getCompileUnitRoot();
        }
        URL includingFile = root;
        if (ctx instanceof DTFaceletContext) {
            includingFile = ((DTFaceletContext)ctx).getCurrentIncludeFacelet();
        }
        DesignTimeContextData.IncludeReference includeReference = new DesignTimeContextData.IncludeReference(root, includingFile, includedFile);
        this.data.addIncludeReference(includingFile != null ? includingFile : root, includeReference);
    }

    public void reportStartNamespace(String uri, String prefix, TextLocation textLocation) {
        DesignTimeContextData.NsRange range = new DesignTimeContextData.NsRange();
        range.setUri(uri);
        range.setStartLocation(textLocation);
        Stack<DesignTimeContextData.NsRange> nsStack = this.getOrCreatePrefixToNsMapping(prefix);
        nsStack.push(range);
    }

    public void reportEndNamespace(String prefix, TextLocation textLocation) {
        Stack<DesignTimeContextData.NsRange> nsStack = this.getOrCreatePrefixToNsMapping(prefix);
        DesignTimeContextData.NsRange range = nsStack.pop();
        range.setEndLocation(textLocation);
        this.data.addNamespaceRange(range);
    }

    public void reportStartUnit(DTCompilationUnit unit, XMLTextRange textRange) {
        if (unit instanceof DTTagUnit) {
            Tag tag = ((DTTagUnit)unit).getTag();
            DesignTimeContextData.TagId tagId = this.createTagId(tag);
            Stack<DesignTimeContextData.TagRange> stack = this.getOrCreateTagStack(tagId);
            DesignTimeContextData.TagRange tagRange = new DesignTimeContextData.TagRange(textRange);
            tagRange.setTagIdentifier(tagId);
            tagRange.setTagId(((DTTagUnit)unit).getTagId());
            stack.push(tagRange);
            DesignTimeContextData.TagRange parent = null;
            if (!this.tagRangeStack.isEmpty()) {
                parent = this.tagRangeStack.peek();
            }
            tagRange.setParent(parent);
            this.tagRangeStack.push(tagRange);
        }
    }

    public void reportEndUnit(DTTagUnit t, XMLTextRange textRange) {
        if (t instanceof DTTagUnit) {
            this.handleEndOfTagUnit(t, textRange);
        }
    }

    private void handleEndOfTagUnit(DTTagUnit t, XMLTextRange textRange) {
        Tag tag = t.getTag();
        Stack<DesignTimeContextData.TagRange> stack = this.getTagRangeStack(tag);
        DesignTimeContextData.TagRange pop = stack.pop();
        assert (pop != null);
        pop.setEndTagRange(textRange);
        this.data.addTagRange(pop);
        this.tagRangeStack.pop();
    }

    private DesignTimeContextData.TagId createTagId(Tag tag) {
        return new DesignTimeContextData.TagId(tag.getNamespace(), tag.getLocalName());
    }

    public void reportDiscardedTagUnit(DTIgnoredUnit item) {
        DTCompilationUnit trimmedUnit = item.getTrimmedUnit();
        if (trimmedUnit instanceof DTTagUnit) {
            Tag tag = ((DTTagUnit)trimmedUnit).getTag();
            Stack<DesignTimeContextData.TagRange> stack = this.getTagRangeStack(tag);
            int i = 0;
            while (i < stack.size()) {
                DesignTimeContextData.TagRange tagRange = (DesignTimeContextData.TagRange)stack.get(i);
                if (tagRange.getTagId().equals(((DTTagUnit)trimmedUnit).getTagId())) {
                    tagRange.setTrimmed(true);
                    break;
                }
                ++i;
            }
        }
    }

    private Stack<DesignTimeContextData.TagRange> getTagRangeStack(Tag tag) {
        DesignTimeContextData.TagId tagId = this.createTagId(tag);
        Stack<DesignTimeContextData.TagRange> stack = this.getOrCreateTagStack(tagId);
        return stack;
    }

    public void reportLiteralAttribute(Tag tag, TagAttribute attr, XMLTextRange nameRange, XMLTextRange valueRange) {
        this.reportAttributeWithEL(tag, attr, nameRange, valueRange, null);
    }

    public void reportAttributeWithEL(Tag tag, TagAttribute attr, XMLTextRange nameRange, XMLTextRange valueRange, List<DesignTimeContextData.ELRange> elOffsets) {
        Stack<DesignTimeContextData.TagRange> stack = this.getTagRangeStack(tag);
        DesignTimeContextData.TagRange tagRange = stack.peek();
        tagRange.addELAttribute(attr, nameRange, valueRange, elOffsets, this.elParser);
    }

    public void reportEndDiscardedTagUnit(DTIgnoredUnit unit, XMLTextRange range) {
        DTCompilationUnit trimmedUnit = unit.getTrimmedUnit();
        if (trimmedUnit instanceof DTTagUnit) {
            this.handleEndOfTagUnit((DTTagUnit)trimmedUnit, range);
        }
    }

    private Stack<DesignTimeContextData.TagRange> getOrCreateTagStack(DesignTimeContextData.TagId tag) {
        Stack<DesignTimeContextData.TagRange> stack = this.tagUsageRanges.get(tag);
        if (stack == null) {
            stack = new Stack();
            this.tagUsageRanges.put(tag, stack);
        }
        return stack;
    }

    public Map<String, Stack<DesignTimeContextData.NsRange>> getPrefixToNamespaceMappings() {
        return this.prefixToNamespaceMappings;
    }

    private Stack<DesignTimeContextData.NsRange> getOrCreatePrefixToNsMapping(String prefix) {
        Stack<DesignTimeContextData.NsRange> stack = this.getPrefixToNamespaceMappings().get(prefix);
        if (stack == null) {
            stack = new Stack();
            this.getPrefixToNamespaceMappings().put(prefix, stack);
        }
        return stack;
    }

    public void printXmlReport(OutputStream out) throws JAXBException {
        JAXBContext newInstance = JAXBContext.newInstance((Class[])new Class[]{DesignTimeContextData.class});
        Marshaller marshaller = newInstance.createMarshaller();
        marshaller.marshal((Object)this.data, out);
    }

    public void visit(UIComponent componentRoot) {
        this.processComponent(componentRoot);
        for (UIComponent child : componentRoot.getChildren()) {
            this.visit(child);
        }
    }

    private void processComponent(UIComponent componentRoot) {
        if (componentRoot instanceof UIViewRoot) {
            System.out.printf("View Root: %s\n", ((UIViewRoot)componentRoot).getViewId());
        } else if (componentRoot instanceof UIOutput) {
            System.out.printf("UIOutput: %s\n", ((UIOutput)componentRoot).getValue());
        }
    }

    public void reportELText(DesignTimeContextData.ELRange range) {
        this.data.addELTextRange(range, this.elParser);
    }

    public void reportMissingRequiredAttribute(Tag tag, String name) {
        XMLTextRange textRange = tag.getLocation() instanceof DTLocation ? ((DTLocation)tag.getLocation()).getStartElementRange() : new LocationBasedXMLTextRange.XMLTextRangeWorkingCopy();
        this.data.addTagError(new TagError(tag.getNamespace(), tag.getLocalName(), String.format("Required attribute missing %s", name), textRange));
    }
}

