/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.webtier.jsf.facelet.dtcompiler.instruction;

import java.io.IOException;
import javax.el.ELContext;
import javax.el.ELException;
import javax.el.ExpressionFactory;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import oracle.eclipse.tools.webtier.jsf.facelet.dtcompiler.instruction.DTInstruction;
import org.apache.myfaces.view.facelets.el.ELText;

public final class DTAttributeInstruction
implements DTInstruction {
    private final String _alias;
    private final String _attr;
    private final ELText _txt;

    public DTAttributeInstruction(String alias, String attr, ELText txt) {
        this._alias = alias;
        this._attr = attr;
        this._txt = txt;
    }

    @Override
    public void write(FacesContext context) throws IOException {
        ResponseWriter out = context.getResponseWriter();
        try {
            out.writeAttribute(this._attr, this._txt.toString(context.getELContext()), null);
        }
        catch (ELException e) {
            throw new ELException(String.valueOf(this._alias) + ": " + e.getMessage(), e.getCause());
        }
        catch (Exception e) {
            throw new ELException(String.valueOf(this._alias) + ": " + e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public DTInstruction apply(ExpressionFactory factory, ELContext ctx) {
        ELText nt = this._txt.apply(factory, ctx);
        if (nt == this._txt) {
            return this;
        }
        return new DTAttributeInstruction(this._alias, this._attr, nt);
    }

    @Override
    public boolean isLiteral() {
        return this._txt.isLiteral();
    }
}

