/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.webtier.jsf.facelet.dtcompiler.cu;

import java.util.List;
import javax.faces.view.facelets.FaceletHandler;
import javax.faces.view.facelets.Tag;
import javax.faces.view.facelets.TagAttribute;
import javax.faces.view.facelets.TagAttributes;
import javax.faces.view.facelets.TagConfig;
import javax.faces.view.facelets.TagHandler;
import oracle.eclipse.tools.webtier.jsf.facelet.dtcompiler.DTLocation;
import oracle.eclipse.tools.webtier.jsf.facelet.dtcompiler.cu.DTCompilationUnit;
import oracle.eclipse.tools.webtier.jsf.facelet.dtcompiler.handler.FaceletHandlerWrapper;
import oracle.eclipse.tools.webtier.jsf.facelet.dtcompiler.handler.MissingTagHandler;
import oracle.eclipse.tools.webtier.jsf.facelet.dtcontext.DesignTimeContext;
import oracle.eclipse.tools.webtier.jsf.facelet.dtcontext.DesignTimeContextData;
import oracle.eclipse.tools.webtier.jsf.facelet.dtcontext.TextLocationFactory;
import oracle.eclipse.tools.webtier.jsf.facelet.dtcontext.XMLTextRange;
import org.apache.myfaces.view.facelets.tag.TagLibrary;

public class DTTagUnit
extends DTCompilationUnit
implements TagConfig {
    private final TagLibrary library;
    private final String id;
    private final Tag tag;
    private final String namespace;
    private final String name;

    public DTTagUnit(TagLibrary library, String namespace, String name, Tag tag, String id) {
        this.library = library;
        this.tag = tag;
        this.namespace = namespace;
        this.name = name;
        this.id = id;
    }

    @Override
    public FaceletHandler createFaceletHandler() {
        TagHandler tagHandler = this.library.createTagHandler(this.namespace, this.name, this);
        if (tagHandler != null) {
            return new FaceletHandlerWrapper(tagHandler, TextLocationFactory.create((DTLocation)this.tag.getLocation()));
        }
        return new FaceletHandlerWrapper(new MissingTagHandler(this), TextLocationFactory.create((DTLocation)this.tag.getLocation()));
    }

    @Override
    public FaceletHandler getNextHandler() {
        return this.getNextFaceletHandler();
    }

    @Override
    public Tag getTag() {
        return this.tag;
    }

    @Override
    public String getTagId() {
        return this.id;
    }

    public String toString() {
        return this.tag.toString();
    }

    public void processAttributes(DesignTimeContext dtContext) {
        DTLocation location = (DTLocation)this.tag.getLocation();
        TagAttributes attributes = this.tag.getAttributes();
        TagAttribute[] tagAttributeArray = attributes.getAll();
        int n = tagAttributeArray.length;
        int n2 = 0;
        while (n2 < n) {
            TagAttribute attr = tagAttributeArray[n2];
            XMLTextRange attributeNameRange = location.getAttributeNameRange(attr.getLocalName());
            XMLTextRange attributeValueRange = location.getAttributeValueRange(attr.getLocalName());
            List<DesignTimeContextData.ELRange> elOffsets = location.getELOffsets(attr.getLocalName());
            if (elOffsets != null) {
                dtContext.reportAttributeWithEL(this.tag, attr, attributeNameRange, attributeValueRange, elOffsets);
            } else {
                dtContext.reportLiteralAttribute(this.tag, attr, attributeNameRange, attributeValueRange);
            }
            ++n2;
        }
    }
}

