/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.webtier.jsf.facelet.dtcompiler;

import com.ctc.wstx.stax.WstxInputFactory;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.logging.Level;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.el.ELException;
import javax.faces.FacesException;
import javax.faces.context.FacesContext;
import javax.faces.view.facelets.FaceletException;
import javax.faces.view.facelets.FaceletHandler;
import javax.faces.view.facelets.Tag;
import javax.faces.view.facelets.TagAttribute;
import javax.faces.view.facelets.TagAttributes;
import javax.xml.stream.Location;
import javax.xml.stream.XMLResolver;
import javax.xml.stream.XMLStreamException;
import oracle.eclipse.tools.webtier.jsf.facelet.Activator;
import oracle.eclipse.tools.webtier.jsf.facelet.dtcompiler.DTCompilationManager;
import oracle.eclipse.tools.webtier.jsf.facelet.dtcompiler.DTLocation;
import oracle.eclipse.tools.webtier.jsf.facelet.dtcompiler.DTTagAttributeImpl;
import oracle.eclipse.tools.webtier.jsf.facelet.dtcompiler.DTTagLibraryConfig;
import oracle.eclipse.tools.webtier.jsf.facelet.dtcompiler.OffsetRecordingBufferedReader;
import oracle.eclipse.tools.webtier.jsf.facelet.dtcompiler.StaxStreamXMLReader;
import oracle.eclipse.tools.webtier.jsf.facelet.dtcompiler.handler.DTEncodingHandler;
import oracle.eclipse.tools.webtier.jsf.facelet.dtcontext.DesignTimeContext;
import oracle.eclipse.tools.webtier.jsf.facelet.dtcontext.TagError;
import oracle.eclipse.tools.webtier.jsf.facelet.dtcontext.TextLocationFactory;
import org.apache.myfaces.config.element.FaceletsProcessing;
import org.apache.myfaces.shared.util.ClassUtils;
import org.apache.myfaces.view.facelets.compiler.Compiler;
import org.apache.myfaces.view.facelets.compiler.FaceletsProcessingInstructions;
import org.apache.myfaces.view.facelets.tag.TagAttributesImpl;
import org.codehaus.stax2.XMLStreamReader2;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.ext.LexicalHandler;
import org.xml.sax.helpers.DefaultHandler;

public final class DTSAXCompiler
extends Compiler {
    private static final String defaultDTD;
    private static InputStream openStream;
    private static final Pattern XML_DECLARATION;
    private boolean isInitialized;
    private URL dtd;

    static {
        StringBuilder builder = new StringBuilder();
        URL dtd = ClassUtils.getResource("org/apache/myfaces/resource/default.dtd");
        if (dtd != null) {
            try {
                int numRead;
                openStream = dtd.openStream();
                InputStreamReader reader = new InputStreamReader(openStream);
                char[] buffer = new char[8192];
                while ((numRead = reader.read(buffer)) >= 0) {
                    builder.append(buffer, 0, numRead);
                }
            }
            catch (IOException e) {
                Activator.getDefault().getLog().log((IStatus)new Status(4, "oracle.eclipse.tools.webtier.jsf.facelet", "While opening dtd", (Throwable)e));
            }
        }
        defaultDTD = builder.toString();
        XML_DECLARATION = Pattern.compile("^<\\?xml.+?version=['\"](.+?)['\"](.+?encoding=['\"]((.+?))['\"])?.*?\\?>");
    }

    public DTSAXCompiler() {
        this.setDevelopmentProjectStage(true);
    }

    @Override
    public FaceletHandler doCompile(URL src, String alias) throws IOException, FaceletException, ELException, FacesException {
        if (!this.isInitialized) {
            this.initialize();
        }
        DTCompilationManager mngr = null;
        String encoding = null;
        try (BufferedReader is = null;){
            try {
                is = new OffsetRecordingBufferedReader(new InputStreamReader(src.openStream()), 1024);
                mngr = new DTCompilationManager(alias, this, this.getFaceletsProcessingInstructions(src, alias));
                CompilationHandler handler = new CompilationHandler(mngr, alias, this.dtd);
                XMLStreamReader2 xmlStreamReader = null;
                WstxInputFactory newFactory = new WstxInputFactory();
                newFactory.setProperty("javax.xml.stream.isValidating", this.isValidating());
                newFactory.setProperty("javax.xml.stream.isNamespaceAware", true);
                newFactory.setProperty("javax.xml.stream.isCoalescing", false);
                newFactory.setProperty("javax.xml.stream.isReplacingEntityReferences", false);
                newFactory.setXMLResolver(new XMLResolver(){

                    @Override
                    public Object resolveEntity(String publicID, String systemID, String baseURI, String namespace) throws XMLStreamException {
                        if (defaultDTD != null && !defaultDTD.isEmpty()) {
                            return defaultDTD;
                        }
                        if (DTSAXCompiler.this.dtd != null) {
                            return DTSAXCompiler.this.dtd;
                        }
                        String dtd = "org/apache/myfaces/resource/default.dtd";
                        URL resource = ClassUtils.getResource(dtd);
                        return resource;
                    }
                });
                xmlStreamReader = (XMLStreamReader2)newFactory.createXMLStreamReader(is);
                StaxStreamXMLReader reader = new StaxStreamXMLReader(xmlStreamReader, (OffsetRecordingBufferedReader)is);
                reader.setContentHandler(handler);
                reader.setProperty("http://xml.org/sax/properties/lexical-handler", handler);
                reader.setErrorHandler(handler);
                reader.setEntityResolver(handler);
                reader.parse("ignored");
                encoding = reader.getEncoding();
            }
            catch (FileNotFoundException fnfe) {
                throw fnfe;
            }
            catch (Exception e) {
                this.handleParseException(alias, e);
                if (is != null) {
                    is.close();
                }
                return null;
            }
        }
        return new DTEncodingHandler(mngr.createFaceletHandler(), encoding);
    }

    private void handleParseException(String alias, Exception e) {
        Throwable cause = e;
        while (cause != null) {
            if (cause instanceof XMLStreamException) {
                Location location = ((XMLStreamException)cause).getLocation();
                DesignTimeContext.getCurrentInstance().reportTagError(new TagError("", "", String.format("Error parsing file: %s", cause.getLocalizedMessage()), TextLocationFactory.create(location)));
                return;
            }
            cause = cause.getCause();
        }
        throw new FaceletException("Error Parsing " + alias + ": " + e.getMessage(), e.getCause() != null ? e.getCause() : e);
    }

    @Override
    protected synchronized void initialize() {
        block7: {
            block6: {
                if (this.isInitialized) {
                    return;
                }
                log.fine("Initializing");
                if (!this.createTagLibrary().containsNamespace("http://java.sun.com/jsf/facelets")) break block6;
                log.info("Skipping implicit load the META-INF directory of Facelets' Jar");
                this.isInitialized = true;
                return;
            }
            try {
                try {
                    DTTagLibraryConfig cfg = new DTTagLibraryConfig();
                    cfg.loadImplicit(FacesContext.getCurrentInstance(), this);
                    if (this.createTagLibrary().containsNamespace("http://java.sun.com/jsf/facelets")) break block7;
                    log.severe("Missing Built-in Tag Libraries! Make sure they are included within the META-INF directory of Facelets' Jar");
                }
                catch (IOException e) {
                    log.log(Level.SEVERE, "Compiler Initialization Error", e);
                    this.isInitialized = true;
                }
            }
            catch (Throwable throwable) {
                this.isInitialized = true;
                throw throwable;
            }
        }
        this.isInitialized = true;
        log.fine("Initialization Successful");
    }

    @Override
    protected FaceletHandler doCompileViewMetadata(URL src, String alias) throws IOException, FaceletException, ELException, FacesException {
        throw new UnsupportedOperationException("Need to convert to stax parsing");
    }

    @Override
    protected FaceletHandler doCompileCompositeComponentMetadata(URL src, String alias) throws IOException, FaceletException, ELException, FacesException {
        throw new UnsupportedOperationException("Need to convert to stax parsing");
    }

    protected FaceletsProcessingInstructions getFaceletsProcessingInstructions(URL src, String alias) {
        String processAs = null;
        boolean compressSpaces = false;
        for (FaceletsProcessing entry : this.getFaceletsProcessingConfigurations()) {
            if (!src.getPath().endsWith(entry.getFileExtension())) continue;
            processAs = entry.getProcessAs();
            compressSpaces = Boolean.valueOf(entry.getOamCompressSpaces());
            break;
        }
        return FaceletsProcessingInstructions.getProcessingInstructions(processAs, compressSpaces);
    }

    protected static final String writeXmlDecl(BufferedReader is, DTCompilationManager mngr) throws IOException {
        is.mark(128);
        String encoding = null;
        try {
            String r;
            Matcher m;
            char[] b = new char[128];
            if (is.read(b) > 0 && (m = XML_DECLARATION.matcher(r = new String(b))).find()) {
                if (!mngr.getFaceletsProcessingInstructions().isConsumeXmlDeclaration()) {
                    mngr.writeInstruction(null, String.valueOf(m.group(0)) + "\n");
                }
                if (m.group(3) != null) {
                    encoding = m.group(3);
                }
            }
        }
        finally {
            is.reset();
        }
        return encoding;
    }

    protected static final String getXmlDecl(InputStream is, DTCompilationManager mngr) throws IOException {
        is.mark(128);
        String encoding = null;
        try {
            String r;
            Matcher m;
            byte[] b = new byte[128];
            if (is.read(b) > 0 && (m = XML_DECLARATION.matcher(r = new String(b))).find() && m.group(3) != null) {
                encoding = m.group(3);
            }
        }
        finally {
            is.reset();
        }
        return encoding;
    }

    public void setDtd(URL dtd) {
        this.dtd = dtd;
    }

    private static class CompilationHandler
    extends DefaultHandler
    implements LexicalHandler {
        private final String alias;
        private boolean inDocument = false;
        private StaxStreamXMLReader.Locator3 locator;
        private final DTCompilationManager unit;
        private boolean consumingCDATA = false;
        private boolean swallowCDATAContent = false;
        private URL dtd;

        public CompilationHandler(DTCompilationManager unit, String alias, URL dtd) {
            this.unit = unit;
            this.alias = alias;
            this.dtd = dtd;
        }

        @Override
        public void characters(char[] ch, int start, int length) throws SAXException {
            if (this.inDocument && (!this.consumingCDATA || this.consumingCDATA && !this.swallowCDATAContent)) {
                this.unit.writeText(this.createLocation(), new String(ch, start, length));
            }
        }

        @Override
        public void comment(char[] ch, int start, int length) throws SAXException {
            if (this.inDocument && !this.unit.getFaceletsProcessingInstructions().isConsumeXMLComments()) {
                this.unit.writeComment(this.createLocation(), new String(ch, start, length));
            }
        }

        protected TagAttributes createAttributes(Attributes attrs) {
            int len = attrs.getLength();
            TagAttribute[] ta = new TagAttribute[len];
            int i = 0;
            while (i < len) {
                ta[i] = new DTTagAttributeImpl(this.createLocation(), attrs.getURI(i), attrs.getLocalName(i), attrs.getQName(i), attrs.getValue(i));
                ++i;
            }
            TagAttributesImpl tagAttributesImpl = new TagAttributesImpl(ta);
            return tagAttributesImpl;
        }

        protected DTLocation createLocation() {
            return new DTLocation(this.alias, this.locator.getLineNumber(), this.locator.getColumnNumber(), this.locator);
        }

        @Override
        public void endCDATA() throws SAXException {
            if (this.inDocument) {
                if (!this.unit.getFaceletsProcessingInstructions().isConsumeCDataSections()) {
                    this.unit.writeInstruction(this.createLocation(), "]]>");
                } else {
                    this.consumingCDATA = false;
                    this.swallowCDATAContent = false;
                }
            }
        }

        @Override
        public void endDocument() throws SAXException {
            super.endDocument();
        }

        @Override
        public void endDTD() throws SAXException {
            this.inDocument = true;
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            this.unit.popTag(this.createLocation());
        }

        @Override
        public void endEntity(String name) throws SAXException {
        }

        @Override
        public void endPrefixMapping(String prefix) throws SAXException {
            this.unit.popNamespace(prefix);
            DesignTimeContext.getCurrentInstance().reportEndNamespace(prefix, this.locator.getTextLocation());
        }

        @Override
        public void fatalError(SAXParseException e) throws SAXException {
            if (this.locator != null) {
                throw new SAXException("Error Traced[line: " + this.locator.getLineNumber() + "] " + e.getMessage(), e);
            }
            throw e;
        }

        @Override
        public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
            if (this.inDocument) {
                this.unit.writeWhitespace(this.createLocation(), new String(ch, start, length));
            }
        }

        @Override
        public InputSource resolveEntity(String publicId, String systemId) throws SAXException {
            if (this.dtd != null) {
                InputSource inputSource = new InputSource(this.dtd.toString());
                return inputSource;
            }
            String dtdStr = "org/apache/myfaces/resource/default.dtd";
            URL url = ClassUtils.getResource(dtdStr);
            InputSource inputSource = new InputSource(url.toString());
            return inputSource;
        }

        @Override
        public void setDocumentLocator(Locator locator) {
            this.locator = (StaxStreamXMLReader.Locator3)locator;
        }

        @Override
        public void startCDATA() throws SAXException {
            if (this.inDocument) {
                if (!this.unit.getFaceletsProcessingInstructions().isConsumeCDataSections()) {
                    this.unit.writeInstruction(this.createLocation(), "<![CDATA[");
                } else {
                    this.consumingCDATA = true;
                    this.swallowCDATAContent = this.unit.getFaceletsProcessingInstructions().isSwallowCDataContent();
                }
            }
        }

        @Override
        public void startDocument() throws SAXException {
            this.inDocument = true;
        }

        @Override
        public void startDTD(String name, String publicId, String systemId) throws SAXException {
            if (this.inDocument && !this.unit.getFaceletsProcessingInstructions().isConsumeXmlDocType()) {
                StringBuffer sb = new StringBuffer(64);
                sb.append("<!DOCTYPE ").append(name);
                if (publicId != null) {
                    sb.append(" PUBLIC \"").append(publicId).append("\"");
                    if (systemId != null) {
                        sb.append(" \"").append(systemId).append("\"");
                    }
                } else if (systemId != null) {
                    sb.append(" SYSTEM \"").append(systemId).append("\"");
                }
                sb.append(" >\n");
                this.unit.writeInstruction(this.createLocation(), sb.toString());
            }
            this.inDocument = false;
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            this.unit.pushTag(new Tag(this.createLocation(), uri, localName, qName, this.createAttributes(attributes)));
        }

        @Override
        public void startEntity(String name) throws SAXException {
        }

        @Override
        public void startPrefixMapping(String prefix, String uri) throws SAXException {
            DTLocation createLocation = this.createLocation();
            this.unit.pushNamespace(createLocation, prefix, uri);
            DesignTimeContext.getCurrentInstance().reportStartNamespace(uri, prefix, this.locator.getTextLocation());
        }

        @Override
        public void processingInstruction(String target, String data) throws SAXException {
            if (this.inDocument && !this.unit.getFaceletsProcessingInstructions().isConsumeProcessingInstructions()) {
                StringBuffer sb = new StringBuffer(64);
                sb.append("<?").append(target).append(' ').append(data).append("?>\n");
                this.unit.writeInstruction(this.createLocation(), sb.toString());
            }
        }

        @Override
        public void warning(SAXParseException e) throws SAXException {
            System.out.println(e);
        }

        @Override
        public void error(SAXParseException e) throws SAXException {
            System.out.println(e);
        }
    }
}

