/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.webtier.jsf.facelet.dtcompiler;

import java.util.List;
import javax.xml.namespace.QName;
import javax.xml.stream.Location;
import javax.xml.stream.XMLStreamException;
import oracle.eclipse.tools.webtier.jsf.facelet.dtcompiler.BufferReparser;
import oracle.eclipse.tools.webtier.jsf.facelet.dtcompiler.OffsetRecordingBufferedReader;
import oracle.eclipse.tools.webtier.jsf.facelet.dtcompiler.StaxStreamXMLReader;
import oracle.eclipse.tools.webtier.jsf.facelet.dtcontext.DesignTimeContextData;
import oracle.eclipse.tools.webtier.jsf.facelet.dtcontext.LocationBasedXMLTextRange;
import oracle.eclipse.tools.webtier.jsf.facelet.dtcontext.TextLocation;
import oracle.eclipse.tools.webtier.jsf.facelet.dtcontext.TextLocationFactory;
import oracle.eclipse.tools.webtier.jsf.facelet.dtcontext.XMLTextRange;
import org.codehaus.stax2.LocationInfo;
import org.codehaus.stax2.XMLStreamLocation2;

public class DTLocator3
implements StaxStreamXMLReader.Locator3 {
    private final LocationInfo locationInfo;
    private final String xmlVersion;
    private final String encoding;
    private final BufferReparser reparser;
    private final String prefix;
    private final QName elemName;
    private final int numAttrs;
    private final Location location;

    public DTLocator3(Location location, LocationInfo locationInfo, String xmlVersion, String encoding, String prefix, QName elemName, int numAttrs, OffsetRecordingBufferedReader bfr) {
        this.location = location;
        this.locationInfo = new MyLocationInfo(locationInfo);
        this.xmlVersion = xmlVersion;
        this.encoding = encoding;
        this.reparser = new BufferReparser();
        this.prefix = prefix;
        this.elemName = elemName;
        this.numAttrs = numAttrs;
        this.initIfNecessary(bfr);
    }

    @Override
    public int getColumnNumber() {
        return this.location != null ? this.location.getColumnNumber() : -1;
    }

    @Override
    public int getLineNumber() {
        return this.location != null ? this.location.getLineNumber() : -1;
    }

    @Override
    public String getPublicId() {
        return this.location != null ? this.location.getPublicId() : null;
    }

    @Override
    public String getSystemId() {
        return this.location != null ? this.location.getSystemId() : null;
    }

    @Override
    public String getXMLVersion() {
        return this.xmlVersion;
    }

    @Override
    public String getEncoding() {
        return this.encoding;
    }

    @Override
    public int getCharacterOffset() {
        return this.location != null ? Integer.valueOf(this.location.getCharacterOffset()) : null;
    }

    @Override
    public Location getLocation() {
        return this.location;
    }

    @Override
    public XMLTextRange getAttributeNameRange(String attrName) {
        BufferReparser.ExtendedAttributeInfo extendedAttributeInfo = this.reparser.getExtendedAttributeInfo(attrName);
        if (extendedAttributeInfo != null) {
            return extendedAttributeInfo.getNameRange();
        }
        return new LocationBasedXMLTextRange.XMLTextRangeWorkingCopy();
    }

    @Override
    public XMLTextRange getAttributeValueRange(String attrName) {
        BufferReparser.ExtendedAttributeInfo extendedAttributeInfo = this.reparser.getExtendedAttributeInfo(attrName);
        if (extendedAttributeInfo != null) {
            return extendedAttributeInfo.getValueRange();
        }
        return new LocationBasedXMLTextRange.XMLTextRangeWorkingCopy();
    }

    private void initIfNecessary(OffsetRecordingBufferedReader bfr) {
        if (!this.reparser.isInit()) {
            XMLTextRange range = TextLocationFactory.create(this.locationInfo);
            this.reparser.reparse(bfr, range, this.prefix, this.elemName, "1.1".equals(this.xmlVersion), this.numAttrs);
        }
    }

    @Override
    public List<DesignTimeContextData.ELRange> getELRanges(String attrName) {
        BufferReparser.ExtendedAttributeInfo extendedAttributeInfo = this.reparser.getExtendedAttributeInfo(attrName);
        if (extendedAttributeInfo != null) {
            return extendedAttributeInfo.getELRanges();
        }
        return null;
    }

    @Override
    public int getStartOffset() {
        return (int)this.locationInfo.getStartingCharOffset();
    }

    @Override
    public int getEndOffset() {
        try {
            return (int)this.locationInfo.getEndingCharOffset();
        }
        catch (XMLStreamException xMLStreamException) {
            return -1;
        }
    }

    @Override
    public XMLTextRange getElementRange() {
        return TextLocationFactory.create(this.locationInfo);
    }

    @Override
    public XMLTextRange getStartElementRange() {
        return LocationBasedXMLTextRange.create(this.reparser.getElementStartOffset(), this.reparser.getElementOpenTagEndOffset());
    }

    @Override
    public TextLocation getTextLocation() {
        TextLocation.TextLocationWorkingCopy location = new TextLocation.TextLocationWorkingCopy();
        location.setAbsOffset(this.getStartOffset());
        location.setLine(this.getLineNumber());
        location.setColumn(this.getColumnNumber());
        return location;
    }

    private static class MyLocationInfo
    implements LocationInfo {
        private XMLStreamLocation2 currentLocation;
        private XMLStreamLocation2 endLocation;
        private long endingByteOffset;
        private long endingCharOffset;
        private Location location;
        private XMLStreamLocation2 startLocation;
        private long startingByteOffset;
        private long startingCharOffset;

        public MyLocationInfo(LocationInfo cloneMe) {
            try {
                this.currentLocation = cloneMe.getCurrentLocation();
                this.endLocation = cloneMe.getEndLocation();
                this.endingByteOffset = cloneMe.getEndingByteOffset();
                this.endingCharOffset = cloneMe.getEndingCharOffset();
                this.location = cloneMe.getLocation();
                this.startLocation = cloneMe.getStartLocation();
                this.startingByteOffset = cloneMe.getStartingByteOffset();
                this.startingCharOffset = cloneMe.getStartingCharOffset();
            }
            catch (XMLStreamException e) {
                e.printStackTrace();
            }
        }

        public XMLStreamLocation2 getCurrentLocation() {
            return this.currentLocation;
        }

        public XMLStreamLocation2 getEndLocation() throws XMLStreamException {
            return this.endLocation;
        }

        public long getEndingByteOffset() throws XMLStreamException {
            return this.endingByteOffset;
        }

        public long getEndingCharOffset() throws XMLStreamException {
            return this.endingCharOffset;
        }

        public Location getLocation() {
            return this.location;
        }

        public XMLStreamLocation2 getStartLocation() {
            return this.startLocation;
        }

        public long getStartingByteOffset() {
            return this.startingByteOffset;
        }

        public long getStartingCharOffset() {
            return this.startingCharOffset;
        }
    }
}

