/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.webtier.jsf.facelet.dtcompiler;

import java.util.ArrayList;
import java.util.Stack;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.faces.view.Location;
import javax.faces.view.facelets.FaceletHandler;
import javax.faces.view.facelets.Tag;
import javax.faces.view.facelets.TagAttribute;
import javax.faces.view.facelets.TagAttributeException;
import javax.faces.view.facelets.TagDecorator;
import oracle.eclipse.tools.webtier.jsf.facelet.dtcompiler.DTLocation;
import oracle.eclipse.tools.webtier.jsf.facelet.dtcompiler.DTNamespaceManager;
import oracle.eclipse.tools.webtier.jsf.facelet.dtcompiler.cu.DTCompilationUnit;
import oracle.eclipse.tools.webtier.jsf.facelet.dtcompiler.cu.DTCompositeComponentUnit;
import oracle.eclipse.tools.webtier.jsf.facelet.dtcompiler.cu.DTIgnoredUnit;
import oracle.eclipse.tools.webtier.jsf.facelet.dtcompiler.cu.DTNamespaceUnit;
import oracle.eclipse.tools.webtier.jsf.facelet.dtcompiler.cu.DTRemoveUnit;
import oracle.eclipse.tools.webtier.jsf.facelet.dtcompiler.cu.DTTagUnit;
import oracle.eclipse.tools.webtier.jsf.facelet.dtcompiler.cu.DTTextUnit;
import oracle.eclipse.tools.webtier.jsf.facelet.dtcompiler.cu.DTTrimmedTagUnit;
import oracle.eclipse.tools.webtier.jsf.facelet.dtcompiler.cu.UnknownDTTagUnit;
import oracle.eclipse.tools.webtier.jsf.facelet.dtcontext.DesignTimeContext;
import oracle.eclipse.tools.webtier.jsf.facelet.dtcontext.LocationBasedXMLTextRange;
import oracle.eclipse.tools.webtier.jsf.facelet.dtcontext.TagError;
import oracle.eclipse.tools.webtier.jsf.facelet.dtcontext.XMLTextRange;
import org.apache.myfaces.view.facelets.compiler.Compiler;
import org.apache.myfaces.view.facelets.compiler.FaceletsProcessingInstructions;
import org.apache.myfaces.view.facelets.tag.TagAttributesImpl;
import org.apache.myfaces.view.facelets.tag.TagLibrary;

public final class DTCompilationManager {
    private static final Logger log = Logger.getLogger(DTCompilationManager.class.getName());
    private final Compiler compiler;
    private final TagLibrary tagLibrary;
    private final TagDecorator tagDecorator;
    private final DTNamespaceManager namespaceManager;
    private final Stack<DTCompilationUnit> units;
    private int tagId;
    private boolean finished;
    private final String alias;
    private DTCompilationUnit interfaceCompilationUnit;
    private final FaceletsProcessingInstructions faceletsProcessingInstructions;
    private DTTagUnit root;

    public DTCompilationManager(String alias, Compiler compiler, FaceletsProcessingInstructions instructions) {
        this.alias = alias;
        this.compiler = compiler;
        this.tagDecorator = compiler.createTagDecorator();
        this.tagLibrary = compiler.createTagLibrary();
        this.namespaceManager = new DTNamespaceManager();
        this.tagId = 0;
        this.finished = false;
        this.units = new Stack();
        this.units.push(new DTCompilationUnit());
        this.interfaceCompilationUnit = null;
        this.faceletsProcessingInstructions = instructions;
    }

    public void writeInstruction(DTLocation location, String value) {
        DTTextUnit unit;
        if (this.finished) {
            return;
        }
        if (value.length() == 0) {
            return;
        }
        if (this.currentUnit() instanceof DTTextUnit) {
            unit = (DTTextUnit)this.currentUnit();
        } else {
            unit = new DTTextUnit(this.alias, this.nextTagId(), this.faceletsProcessingInstructions.isEscapeInlineText(), this.faceletsProcessingInstructions.isCompressSpaces(), location);
            this.startUnit(unit, new LocationBasedXMLTextRange.XMLTextRangeWorkingCopy());
        }
        unit.writeInstruction(value);
    }

    public void writeText(DTLocation dtLocation, String value) {
        DTTextUnit unit;
        if (this.finished) {
            return;
        }
        if (value.length() == 0) {
            return;
        }
        if (this.currentUnit() instanceof DTTextUnit) {
            unit = (DTTextUnit)this.currentUnit();
        } else {
            unit = new DTTextUnit(this.alias, this.nextTagId(), this.faceletsProcessingInstructions.isEscapeInlineText(), this.faceletsProcessingInstructions.isCompressSpaces(), dtLocation);
            this.startUnit(unit, new LocationBasedXMLTextRange.XMLTextRangeWorkingCopy());
        }
        unit.write(value, dtLocation.getStartOffset());
    }

    public void writeComment(DTLocation dtLocation, String text) {
        DTTextUnit unit;
        if (this.compiler.isTrimmingComments()) {
            return;
        }
        if (this.finished) {
            return;
        }
        if (text.length() == 0) {
            return;
        }
        if (this.currentUnit() instanceof DTTextUnit) {
            unit = (DTTextUnit)this.currentUnit();
        } else {
            unit = new DTTextUnit(this.alias, this.nextTagId(), this.faceletsProcessingInstructions.isEscapeInlineText(), this.faceletsProcessingInstructions.isCompressSpaces(), dtLocation);
            this.startUnit(unit, new LocationBasedXMLTextRange.XMLTextRangeWorkingCopy());
        }
        unit.writeComment(text);
    }

    public void writeWhitespace(DTLocation location, String text) {
        if (!this.compiler.isTrimmingWhitespace()) {
            this.writeText(location, text);
        }
    }

    private String nextTagId() {
        return Integer.toHexString(Math.abs(this.alias.hashCode() ^ 13 * this.tagId++));
    }

    public void pushTag(Tag orig) {
        if (this.finished) {
            return;
        }
        if (log.isLoggable(Level.FINE)) {
            log.fine("Tag Pushed: " + orig);
        }
        Tag t = this.tagDecorator.decorate(orig);
        String[] qname = this.determineQName(t);
        t = this.trimAttributes(t);
        DTLocation dtLocation = (DTLocation)t.getLocation();
        XMLTextRange textRange = dtLocation.getElementRange();
        if (DTCompilationManager.isTrimmed(qname[0], qname[1])) {
            log.fine("Composition Found, Popping Parent Tags");
            ArrayList<DTCompilationUnit> copy = new ArrayList<DTCompilationUnit>(this.units);
            this.units.clear();
            for (DTCompilationUnit dtCompUnit : copy) {
                DTIgnoredUnit item = new DTIgnoredUnit(dtCompUnit);
                DesignTimeContext.getCurrentInstance().reportDiscardedTagUnit(item);
                this.units.push(item);
            }
            DTNamespaceUnit nsUnit = this.namespaceManager.toNamespaceUnit(this.tagLibrary);
            this.units.push(nsUnit);
            DTTrimmedTagUnit unit = new DTTrimmedTagUnit(this.tagLibrary, qname[0], qname[1], t, this.nextTagId());
            this.startUnit(unit, textRange);
            unit.processAttributes(DesignTimeContext.getCurrentInstance());
            log.fine("New Namespace and [Trimmed] TagUnit pushed");
        } else if (DTCompilationManager.isRemove(qname[0], qname[1])) {
            this.units.push(new DTRemoveUnit());
        } else if (DTCompilationManager.isCompositeComponentInterface(qname[0], qname[1])) {
            log.fine("Composite Component Interface Found, saving unit");
            DTCompositeComponentUnit compositeRootCompilationUnit = new DTCompositeComponentUnit();
            this.startUnit(compositeRootCompilationUnit, textRange);
            this.interfaceCompilationUnit = new DTTagUnit(this.tagLibrary, qname[0], qname[1], t, this.nextTagId());
            this.startUnit(this.interfaceCompilationUnit, textRange);
        } else if (DTCompilationManager.isCompositeComponentImplementation(qname[0], qname[1])) {
            log.fine("Composite component Found, Popping Parent Tags");
            this.units.clear();
            DTNamespaceUnit nsUnit = this.namespaceManager.toNamespaceUnit(this.tagLibrary);
            this.units.push(nsUnit);
            DTCompositeComponentUnit compositeRootCompilationUnit = new DTCompositeComponentUnit();
            this.startUnit(compositeRootCompilationUnit, textRange);
            if (this.interfaceCompilationUnit != null) {
                this.currentUnit().addChild(this.interfaceCompilationUnit);
                this.interfaceCompilationUnit = null;
            }
            DTTrimmedTagUnit unit = new DTTrimmedTagUnit(this.tagLibrary, qname[0], qname[1], t, this.nextTagId());
            this.startUnit(unit, textRange);
            unit.processAttributes(DesignTimeContext.getCurrentInstance());
            log.fine("New Namespace and TagUnit pushed");
        } else if (this.tagLibrary.containsTagHandler(qname[0], qname[1])) {
            DTTagUnit unit = new DTTagUnit(this.tagLibrary, qname[0], qname[1], t, this.nextTagId());
            this.startUnit(unit, textRange);
            unit.processAttributes(DesignTimeContext.getCurrentInstance());
        } else if (this.tagLibrary.containsNamespace(qname[0])) {
            DesignTimeContext.getCurrentInstance().reportTagError(new TagError(qname[0], qname[1], "Tag Library supports namespace: " + qname[0] + ", but no tag was defined for name: " + qname[1], textRange));
            this.startUnit(new UnknownDTTagUnit(this.tagLibrary, qname[0], qname[1], t, this.nextTagId()), textRange);
        } else {
            DTTextUnit unit;
            if (this.currentUnit() instanceof DTTextUnit) {
                unit = (DTTextUnit)this.currentUnit();
            } else {
                unit = new DTTextUnit(this.alias, this.nextTagId(), this.faceletsProcessingInstructions.isEscapeInlineText(), this.faceletsProcessingInstructions.isCompressSpaces(), dtLocation);
                this.startUnit(unit, textRange);
            }
            if (this.compiler.isDevelopmentProjectStage()) {
                String qName = null;
                TagAttribute jsfc = t.getAttributes().get("jsfc");
                if (jsfc != null) {
                    qName = jsfc.getValue();
                    jsfc.getValue().indexOf(58);
                } else if (t.getQName().indexOf(58) > 0) {
                    qName = t.getQName();
                }
                if (!"http://www.w3.org/1999/xhtml".equals(qname[0]) && !"".equals(qname[0])) {
                    DesignTimeContext.getCurrentInstance().reportTagError(new TagError(qname[0], qname[1], "Warning: The page " + this.alias + " declares namespace " + qname[0] + " and uses the tag " + qName + " , but no TagLibrary associated to namespace.", dtLocation.getElementRange()));
                }
            }
            unit.startTag(t);
        }
    }

    public void popTag(DTLocation location) {
        DTCompilationUnit t;
        if (this.finished) {
            boolean donePopping = false;
            while (!this.units.isEmpty() && !donePopping) {
                DTCompilationUnit unit = this.currentUnit();
                if (unit instanceof DTIgnoredUnit && ((DTIgnoredUnit)unit).getTrimmedUnit() instanceof DTTagUnit) {
                    DesignTimeContext.getCurrentInstance().reportEndDiscardedTagUnit((DTIgnoredUnit)unit, location.getElementRange());
                    donePopping = true;
                }
                this.finishUnit();
            }
            return;
        }
        DTCompilationUnit unit = this.currentUnit();
        if (unit instanceof DTTextUnit) {
            t = (DTTextUnit)unit;
            if (t.isClosed()) {
                this.finishUnit();
            } else {
                t.endTag();
                return;
            }
        }
        if ((unit = this.currentUnit()) instanceof DTTagUnit) {
            t = (DTTagUnit)unit;
            if (t instanceof DTTrimmedTagUnit) {
                this.finished = true;
                DesignTimeContext.getCurrentInstance().reportEndUnit((DTTagUnit)t, location.getElementRange());
                this.root = t;
                this.finishUnit();
                return;
            }
            DesignTimeContext.getCurrentInstance().reportEndUnit((DTTagUnit)t, location.getElementRange());
        } else if (unit instanceof DTCompositeComponentUnit) {
            this.finished = true;
            return;
        }
        this.finishUnit();
    }

    public void popTag() {
        this.popTag(null);
    }

    public void popNamespace(String ns) {
        this.namespaceManager.popNamespace(ns);
        if (this.currentUnit() instanceof DTNamespaceUnit) {
            this.finishUnit();
        }
    }

    public void pushNamespace(Location location, String prefix, String uri) {
        DTNamespaceUnit unit;
        if (log.isLoggable(Level.FINE)) {
            log.fine("Namespace Pushed " + prefix + ": " + uri);
        }
        this.namespaceManager.pushNamespace(location, prefix, uri);
        if (this.currentUnit() instanceof DTNamespaceUnit) {
            unit = (DTNamespaceUnit)this.currentUnit();
        } else {
            unit = new DTNamespaceUnit(this.tagLibrary);
            this.startUnit(unit, ((DTLocation)location).getElementRange());
        }
        unit.setNamespace(prefix, uri);
    }

    public FaceletHandler createFaceletHandler() {
        if (this.root != null) {
            return this.root.createFaceletHandler();
        }
        return null;
    }

    private DTCompilationUnit currentUnit() {
        if (!this.units.isEmpty()) {
            return this.units.peek();
        }
        return null;
    }

    private void finishUnit() {
        DTCompilationUnit obj = this.units.pop();
        if (obj instanceof DTTagUnit) {
            this.root = (DTTagUnit)obj;
        }
        if (log.isLoggable(Level.FINE)) {
            log.fine("Finished Unit: " + obj);
        }
    }

    private void startUnit(DTCompilationUnit unit, XMLTextRange textRange) {
        if (log.isLoggable(Level.FINE)) {
            log.fine("Starting Unit: " + unit + " and adding it to parent: " + this.currentUnit());
        }
        this.currentUnit().addChild(unit);
        DesignTimeContext.getCurrentInstance().reportStartUnit(unit, textRange);
        this.units.push(unit);
    }

    private Tag trimAttributes(Tag tag) {
        Tag t = this.trimJSFCAttribute(tag);
        t = this.trimNSAttributes(t);
        return t;
    }

    protected static boolean isRemove(String ns, String name) {
        return "http://java.sun.com/jsf/facelets".equals(ns) && "remove".equals(name);
    }

    protected static boolean isTrimmed(String ns, String name) {
        return "http://java.sun.com/jsf/facelets".equals(ns) && ("composition".equals(name) || "component".equals(name));
    }

    protected static boolean isCompositeComponentInterface(String ns, String name) {
        return "http://java.sun.com/jsf/composite".equals(ns) && "interface".equals(name);
    }

    protected static boolean isCompositeComponentImplementation(String ns, String name) {
        return "http://java.sun.com/jsf/composite".equals(ns) && "implementation".equals(name);
    }

    private String[] determineQName(Tag tag) {
        TagAttribute attr = tag.getAttributes().get("jsfc");
        if (attr != null) {
            String localName;
            String namespace;
            String value;
            int c;
            if (log.isLoggable(Level.FINE)) {
                log.fine(attr + " JSF Facelet Compile Directive Found");
            }
            if ((c = (value = attr.getValue()).indexOf(58)) == -1) {
                namespace = this.namespaceManager.getNamespace("");
                localName = value;
            } else {
                String prefix = value.substring(0, c);
                namespace = this.namespaceManager.getNamespace(prefix);
                if (namespace == null) {
                    throw new TagAttributeException(tag, attr, "No Namespace matched for: " + prefix);
                }
                localName = value.substring(c + 1);
            }
            return new String[]{namespace, localName};
        }
        return new String[]{tag.getNamespace(), tag.getLocalName()};
    }

    private Tag trimJSFCAttribute(Tag tag) {
        TagAttribute attr = tag.getAttributes().get("jsfc");
        if (attr != null) {
            TagAttribute[] oa = tag.getAttributes().getAll();
            TagAttribute[] na = new TagAttribute[oa.length - 1];
            int p = 0;
            int i = 0;
            while (i < oa.length) {
                if (!"jsfc".equals(oa[i].getLocalName())) {
                    na[p++] = oa[i];
                }
                ++i;
            }
            return new Tag(tag, new TagAttributesImpl(na));
        }
        return tag;
    }

    private Tag trimNSAttributes(Tag tag) {
        TagAttribute[] attr = tag.getAttributes().getAll();
        int remove = 0;
        int i = 0;
        while (i < attr.length) {
            if (attr[i].getQName().startsWith("xmlns") && this.tagLibrary.containsNamespace(attr[i].getValue())) {
                remove |= 1 << i;
                if (log.isLoggable(Level.FINE)) {
                    log.fine(attr[i] + " Namespace Bound to TagLibrary");
                }
            }
            ++i;
        }
        if (remove == 0) {
            return tag;
        }
        ArrayList<TagAttribute> attrList = new ArrayList<TagAttribute>(attr.length);
        int p = 0;
        int i2 = 0;
        while (i2 < attr.length) {
            p = 1 << i2;
            if ((p & remove) != p) {
                attrList.add(attr[i2]);
            }
            ++i2;
        }
        attr = attrList.toArray(new TagAttribute[attrList.size()]);
        return new Tag(tag.getLocation(), tag.getNamespace(), tag.getLocalName(), tag.getQName(), new TagAttributesImpl(attr));
    }

    public FaceletsProcessingInstructions getFaceletsProcessingInstructions() {
        return this.faceletsProcessingInstructions;
    }
}

