/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.webtier.jsf.facelet.cmdline;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URL;
import java.net.URLConnection;
import java.util.HashSet;
import java.util.Set;
import oracle.eclipse.tools.webtier.jsf.facelet.cmdline.JarInJarUrlConnection;
import org.osgi.service.url.AbstractURLStreamHandlerService;

public class MyURLHandlerService
extends AbstractURLStreamHandlerService {
    private Set<String> notFoundCache = new HashSet<String>();

    public URLConnection openConnection(URL u) throws IOException {
        if (this.notFoundCache.contains(u.toString())) {
            throw new FileNotFoundException();
        }
        try {
            int indexOfJarBang;
            String file;
            String protocol = u.getProtocol();
            if ("jarjar".equals(protocol) && (file = u.getFile()).startsWith("file:/") && (indexOfJarBang = file.indexOf("!")) > -1) {
                String realJarFile = "jar:" + file.substring(0, indexOfJarBang) + "!/";
                int nestedJarBang = file.indexOf("!", indexOfJarBang + 1);
                if (nestedJarBang > indexOfJarBang) {
                    String nestedFile = file.substring(indexOfJarBang + 1, nestedJarBang);
                    if (nestedFile != null && nestedFile.startsWith("/")) {
                        nestedFile = nestedFile.substring(1);
                    }
                    URL realUrl = new URL(String.valueOf(realJarFile) + nestedFile);
                    JarInJarUrlConnection jarInJarUrlConnection = new JarInJarUrlConnection(realUrl, file.substring(nestedJarBang + 1));
                    jarInJarUrlConnection.connect();
                    return jarInJarUrlConnection;
                }
                URL realUrl = new URL(realJarFile);
                return realUrl.openConnection();
            }
            throw new FileNotFoundException();
        }
        catch (FileNotFoundException nfe) {
            this.notFoundCache.add(u.toString());
            throw nfe;
        }
    }
}

