/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.webtier.jsf.facelet;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.URIUtil;

public class URLHandler {
    public URL getRelative(URL baseDir, String relativeObject) throws MalformedURLException {
        if (relativeObject.startsWith("/")) {
            relativeObject = relativeObject.substring(1);
        }
        try {
            URI uri = URIUtil.toURI((URL)baseDir);
            IPath ipath = org.eclipse.core.filesystem.URIUtil.toPath((URI)uri);
            ipath = ipath.append(relativeObject);
            uri = org.eclipse.core.filesystem.URIUtil.toURI((IPath)ipath);
            return uri.toURL();
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
            return null;
        }
    }

    public Set<String> getPaths(URL baseDir, String relativeObject) {
        if (relativeObject.startsWith("/")) {
            relativeObject = relativeObject.substring(1);
        }
        try {
            return this.handle(baseDir, relativeObject);
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return Collections.EMPTY_SET;
    }

    protected Set<String> handle(URL baseDir, String relativeObject) throws IOException, URISyntaxException {
        URI uri = URIUtil.toURI((URL)baseDir);
        File root = new File(uri);
        File file = new File(root, relativeObject);
        if (file.isDirectory()) {
            String[] list = file.list();
            int i = 0;
            while (i < list.length) {
                if (!list[i].startsWith("/") && !relativeObject.endsWith("/")) {
                    list[i] = "/" + list[i];
                }
                list[i] = "/" + relativeObject + list[i];
                ++i;
            }
            return new HashSet<String>(Arrays.asList(list));
        }
        return Collections.EMPTY_SET;
    }
}

