/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.webtier.jsf.facelet;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.net.URL;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.el.ELException;
import javax.el.ExpressionFactory;
import javax.faces.FacesException;
import javax.faces.application.Resource;
import javax.faces.component.UIComponent;
import javax.faces.component.UniqueIdVendor;
import javax.faces.context.FacesContext;
import javax.faces.view.facelets.FaceletException;
import javax.faces.view.facelets.FaceletHandler;
import oracle.eclipse.tools.webtier.jsf.facelet.DTDefaultFaceletFactory;
import oracle.eclipse.tools.webtier.jsf.facelet.DTFaceletContext;
import oracle.eclipse.tools.webtier.jsf.facelet.dtcompiler.handler.DTEncodingHandler;
import oracle.eclipse.tools.webtier.jsf.facelet.dtcontext.DesignTimeContext;
import oracle.eclipse.tools.webtier.jsf.facelet.dtcontext.TagIncludeError;
import org.apache.myfaces.view.facelets.AbstractFacelet;
import org.apache.myfaces.view.facelets.AbstractFaceletContext;
import org.apache.myfaces.view.facelets.FaceletCompositionContext;
import org.apache.myfaces.view.facelets.impl.FaceletCompositionContextImpl;
import org.apache.myfaces.view.facelets.impl.PageContextImpl;

public final class MockFacelet
extends AbstractFacelet {
    private static final Logger log = Logger.getLogger(MockFacelet.class.getName());
    private static final String APPLIED_KEY = "org.apache.myfaces.view.facelets.APPLIED";
    private final String _alias;
    private final String _faceletId;
    private final ExpressionFactory _elFactory;
    private final DTDefaultFaceletFactory _factory;
    private final long _createTime;
    private final long _refreshPeriod = 5000L;
    private final Map<String, URL> _relativePaths;
    private final FaceletHandler _root;
    private final URL _src;
    private final boolean _isBuildingCompositeComponentMetadata;

    public MockFacelet(DTDefaultFaceletFactory factory, ExpressionFactory el, URL src, String alias, String faceletId, FaceletHandler root) {
        this(factory, el, src, alias, faceletId, root, false);
    }

    public MockFacelet(DTDefaultFaceletFactory factory, ExpressionFactory el, URL src, String alias, String faceletId, FaceletHandler root, boolean isBuildingCompositeComponentMetadata) {
        this._factory = factory;
        this._elFactory = el;
        this._src = src;
        this._root = root;
        this._alias = alias;
        this._faceletId = faceletId;
        this._createTime = System.currentTimeMillis();
        this._relativePaths = new WeakHashMap<String, URL>();
        this._isBuildingCompositeComponentMetadata = isBuildingCompositeComponentMetadata;
    }

    @Override
    public void apply(FacesContext facesContext, UIComponent parent) throws IOException, FacesException, FaceletException, ELException {
        FaceletCompositionContext myFaceletContext = null;
        boolean faceletCompositionContextInitialized = false;
        boolean recordUniqueIds = false;
        myFaceletContext = FaceletCompositionContext.getCurrentInstance(facesContext);
        if (myFaceletContext == null) {
            myFaceletContext = new FaceletCompositionContextImpl(this._factory, facesContext);
            myFaceletContext.init(facesContext);
            faceletCompositionContextInitialized = true;
        }
        DTFaceletContext ctx = new DTFaceletContext(facesContext, (AbstractFacelet)this, myFaceletContext);
        facesContext.getAttributes().put("com.sun.faces.facelets.FACELET_CONTEXT", (Object)ctx);
        ctx.pushPageContext(new PageContextImpl());
        try {
            boolean pushedUniqueIdVendor = false;
            if (parent instanceof UniqueIdVendor && ctx.getFaceletCompositionContext().getUniqueIdVendorFromStack() == null) {
                ctx.getFaceletCompositionContext().pushUniqueIdVendorToStack((UniqueIdVendor)((Object)parent));
                pushedUniqueIdVendor = true;
            }
            this.refresh(parent);
            myFaceletContext.markForDeletion(parent);
            this._root.apply(ctx, parent);
            myFaceletContext.finalizeForDeletion(parent);
            this.markApplied(parent);
            if (pushedUniqueIdVendor) {
                ctx.getFaceletCompositionContext().popUniqueIdVendorToStack();
            }
        }
        finally {
            ctx.popPageContext();
            if (faceletCompositionContextInitialized) {
                myFaceletContext.release(facesContext);
                if (this._root instanceof DTEncodingHandler) {
                    List<String> uniqueIdList = ((DTEncodingHandler)this._root).getUniqueIdList();
                    if (recordUniqueIds && uniqueIdList == null) {
                        uniqueIdList = Collections.unmodifiableList(myFaceletContext.getUniqueIdList());
                        ((DTEncodingHandler)this._root).setUniqueIdList(uniqueIdList);
                    }
                }
            }
        }
    }

    private final void refresh(UIComponent c) {
        ApplyToken token;
        int sz = c.getChildCount();
        if (sz > 0) {
            UIComponent cc = null;
            List<UIComponent> cl = c.getChildren();
            while (--sz >= 0) {
                cc = cl.get(sz);
                if (cc.isTransient() || (token = (ApplyToken)cc.getAttributes().get(APPLIED_KEY)) == null || token._time >= this._createTime || !token._alias.equals(this._alias)) continue;
                if (log.isLoggable(Level.INFO)) {
                    DateFormat df = SimpleDateFormat.getTimeInstance();
                    log.info("Facelet[" + this._alias + "] was modified @ " + df.format(new Date(this._createTime)) + ", flushing component applied @ " + df.format(new Date(token._time)));
                }
                cl.remove(sz);
            }
        }
        if (c.getFacetCount() > 0) {
            Collection<UIComponent> col = c.getFacets().values();
            Iterator<UIComponent> itr = col.iterator();
            while (itr.hasNext()) {
                UIComponent fc = itr.next();
                if (fc.isTransient() || (token = (ApplyToken)fc.getAttributes().get(APPLIED_KEY)) == null || token._time >= this._createTime || !token._alias.equals(this._alias)) continue;
                if (log.isLoggable(Level.INFO)) {
                    DateFormat df = SimpleDateFormat.getTimeInstance();
                    log.info("Facelet[" + this._alias + "] was modified @ " + df.format(new Date(this._createTime)) + ", flushing component applied @ " + df.format(new Date(token._time)));
                }
                itr.remove();
            }
        }
    }

    private final void markApplied(UIComponent parent) {
        if (5000L > 0L) {
            int facetCount = parent.getFacetCount();
            int childCount = parent.getChildCount();
            if (childCount > 0 || facetCount > 0) {
                ApplyToken token = new ApplyToken(this._alias, System.currentTimeMillis() + 5000L);
                if (facetCount > 0) {
                    for (UIComponent facet : parent.getFacets().values()) {
                        this.markApplied(token, facet);
                    }
                }
                int i = 0;
                while (i < childCount) {
                    UIComponent child = parent.getChildren().get(i);
                    this.markApplied(token, child);
                    ++i;
                }
            }
        }
    }

    private void markApplied(ApplyToken token, UIComponent c) {
        Map<String, Object> attr;
        if (!c.isTransient() && !(attr = c.getAttributes()).containsKey(APPLIED_KEY)) {
            attr.put(APPLIED_KEY, token);
        }
    }

    @Override
    public String getAlias() {
        return this._alias;
    }

    @Override
    public String getFaceletId() {
        return this._faceletId;
    }

    @Override
    public ExpressionFactory getExpressionFactory() {
        return this._elFactory;
    }

    public long getCreateTime() {
        return this._createTime;
    }

    private URL getRelativePath(String path) throws IOException {
        URL url = this._relativePaths.get(path);
        if (url == null && (url = this._factory.resolveURL(this._src, path)) != null) {
            this._relativePaths.put(path, url);
        }
        return url;
    }

    public URL getSource() {
        return this._src;
    }

    private void include(AbstractFaceletContext ctx, UIComponent parent) throws IOException, FacesException, FaceletException, ELException {
        ctx.pushPageContext(new PageContextImpl());
        try {
            this.refresh(parent);
            DTFaceletContext ctxWrapper = new DTFaceletContext((DTFaceletContext)ctx, (AbstractFacelet)this, false);
            ctx.getFacesContext().getAttributes().put("com.sun.faces.facelets.FACELET_CONTEXT", (Object)ctxWrapper);
            this._root.apply(ctxWrapper, parent);
            ctx.getFacesContext().getAttributes().put("com.sun.faces.facelets.FACELET_CONTEXT", (Object)ctx);
            this.markApplied(parent);
        }
        finally {
            ctx.popPageContext();
        }
    }

    @Override
    public void include(AbstractFaceletContext ctx, UIComponent parent, String path) throws IOException, FacesException, FaceletException, ELException {
        URL url = this.getRelativePath(path);
        if (url != null) {
            this.include(ctx, parent, url);
        } else {
            DesignTimeContext.getCurrentInstance().reportIncludeError(new TagIncludeError(null, path));
        }
    }

    @Override
    public void include(AbstractFaceletContext ctx, UIComponent parent, URL url) throws IOException, FacesException, FaceletException, ELException {
        MockFacelet f = (MockFacelet)this._factory.getFacelet(url);
        DesignTimeContext.getCurrentInstance().reportInclude(ctx, this._src, url);
        f.include(ctx, parent);
    }

    @Override
    public void applyCompositeComponent(AbstractFaceletContext ctx, UIComponent parent, Resource resource) throws IOException, FacesException, FaceletException, ELException {
        MockFacelet f = (MockFacelet)this._factory.getFacelet(resource.getURL());
        ctx.pushPageContext(new PageContextImpl());
        try {
            boolean pushedUniqueIdVendor = false;
            FaceletCompositionContext mctx = ctx.getFaceletCompositionContext();
            if (parent instanceof UniqueIdVendor && ctx.getFaceletCompositionContext().getUniqueIdVendorFromStack() == null) {
                mctx.pushUniqueIdVendorToStack((UniqueIdVendor)((Object)parent));
                pushedUniqueIdVendor = true;
            }
            this.refresh(parent);
            mctx.markForDeletion(parent);
            DTFaceletContext ctxWrapper = new DTFaceletContext((DTFaceletContext)ctx, (AbstractFacelet)f, true);
            ctx.getFacesContext().getAttributes().put("com.sun.faces.facelets.FACELET_CONTEXT", (Object)ctxWrapper);
            f._root.apply(ctxWrapper, parent);
            ctx.getFacesContext().getAttributes().put("com.sun.faces.facelets.FACELET_CONTEXT", (Object)ctx);
            mctx.finalizeForDeletion(parent);
            this.markApplied(parent);
            if (pushedUniqueIdVendor) {
                ctx.getFaceletCompositionContext().popUniqueIdVendorToStack();
            }
        }
        finally {
            ctx.popPageContext();
        }
    }

    public String toString() {
        return this._alias;
    }

    @Override
    public boolean isBuildingCompositeComponentMetadata() {
        return this._isBuildingCompositeComponentMetadata;
    }

    private static class ApplyToken
    implements Externalizable {
        public String _alias;
        public long _time;

        public ApplyToken() {
        }

        public ApplyToken(String alias, long time) {
            this._alias = alias;
            this._time = time;
        }

        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            this._alias = in.readUTF();
            this._time = in.readLong();
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeUTF(this._alias);
            out.writeLong(this._time);
        }
    }
}

