/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.webtier.jsf.facelet;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.JarURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.el.ELResolver;
import javax.faces.FacesException;
import javax.faces.FactoryFinder;
import javax.faces.application.Application;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.el.PropertyResolver;
import javax.faces.el.VariableResolver;
import javax.faces.event.PostConstructApplicationEvent;
import javax.faces.event.SystemEvent;
import javax.faces.event.SystemEventListener;
import oracle.eclipse.tools.webtier.jsf.facelet.DTApplicationFactoryImpl;
import oracle.eclipse.tools.webtier.jsf.facelet.DTApplicationImpl;
import oracle.eclipse.tools.webtier.jsf.facelet.DTFaceletCacheFactoryImpl;
import org.apache.commons.collections.Predicate;
import org.apache.myfaces.config.FacesConfigUnmarshaller;
import org.apache.myfaces.config.NamedEventManager;
import org.apache.myfaces.config.RuntimeConfig;
import org.apache.myfaces.config.annotation.AnnotationConfigurator;
import org.apache.myfaces.config.element.Behavior;
import org.apache.myfaces.config.element.FaceletsProcessing;
import org.apache.myfaces.config.element.FacesConfig;
import org.apache.myfaces.config.element.FacesConfigData;
import org.apache.myfaces.config.element.ManagedBean;
import org.apache.myfaces.config.element.NamedEvent;
import org.apache.myfaces.config.element.NavigationRule;
import org.apache.myfaces.config.element.ResourceBundle;
import org.apache.myfaces.config.impl.digester.DigesterFacesConfigDispenserImpl;
import org.apache.myfaces.config.impl.digester.DigesterFacesConfigUnmarshallerImpl;
import org.apache.myfaces.context.ExternalContextFactoryImpl;
import org.apache.myfaces.context.FacesContextFactoryImpl;
import org.apache.myfaces.el.DefaultPropertyResolver;
import org.apache.myfaces.el.VariableResolverImpl;
import org.apache.myfaces.shared.config.MyfacesConfig;
import org.apache.myfaces.shared.util.ClassUtils;
import org.apache.myfaces.shared.util.LocaleUtils;
import org.apache.myfaces.shared_impl.util.serial.DefaultSerialFactory;
import org.apache.myfaces.shared_impl.util.serial.SerialFactory;
import org.apache.myfaces.util.ContainerUtils;
import org.apache.myfaces.util.ExternalSpecifications;
import org.apache.myfaces.view.ViewDeclarationLanguageFactoryImpl;
import org.apache.myfaces.view.facelets.tag.jsf.TagHandlerDelegateFactoryImpl;

public class DTFacesConfigurator {
    private static final Logger log = Logger.getLogger(DTFacesConfigurator.class.getName());
    private static final String DEFAULT_APPLICATION_FACTORY = DTApplicationFactoryImpl.class.getName();
    private static final String DEFAULT_EXTERNAL_CONTEXT_FACTORY = ExternalContextFactoryImpl.class.getName();
    private static final String DEFAULT_FACES_CONTEXT_FACTORY = FacesContextFactoryImpl.class.getName();
    private static final String DEFAULT_VIEW_DECLARATION_LANGUAGE_FACTORY = ViewDeclarationLanguageFactoryImpl.class.getName();
    private static final String DEFAULT_TAG_HANDLER_DELEGATE_FACTORY = TagHandlerDelegateFactoryImpl.class.getName();
    private static final String DEFAULT_FACELET_CACHE_FACTORY = DTFaceletCacheFactoryImpl.class.getName();
    private static final String DEFAULT_FACES_CONFIG = "/WEB-INF/faces-config.xml";
    private final ExternalContext _externalContext;
    private FacesConfigUnmarshaller<? extends FacesConfig> _unmarshaller;
    private FacesConfigData _dispenser;
    private AnnotationConfigurator _annotationConfigurator;
    private RuntimeConfig _runtimeConfig;
    private static long lastUpdate;

    public DTFacesConfigurator(ExternalContext externalContext) {
        if (externalContext == null) {
            throw new IllegalArgumentException("external context must not be null");
        }
        this._externalContext = externalContext;
    }

    public void setUnmarshaller(FacesConfigUnmarshaller<? extends FacesConfig> unmarshaller) {
        this._unmarshaller = unmarshaller;
    }

    protected FacesConfigUnmarshaller<? extends FacesConfig> getUnmarshaller() {
        if (this._unmarshaller == null) {
            this._unmarshaller = new DigesterFacesConfigUnmarshallerImpl(this._externalContext);
        }
        return this._unmarshaller;
    }

    public void setDispenser(FacesConfigData dispenser) {
        this._dispenser = dispenser;
    }

    protected FacesConfigData getDispenser() {
        if (this._dispenser == null) {
            this._dispenser = new DigesterFacesConfigDispenserImpl();
        }
        return this._dispenser;
    }

    public void setAnnotationConfigurator(AnnotationConfigurator configurator) {
        this._annotationConfigurator = configurator;
    }

    protected AnnotationConfigurator getAnnotationConfigurator() {
        if (this._annotationConfigurator == null) {
            this._annotationConfigurator = new AnnotationConfigurator();
        }
        return this._annotationConfigurator;
    }

    private long getResourceLastModified(String resource) {
        try {
            URL url = this._externalContext.getResource(resource);
            if (url != null) {
                return this.getResourceLastModified(url);
            }
        }
        catch (IOException e) {
            log.log(Level.SEVERE, "Could not read resource " + resource, e);
        }
        return 0L;
    }

    private long getResourceLastModified(URL url) throws IOException {
        if ("file".equals(url.getProtocol())) {
            String externalForm = url.toExternalForm();
            File file = new File(externalForm.substring(5));
            return file.lastModified();
        }
        return this.getResourceLastModified(url.openConnection());
    }

    private long getResourceLastModified(URLConnection connection) throws IOException {
        long modified;
        if (connection instanceof JarURLConnection) {
            URL jarFileUrl = ((JarURLConnection)connection).getJarFileURL();
            URLConnection jarFileConnection = jarFileUrl.openConnection();
            try {
                modified = jarFileConnection.getLastModified();
            }
            catch (Throwable throwable) {
                try {
                    jarFileConnection.getInputStream().close();
                }
                catch (Exception exception) {}
                throw throwable;
            }
            try {
                jarFileConnection.getInputStream().close();
            }
            catch (Exception exception) {}
        } else {
            modified = connection.getLastModified();
        }
        return modified;
    }

    private long getLastModifiedTime() {
        long lastModified = 0L;
        long resModified = this.getResourceLastModified(DEFAULT_FACES_CONFIG);
        if (resModified > lastModified) {
            lastModified = resModified;
        }
        List<String> configFilesList = this.getConfigFilesList();
        int i = 0;
        int size = configFilesList.size();
        while (i < size) {
            String systemId = configFilesList.get(i);
            resModified = this.getResourceLastModified(systemId);
            if (resModified > lastModified) {
                lastModified = resModified;
            }
            ++i;
        }
        return lastModified;
    }

    public void update() {
        if (ContainerUtils.isRunningOnGoogleAppEngine(this._externalContext)) {
            return;
        }
        long refreshPeriod = MyfacesConfig.getCurrentInstance(this._externalContext).getConfigRefreshPeriod() * 1000L;
        if (refreshPeriod > 0L) {
            long ttl = lastUpdate + refreshPeriod;
            if (System.currentTimeMillis() > ttl && this.getLastModifiedTime() > ttl) {
                try {
                    this.purgeConfiguration();
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    log.severe("Configuration objects do not support clean-up. Update aborted");
                    lastUpdate = System.currentTimeMillis();
                    return;
                }
                catch (IllegalAccessException e) {
                    log.severe("Error during configuration clean-up" + e.getMessage());
                }
                catch (InvocationTargetException e) {
                    log.severe("Error during configuration clean-up" + e.getMessage());
                }
                this.configure();
                FacesContext facesContext = FacesContext.getCurrentInstance();
                Application application = facesContext.getApplication();
                application.publishEvent(facesContext, PostConstructApplicationEvent.class, Application.class, application);
            }
        }
    }

    private void purgeConfiguration() throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
    }

    public void configure() throws FacesException {
        this.configureFactories();
        this.configureApplication();
        this.configureRuntimeConfig();
        this.handleSerialFactory();
        lastUpdate = System.currentTimeMillis();
    }

    private List<String> getConfigFilesList() {
        String configFiles = this._externalContext.getInitParameter("javax.faces.CONFIG_FILES");
        ArrayList<String> configFilesList = new ArrayList<String>();
        if (configFiles != null) {
            StringTokenizer st = new StringTokenizer(configFiles, ",", false);
            while (st.hasMoreTokens()) {
                String systemId = st.nextToken().trim();
                if (DEFAULT_FACES_CONFIG.equals(systemId)) {
                    if (!log.isLoggable(Level.WARNING)) continue;
                    log.warning("/WEB-INF/faces-config.xml has been specified in the javax.faces.CONFIG_FILES context parameter of the deployment descriptor. This will automatically be removed, if we wouldn't do this, it would be loaded twice.  See JSF spec 1.1, 10.3.2");
                    continue;
                }
                configFilesList.add(systemId);
            }
        }
        return configFilesList;
    }

    private void configureFactories() {
        FacesConfigData dispenser = this.getDispenser();
        this.setFactories("javax.faces.application.ApplicationFactory", dispenser.getApplicationFactoryIterator(), DEFAULT_APPLICATION_FACTORY);
        this.setFactories("javax.faces.context.ExternalContextFactory", dispenser.getExternalContextFactoryIterator(), DEFAULT_EXTERNAL_CONTEXT_FACTORY);
        this.setFactories("javax.faces.context.FacesContextFactory", dispenser.getFacesContextFactoryIterator(), DEFAULT_FACES_CONTEXT_FACTORY);
        this.setFactories("javax.faces.view.facelets.TagHandlerDelegateFactory", dispenser.getTagHandlerDelegateFactoryIterator(), DEFAULT_TAG_HANDLER_DELEGATE_FACTORY);
        this.setFactories("javax.faces.view.ViewDeclarationLanguageFactory", dispenser.getViewDeclarationLanguageFactoryIterator(), DEFAULT_VIEW_DECLARATION_LANGUAGE_FACTORY);
        this.setFactories("javax.faces.view.facelets.FaceletCacheFactory", dispenser.getFaceletCacheFactoryIterator(), DEFAULT_FACELET_CACHE_FACTORY);
    }

    private void setFactories(String factoryName, Collection<String> factories, String defaultFactory) {
        FactoryFinder.setFactory(factoryName, defaultFactory);
        for (String factory : factories) {
            if (factory.equals(defaultFactory)) continue;
            FactoryFinder.setFactory(factoryName, factory);
        }
    }

    private void configureApplication() {
        DTApplicationImpl application = new DTApplicationImpl();
        FacesConfigData dispenser = this.getDispenser();
        if (dispenser.getDefaultLocale() != null) {
            ((Application)application).setDefaultLocale(LocaleUtils.toLocale(dispenser.getDefaultLocale()));
        }
        if (dispenser.getDefaultRenderKitId() != null) {
            ((Application)application).setDefaultRenderKitId(dispenser.getDefaultRenderKitId());
        }
        if (dispenser.getMessageBundle() != null) {
            ((Application)application).setMessageBundle(dispenser.getMessageBundle());
        }
        ArrayList<Locale> locales = new ArrayList<Locale>();
        for (String locale : dispenser.getSupportedLocalesIterator()) {
            locales.add(LocaleUtils.toLocale(locale));
        }
        ((Application)application).setSupportedLocales(locales);
        for (org.apache.myfaces.config.element.SystemEventListener systemEventListener : dispenser.getSystemEventListeners()) {
            try {
                Class eventClass = ClassUtils.classForName(systemEventListener.getSystemEventClass() != null ? systemEventListener.getSystemEventClass() : SystemEvent.class.getName());
                if (systemEventListener.getSourceClass() != null && systemEventListener.getSourceClass().length() > 0) {
                    ((Application)application).subscribeToEvent(eventClass, ClassUtils.classForName(systemEventListener.getSourceClass()), (SystemEventListener)ClassUtils.newInstance(systemEventListener.getSystemEventListenerClass()));
                    continue;
                }
                ((Application)application).subscribeToEvent(eventClass, (SystemEventListener)ClassUtils.newInstance(systemEventListener.getSystemEventListenerClass()));
            }
            catch (ClassNotFoundException e) {
                log.log(Level.SEVERE, "System event listener could not be initialized, reason:", e);
            }
        }
        for (String componentType : dispenser.getComponentTypes()) {
            ((Application)application).addComponent(componentType, dispenser.getComponentClass(componentType));
        }
        for (String converterId : dispenser.getConverterIds()) {
            ((Application)application).addConverter(converterId, dispenser.getConverterClassById(converterId));
        }
        for (String converterClass : dispenser.getConverterClasses()) {
            try {
                ((Application)application).addConverter(ClassUtils.simpleClassForName(converterClass), dispenser.getConverterClassByClass(converterClass));
            }
            catch (Exception ex) {
                log.log(Level.SEVERE, "Converter could not be added. Reason:", ex);
            }
        }
        for (String validatorId : dispenser.getValidatorIds()) {
            ((Application)application).addValidator(validatorId, dispenser.getValidatorClass(validatorId));
        }
        String beanValidatorDisabled = this._externalContext.getInitParameter("javax.faces.validator.DISABLE_DEFAULT_BEAN_VALIDATOR");
        boolean defaultBeanValidatorDisabled = beanValidatorDisabled != null && beanValidatorDisabled.toLowerCase().equals("true");
        boolean beanValidatorInstalledProgrammatically = false;
        if (!defaultBeanValidatorDisabled && ExternalSpecifications.isBeanValidationAvailable()) {
            ((Application)application).addDefaultValidatorId("javax.faces.Bean");
            beanValidatorInstalledProgrammatically = true;
        }
        for (String validatorId : dispenser.getDefaultValidatorIds()) {
            ((Application)application).addDefaultValidatorId(validatorId);
        }
        if (!beanValidatorInstalledProgrammatically && ((Application)application).getDefaultValidatorInfo().containsKey("javax.faces.Bean")) {
            if (!ExternalSpecifications.isBeanValidationAvailable()) {
                log.log(Level.WARNING, "The BeanValidator was installed as a default-validator from a faces-config file, but bean validation is not available on the classpath, thus it will not work!");
            } else if (defaultBeanValidatorDisabled) {
                log.log(Level.INFO, "The BeanValidator was disabled as a default-validator via the config parameter javax.faces.validator.DISABLE_DEFAULT_BEAN_VALIDATOR in web.xml, but a faces-config file added it, thus it actually was installed as a default-validator.");
            }
        }
        for (Behavior behavior : dispenser.getBehaviors()) {
            ((Application)application).addBehavior(behavior.getBehaviorId(), behavior.getBehaviorClass());
        }
        RuntimeConfig runtimeConfig = this.getRuntimeConfig();
        if (MyfacesConfig.getCurrentInstance(this._externalContext).isSupportJSPAndFacesEL()) {
            runtimeConfig.setPropertyResolverChainHead(ClassUtils.buildApplicationObject(PropertyResolver.class, dispenser.getPropertyResolverIterator(), new DefaultPropertyResolver()));
            runtimeConfig.setVariableResolverChainHead(ClassUtils.buildApplicationObject(VariableResolver.class, dispenser.getVariableResolverIterator(), new VariableResolverImpl()));
        }
    }

    String getDefaultSourcClassForSystemEvent(Class systemEventClass) {
        Constructor<?>[] constructors;
        Constructor<?>[] constructorArray = constructors = systemEventClass.getConstructors();
        int n = constructors.length;
        int n2 = 0;
        while (n2 < n) {
            Constructor<?> constr = constructorArray[n2];
            Class<?>[] parms = constr.getParameterTypes();
            if (parms != null && parms.length == 1) {
                return parms[0].getName();
            }
            ++n2;
        }
        log.warning("The SystemEvent source type for " + systemEventClass.getName() + " could not be detected, either register it manually or use a constructor argument " + "for auto detection, defaulting now to java.lang.Object");
        return "java.lang.Object";
    }

    protected RuntimeConfig getRuntimeConfig() {
        if (this._runtimeConfig == null) {
            this._runtimeConfig = RuntimeConfig.getCurrentInstance(this._externalContext);
        }
        return this._runtimeConfig;
    }

    public void setRuntimeConfig(RuntimeConfig runtimeConfig) {
        this._runtimeConfig = runtimeConfig;
    }

    private void configureRuntimeConfig() {
        String elResolverPredicateClass;
        Class clazz;
        RuntimeConfig runtimeConfig = RuntimeConfig.getCurrentInstance(this._externalContext);
        FacesConfigData dispenser = this.getDispenser();
        for (ManagedBean bean : dispenser.getManagedBeans()) {
            if (log.isLoggable(Level.WARNING) && runtimeConfig.getManagedBean(bean.getManagedBeanName()) != null) {
                log.warning("More than one managed bean w/ the name of '" + bean.getManagedBeanName() + "' - only keeping the last ");
            }
            runtimeConfig.addManagedBean(bean.getManagedBeanName(), bean);
        }
        this.removePurgedBeansFromSessionAndApplication(runtimeConfig);
        for (NavigationRule rule : dispenser.getNavigationRules()) {
            runtimeConfig.addNavigationRule(rule);
        }
        for (String converterClassName : dispenser.getConverterConfigurationByClassName()) {
            runtimeConfig.addConverterConfiguration(converterClassName, this._dispenser.getConverterConfiguration(converterClassName));
        }
        for (ResourceBundle bundle : dispenser.getResourceBundles()) {
            runtimeConfig.addResourceBundle(bundle);
        }
        for (String className : dispenser.getElResolvers()) {
            try {
                runtimeConfig.addFacesConfigElResolver((ELResolver)ClassUtils.newInstance(className, ELResolver.class));
            }
            catch (Exception e) {
                log.warning(e.getLocalizedMessage());
            }
        }
        runtimeConfig.setNamedEventManager(new NamedEventManager());
        for (NamedEvent event : dispenser.getNamedEvents()) {
            try {
                clazz = ClassUtils.classForName(event.getEventClass());
                runtimeConfig.getNamedEventManager().addNamedEvent(event.getShortName(), clazz);
            }
            catch (ClassNotFoundException e) {
                log.log(Level.SEVERE, "Named event could not be initialized, reason:", e);
            }
        }
        String comparatorClass = this._externalContext.getInitParameter("org.apache.myfaces.EL_RESOLVER_COMPARATOR");
        if (comparatorClass != null && !"".equals(comparatorClass)) {
            try {
                Class clazz2 = ClassUtils.classForName(comparatorClass);
                Comparator comparator = (Comparator)ClassUtils.newInstance(clazz2);
                runtimeConfig.setELResolverComparator(comparator);
            }
            catch (Exception e) {
                if (log.isLoggable(Level.SEVERE)) {
                    log.log(Level.SEVERE, "Cannot instantiate EL Resolver Comparator " + comparatorClass + " . Check org.apache.myfaces.EL_RESOLVER_COMPARATOR web config param. " + "Initialization continues with no comparator used.", e);
                }
            }
        } else {
            runtimeConfig.setELResolverComparator(null);
        }
        if ((elResolverPredicateClass = this._externalContext.getInitParameter("org.apache.myfaces.EL_RESOLVER_PREDICATE")) != null && !"".equals(elResolverPredicateClass)) {
            try {
                clazz = ClassUtils.classForName(elResolverPredicateClass);
                Predicate elResolverPredicate = (Predicate)ClassUtils.newInstance(clazz);
                runtimeConfig.setELResolverPredicate(elResolverPredicate);
            }
            catch (Exception e) {
                if (log.isLoggable(Level.SEVERE)) {
                    log.log(Level.SEVERE, "Cannot instantiate EL Resolver Comparator " + comparatorClass + " . Check org.apache.myfaces.EL_RESOLVER_COMPARATOR web config param. " + "Initialization continues with no comparator used.", e);
                }
            }
        } else {
            runtimeConfig.setELResolverPredicate(null);
        }
        for (FaceletsProcessing faceletsProcessing : dispenser.getFaceletsProcessing()) {
            runtimeConfig.addFaceletProcessingConfiguration(faceletsProcessing.getFileExtension(), faceletsProcessing);
        }
    }

    private void removePurgedBeansFromSessionAndApplication(RuntimeConfig runtimeConfig) {
        Map<String, ManagedBean> oldManagedBeans = runtimeConfig.getManagedBeansNotReaddedAfterPurge();
        if (oldManagedBeans != null) {
            for (Map.Entry<String, ManagedBean> entry : oldManagedBeans.entrySet()) {
                ManagedBean bean = entry.getValue();
                String scope = bean.getManagedBeanScope();
                if (scope != null && scope.equalsIgnoreCase("session")) {
                    this._externalContext.getSessionMap().remove(entry.getKey());
                    continue;
                }
                if (scope == null || !scope.equalsIgnoreCase("application")) continue;
                this._externalContext.getApplicationMap().remove(entry.getKey());
            }
        }
        runtimeConfig.resetManagedBeansNotReaddedAfterPurge();
    }

    private void handleSerialFactory() {
        SerialFactory serialFactory;
        block11: {
            String serialProvider = this._externalContext.getInitParameter("org.apache.myfaces.SERIAL_FACTORY");
            serialFactory = null;
            if (serialProvider == null) {
                serialFactory = new DefaultSerialFactory();
            } else {
                try {
                    serialFactory = (SerialFactory)ClassUtils.newInstance(serialProvider);
                }
                catch (ClassCastException e) {
                    log.log(Level.SEVERE, "Make sure '" + serialProvider + "' implements the correct interface", e);
                    if (serialFactory == null) {
                        serialFactory = new DefaultSerialFactory();
                        log.severe("Using default serialization provider");
                    }
                    break block11;
                }
                catch (Exception e) {
                    try {
                        log.log(Level.SEVERE, "", e);
                        break block11;
                    }
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                    finally {
                        if (serialFactory == null) {
                            serialFactory = new DefaultSerialFactory();
                            log.severe("Using default serialization provider");
                        }
                    }
                }
                if (serialFactory != null) break block11;
                serialFactory = new DefaultSerialFactory();
                log.severe("Using default serialization provider");
            }
        }
        log.info("Serialization provider : " + serialFactory.getClass());
        this._externalContext.getApplicationMap().put("org.apache.myfaces.SERIAL_FACTORY", serialFactory);
    }
}

