/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.webtier.jsf.facelet;

import java.io.IOException;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.view.facelets.FaceletException;
import javax.faces.view.facelets.TagDecorator;
import javax.xml.stream.XMLStreamException;
import oracle.eclipse.tools.webtier.jsf.facelet.DTDefaultFaceletFactory;
import oracle.eclipse.tools.webtier.jsf.facelet.FaceletCompilerConfigurator;
import oracle.eclipse.tools.webtier.jsf.facelet.dtcompiler.DTSAXCompiler;
import org.apache.myfaces.config.RuntimeConfig;
import org.apache.myfaces.shared.util.WebConfigParamUtils;
import org.apache.myfaces.view.facelets.AbstractFacelet;
import org.apache.myfaces.view.facelets.compiler.Compiler;
import org.apache.myfaces.view.facelets.impl.DefaultResourceResolver;
import org.apache.myfaces.view.facelets.tag.CompositeTagLibrary;
import org.apache.myfaces.view.facelets.tag.composite.CompositeLibrary;
import org.apache.myfaces.view.facelets.tag.jsf.core.CoreLibrary;
import org.apache.myfaces.view.facelets.tag.jsf.html.HtmlLibrary;
import org.apache.myfaces.view.facelets.tag.jstl.core.JstlCoreLibrary;
import org.apache.myfaces.view.facelets.tag.jstl.fn.JstlFnLibrary;
import org.apache.myfaces.view.facelets.tag.ui.UILibrary;
import org.apache.myfaces.view.facelets.util.ReflectionUtil;
import org.xml.sax.SAXParseException;

public class DTFaceletCompilerExecutor {
    private static final Logger log = Logger.getLogger(FaceletCompilerConfigurator.class.getName());
    public static final String PARAM_DECORATORS = "javax.faces.FACELETS_DECORATORS";
    private static final String PARAM_DECORATORS_DEPRECATED = "facelets.DECORATORS";
    private static final String[] PARAMS_DECORATORS = new String[]{"javax.faces.FACELETS_DECORATORS", "facelets.DECORATORS"};
    public static final String PARAM_LIBRARIES = "javax.faces.FACELETS_LIBRARIES";
    private static final String PARAM_LIBRARIES_DEPRECATED = "facelets.LIBRARIES";
    public static final String PARAM_SKIP_COMMENTS = "javax.faces.FACELETS_SKIP_COMMENTS";
    private static final String PARAM_SKIP_COMMENTS_DEPRECATED = "facelets.SKIP_COMMENTS";
    private static final String PARAM_MARK_INITIAL_STATE_WHEN_APPLY_BUILD_VIEW = "org.apache.myfaces.MARK_INITIAL_STATE_WHEN_APPLY_BUILD_VIEW";
    private static final String[] PARAMS_SKIP_COMMENTS = new String[]{"javax.faces.FACELETS_SKIP_COMMENTS", "facelets.SKIP_COMMENTS"};
    private FaceletCompilerConfigurator.DTFaceletCompilerConfig config;

    public DTFaceletCompilerExecutor(FaceletCompilerConfigurator.DTFaceletCompilerConfig config) {
        this.config = config;
    }

    public void execute() throws IOException {
        Compiler compiler = DTFaceletCompilerExecutor.createCompiler(this.config);
        try {
            DTDefaultFaceletFactory faceletFactory = new DTDefaultFaceletFactory(compiler, new DefaultResourceResolver());
            AbstractFacelet facelet = (AbstractFacelet)faceletFactory.getFacelet(this.config.getTargetFile());
            facelet.apply(this.config.getFacesContext(), this.config.getViewRoot());
        }
        catch (Exception e) {
            if (e instanceof FaceletException) {
                if (!(e.getCause() instanceof XMLStreamException)) {
                    boolean cfr_ignored_0 = e.getCause() instanceof SAXParseException;
                }
                e.printStackTrace();
            }
            e.printStackTrace();
        }
    }

    protected static Compiler createCompiler(FaceletCompilerConfigurator.DTFaceletCompilerConfig config) {
        DTSAXCompiler compiler = new DTSAXCompiler();
        FacesContext context = config.getFacesContext();
        CompositeTagLibrary predefinedTagLibraries = config.getPredefinedTagLibraries();
        compiler.setDevelopmentProjectStage(true);
        DTFaceletCompilerExecutor.loadLibraries(context, compiler, predefinedTagLibraries);
        DTFaceletCompilerExecutor.loadDecorators(context, compiler);
        DTFaceletCompilerExecutor.loadOptions(context, compiler);
        compiler.setFaceletsProcessingConfigurations(RuntimeConfig.getCurrentInstance(context.getExternalContext()).getFaceletProcessingConfigurations());
        URL dtd = config.getDtd();
        compiler.setDtd(dtd);
        return compiler;
    }

    protected static void loadDecorators(FacesContext context, Compiler compiler) {
        String param = WebConfigParamUtils.getStringInitParameter(context.getExternalContext(), PARAMS_DECORATORS);
        if (param != null) {
            String[] stringArray = param.split(";");
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String decorator = stringArray[n2];
                try {
                    compiler.addTagDecorator((TagDecorator)ReflectionUtil.forName(decorator).newInstance());
                    if (log.isLoggable(Level.FINE)) {
                        log.fine("Successfully loaded decorator: " + decorator);
                    }
                }
                catch (Exception e) {
                    log.log(Level.SEVERE, "Error Loading decorator: " + decorator, e);
                }
                ++n2;
            }
        }
    }

    protected static void loadLibraries(FacesContext context, Compiler compiler, CompositeTagLibrary predefinedTagLibrary) {
        compiler.addTagLibrary(predefinedTagLibrary);
        if (!predefinedTagLibrary.containsNamespace("http://java.sun.com/jsf/core")) {
            compiler.addTagLibrary(new CoreLibrary());
        }
        if (!predefinedTagLibrary.containsNamespace("http://java.sun.com/jsf/html")) {
            compiler.addTagLibrary(new HtmlLibrary());
        }
        if (!predefinedTagLibrary.containsNamespace("http://java.sun.com/jsf/facelets")) {
            compiler.addTagLibrary(new UILibrary());
        }
        if (!predefinedTagLibrary.containsNamespace("http://java.sun.com/jsp/jstl/core")) {
            compiler.addTagLibrary(new JstlCoreLibrary());
        }
        if (!predefinedTagLibrary.containsNamespace("http://java.sun.com/jsp/jstl/functions")) {
            compiler.addTagLibrary(new JstlFnLibrary());
        }
        if (!predefinedTagLibrary.containsNamespace("http://java.sun.com/jsf/composite")) {
            compiler.addTagLibrary(new CompositeLibrary());
        }
    }

    protected static void loadOptions(FacesContext context, Compiler compiler) {
        ExternalContext eContext = context.getExternalContext();
        compiler.setTrimmingComments(WebConfigParamUtils.getBooleanInitParameter(eContext, PARAMS_SKIP_COMMENTS, false));
    }
}

