/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.webtier.jsf.facelet;

import java.io.IOException;
import java.net.URL;
import java.net.URLConnection;
import java.util.HashMap;
import java.util.Map;
import javax.faces.view.facelets.FaceletCache;
import javax.faces.view.facelets.FaceletException;
import oracle.eclipse.tools.webtier.jsf.facelet.MockFacelet;
import org.apache.myfaces.shared.resource.ResourceLoaderUtils;
import org.apache.myfaces.view.facelets.util.ParameterCheck;

class DTFaceletCacheImpl
extends FaceletCache<MockFacelet> {
    private static final long INFINITE_DELAY = -1L;
    private static final long NO_CACHE_DELAY = 0L;
    private Map<String, MockFacelet> _facelets;
    private Map<String, MockFacelet> _viewMetadataFacelets;
    private long _refreshPeriod;

    DTFaceletCacheImpl(long refreshPeriod) {
        this._refreshPeriod = refreshPeriod < 0L ? -1L : refreshPeriod * 1000L;
        this._facelets = new HashMap<String, MockFacelet>();
        this._viewMetadataFacelets = new HashMap<String, MockFacelet>();
    }

    @Override
    public MockFacelet getFacelet(URL url) throws IOException {
        ParameterCheck.notNull("url", url);
        String key = url.toString();
        MockFacelet f = this._facelets.get(key);
        if (f == null || this.needsToBeRefreshed(f)) {
            f = (MockFacelet)this.getMemberFactory().newInstance(url);
            if (this._refreshPeriod != 0L) {
                HashMap<String, MockFacelet> newLoc = new HashMap<String, MockFacelet>(this._facelets);
                newLoc.put(key, f);
                this._facelets = newLoc;
            }
        }
        return f;
    }

    @Override
    public boolean isFaceletCached(URL url) {
        return this._facelets.containsKey(url);
    }

    @Override
    public MockFacelet getViewMetadataFacelet(URL url) throws IOException {
        ParameterCheck.notNull("url", url);
        String key = url.toString();
        MockFacelet f = this._viewMetadataFacelets.get(key);
        if (f == null || this.needsToBeRefreshed(f)) {
            f = (MockFacelet)this.getMetadataMemberFactory().newInstance(url);
            if (this._refreshPeriod != 0L) {
                HashMap<String, MockFacelet> newLoc = new HashMap<String, MockFacelet>(this._viewMetadataFacelets);
                newLoc.put(key, f);
                this._viewMetadataFacelets = newLoc;
            }
        }
        return f;
    }

    @Override
    public boolean isViewMetadataFaceletCached(URL url) {
        return this._viewMetadataFacelets.containsKey(url);
    }

    protected boolean needsToBeRefreshed(MockFacelet facelet) {
        if (this._refreshPeriod == 0L) {
            return true;
        }
        if (this._refreshPeriod == -1L) {
            return false;
        }
        long target = facelet.getCreateTime() + this._refreshPeriod;
        if (System.currentTimeMillis() > target) {
            try {
                URLConnection conn = facelet.getSource().openConnection();
                long lastModified = ResourceLoaderUtils.getResourceLastModified(conn);
                return lastModified == 0L || lastModified > target;
            }
            catch (IOException e) {
                throw new FaceletException("Error Checking Last Modified for " + facelet.getAlias(), e);
            }
        }
        return false;
    }
}

