/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.webtier.jsf.facelet;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLConnection;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import javax.el.ELException;
import javax.faces.FacesException;
import javax.faces.view.facelets.FaceletCache;
import javax.faces.view.facelets.FaceletCacheFactory;
import javax.faces.view.facelets.FaceletException;
import javax.faces.view.facelets.FaceletHandler;
import javax.faces.view.facelets.ResourceResolver;
import oracle.eclipse.tools.webtier.jsf.facelet.DTFaceletCacheFactoryImpl;
import oracle.eclipse.tools.webtier.jsf.facelet.MockFacelet;
import oracle.eclipse.tools.webtier.jsf.facelet.dtcompiler.cu.MissingDTTagUnit;
import oracle.eclipse.tools.webtier.jsf.facelet.dtcompiler.handler.NullFaceletHandler;
import oracle.eclipse.tools.webtier.jsf.facelet.dtcontext.DesignTimeContext;
import oracle.eclipse.tools.webtier.jsf.facelet.dtcontext.TagIncludeError;
import org.apache.myfaces.shared.resource.ResourceLoaderUtils;
import org.apache.myfaces.view.facelets.Facelet;
import org.apache.myfaces.view.facelets.FaceletFactory;
import org.apache.myfaces.view.facelets.compiler.Compiler;
import org.apache.myfaces.view.facelets.util.ParameterCheck;

public final class DTDefaultFaceletFactory
extends FaceletFactory {
    private static final long INFINITE_DELAY = -1L;
    private static final long NO_CACHE_DELAY = 0L;
    protected final Logger log = Logger.getLogger(DTDefaultFaceletFactory.class.getName());
    private URL _baseUrl;
    private Compiler _compiler;
    private Map<String, MockFacelet> _compositeComponentMetadataFacelets;
    private long _refreshPeriod;
    private Map<String, URL> _relativeLocations;
    private ResourceResolver _resolver;
    private FaceletCache<Facelet> _faceletCache;

    public DTDefaultFaceletFactory(Compiler compiler, ResourceResolver resolver) throws IOException {
        this(compiler, resolver, -1L);
    }

    public DTDefaultFaceletFactory(Compiler compiler, ResourceResolver resolver, long refreshPeriod) {
        ParameterCheck.notNull("compiler", compiler);
        ParameterCheck.notNull("resolver", resolver);
        this._compiler = compiler;
        this._compositeComponentMetadataFacelets = new HashMap<String, MockFacelet>();
        this._relativeLocations = new HashMap<String, URL>();
        this._resolver = resolver;
        this._baseUrl = resolver.resolveUrl("/");
        this._refreshPeriod = refreshPeriod < 0L ? -1L : refreshPeriod * 1000L;
        DTFaceletCacheFactoryImpl cacheFactory = new DTFaceletCacheFactoryImpl();
        this._faceletCache = ((FaceletCacheFactory)cacheFactory).getFaceletCache();
        FaceletCache.MemberFactory<Facelet> faceletFactory = new FaceletCache.MemberFactory<Facelet>(){

            @Override
            public Facelet newInstance(URL url) throws IOException {
                return DTDefaultFaceletFactory.this._createFacelet(url);
            }
        };
        FaceletCache.MemberFactory<Facelet> viewMetadataFaceletFactory = new FaceletCache.MemberFactory<Facelet>(){

            @Override
            public Facelet newInstance(URL url) throws IOException {
                return DTDefaultFaceletFactory.this._createViewMetadataFacelet(url);
            }
        };
        try {
            Method setMemberFactoriesMethod = FaceletCache.class.getDeclaredMethod("setMemberFactories", FaceletCache.MemberFactory.class, FaceletCache.MemberFactory.class);
            setMemberFactoriesMethod.setAccessible(true);
            setMemberFactoriesMethod.invoke(this._faceletCache, faceletFactory, viewMetadataFaceletFactory);
        }
        catch (Exception e) {
            throw new FacesException("Cannot call setMemberFactories method, Initialization of FaceletCache failed.", e);
        }
        if (this.log.isLoggable(Level.FINE)) {
            this.log.fine("Using ResourceResolver: " + this._resolver);
            this.log.fine("Using Refresh Period: " + this._refreshPeriod);
        }
    }

    public Compiler getCompiler() {
        return this._compiler;
    }

    @Override
    public Facelet getFacelet(String uri) throws IOException, FaceletException, FacesException, ELException {
        URL url = this._relativeLocations.get(uri);
        if (url == null) {
            url = this.resolveURL(this._baseUrl, uri);
            if (url != null) {
                HashMap<String, URL> newLoc = new HashMap<String, URL>(this._relativeLocations);
                newLoc.put(uri, url);
                this._relativeLocations = newLoc;
            } else {
                throw new IOException("'" + uri + "' not found.");
            }
        }
        return this.getFacelet(url);
    }

    @Override
    public Facelet getFacelet(URL url) throws IOException, FaceletException, FacesException, ELException {
        return this._faceletCache.getFacelet(url);
    }

    public long getRefreshPeriod() {
        return this._refreshPeriod;
    }

    public URL resolveURL(URL source, String path) throws IOException {
        if (path.startsWith("/")) {
            URL url = this._resolver.resolveUrl(path);
            if (url == null) {
                throw new FileNotFoundException(String.valueOf(path) + " Not Found in ExternalContext as a Resource");
            }
            return url;
        }
        if (!path.isEmpty()) {
            return new URL(source, path);
        }
        return null;
    }

    protected boolean needsToBeRefreshed(MockFacelet facelet) {
        if (this._refreshPeriod == 0L) {
            return true;
        }
        if (this._refreshPeriod == -1L) {
            return false;
        }
        long target = facelet.getCreateTime() + this._refreshPeriod;
        if (System.currentTimeMillis() > target) {
            try {
                URLConnection conn = facelet.getSource().openConnection();
                long lastModified = ResourceLoaderUtils.getResourceLastModified(conn);
                return lastModified == 0L || lastModified > target;
            }
            catch (IOException e) {
                throw new FaceletException("Error Checking Last Modified for " + facelet.getAlias(), e);
            }
        }
        return false;
    }

    private MockFacelet _createFacelet(URL url) throws IOException, FaceletException, FacesException, ELException {
        if (this.log.isLoggable(Level.FINE)) {
            this.log.fine("Creating Facelet for: " + url);
        }
        String alias = "/" + this._removeFirst(url.getFile(), this._baseUrl.getFile());
        try {
            FaceletHandler h = this._compiler.compile(url, alias);
            if (h == null) {
                h = new NullFaceletHandler(new MissingDTTagUnit());
            }
            MockFacelet f = new MockFacelet(this, this._compiler.createExpressionFactory(), url, alias, alias, h);
            return f;
        }
        catch (FileNotFoundException fileNotFoundException) {
            DesignTimeContext.getCurrentInstance().reportIncludeError(new TagIncludeError(url, alias));
            NullFaceletHandler h = new NullFaceletHandler(new MissingDTTagUnit());
            MockFacelet f = new MockFacelet(this, this._compiler.createExpressionFactory(), url, alias, alias, h);
            return f;
        }
    }

    private MockFacelet _createViewMetadataFacelet(URL url) throws IOException, FaceletException, FacesException, ELException {
        if (this.log.isLoggable(Level.FINE)) {
            this.log.fine("Creating Facelet used to create View Metadata for: " + url);
        }
        String faceletId = "/" + this._removeFirst(url.getFile(), this._baseUrl.getFile());
        String alias = "/viewMetadata" + faceletId;
        try {
            FaceletHandler h = this._compiler.compileViewMetadata(url, alias);
            MockFacelet f = new MockFacelet(this, this._compiler.createExpressionFactory(), url, alias, faceletId, h);
            return f;
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new FileNotFoundException("Facelet " + alias + " not found at: " + url.toExternalForm());
        }
    }

    private MockFacelet _createCompositeComponentMetadataFacelet(URL url) throws IOException, FaceletException, FacesException, ELException {
        if (this.log.isLoggable(Level.FINE)) {
            this.log.fine("Creating Facelet used to create Composite Component Metadata for: " + url);
        }
        String alias = "/compositeComponentMetadata/" + this._removeFirst(url.getFile(), this._baseUrl.getFile());
        try {
            FaceletHandler h = this._compiler.compileCompositeComponentMetadata(url, alias);
            MockFacelet f = new MockFacelet(this, this._compiler.createExpressionFactory(), url, alias, alias, h, true);
            return f;
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new FileNotFoundException("Facelet " + alias + " not found at: " + url.toExternalForm());
        }
    }

    @Override
    public Facelet getViewMetadataFacelet(String uri) throws IOException {
        URL url = this._relativeLocations.get(uri);
        if (url == null) {
            url = this.resolveURL(this._baseUrl, uri);
            if (url != null) {
                HashMap<String, URL> newLoc = new HashMap<String, URL>(this._relativeLocations);
                newLoc.put(uri, url);
                this._relativeLocations = newLoc;
            } else {
                throw new IOException("'" + uri + "' not found.");
            }
        }
        return this.getViewMetadataFacelet(url);
    }

    @Override
    public Facelet getViewMetadataFacelet(URL url) throws IOException, FaceletException, FacesException, ELException {
        return this._faceletCache.getViewMetadataFacelet(url);
    }

    @Override
    public Facelet getCompositeComponentMetadataFacelet(String uri) throws IOException {
        URL url = this._relativeLocations.get(uri);
        if (url == null) {
            url = this.resolveURL(this._baseUrl, uri);
            if (url != null) {
                HashMap<String, URL> newLoc = new HashMap<String, URL>(this._relativeLocations);
                newLoc.put(uri, url);
                this._relativeLocations = newLoc;
            } else {
                throw new IOException("'" + uri + "' not found.");
            }
        }
        return this.getCompositeComponentMetadataFacelet(url);
    }

    @Override
    public Facelet getCompositeComponentMetadataFacelet(URL url) throws IOException, FaceletException, FacesException, ELException {
        ParameterCheck.notNull("url", url);
        String key = url.toString();
        MockFacelet f = this._compositeComponentMetadataFacelets.get(key);
        if (f == null || this.needsToBeRefreshed(f)) {
            f = this._createCompositeComponentMetadataFacelet(url);
            if (this._refreshPeriod != 0L) {
                HashMap<String, MockFacelet> newLoc = new HashMap<String, MockFacelet>(this._compositeComponentMetadataFacelets);
                newLoc.put(key, f);
                this._compositeComponentMetadataFacelets = newLoc;
            }
        }
        return f;
    }

    private String _removeFirst(String string, String toRemove) {
        return Pattern.compile(toRemove, 16).matcher(string).replaceFirst("");
    }
}

