/*
 * Decompiled with CFR 0.152.
 */
package javax.faces.validator;

import java.util.logging.Level;
import java.util.logging.Logger;
import javax.el.ELContext;
import javax.faces.validator._ValidationUtils;

final class _ExternalSpecifications {
    private static final Logger log = Logger.getLogger(_ExternalSpecifications.class.getName());
    private static volatile Boolean beanValidationAvailable;
    private static volatile Boolean unifiedELAvailable;

    public static boolean isBeanValidationAvailable() {
        if (beanValidationAvailable == null) {
            try {
                try {
                    beanValidationAvailable = Class.forName("javax.validation.Validation") != null;
                }
                catch (ClassNotFoundException classNotFoundException) {
                    beanValidationAvailable = Boolean.FALSE;
                }
                if (beanValidationAvailable.booleanValue()) {
                    try {
                        _ValidationUtils.tryBuildDefaultValidatorFactory();
                    }
                    catch (Throwable t) {
                        log.log(Level.FINE, "Error initializing Bean Validation (could be normal)", t);
                        beanValidationAvailable = false;
                    }
                }
            }
            catch (Throwable t) {
                log.log(Level.FINE, "Error loading class (could be normal)", t);
                beanValidationAvailable = false;
            }
        }
        return beanValidationAvailable;
    }

    public static boolean isUnifiedELAvailable() {
        if (unifiedELAvailable == null) {
            try {
                unifiedELAvailable = Class.forName("javax.el.ValueReference") != null && Class.forName("javax.el.ValueExpression").getMethod("getValueReference", ELContext.class) != null;
            }
            catch (Throwable t) {
                log.log(Level.FINE, "Error loading class (could be normal)", t);
                unifiedELAvailable = false;
            }
        }
        return unifiedELAvailable;
    }

    private _ExternalSpecifications() {
    }
}

