/*
 * Decompiled with CFR 0.152.
 */
package javax.faces.model;

import java.util.SortedMap;
import javax.faces.model.DataModel;
import javax.faces.model.DataModelEvent;
import javax.faces.model.DataModelListener;

public class ResultDataModel
extends DataModel<SortedMap<String, Object>> {
    private int _rowIndex = -1;
    private Object _data;

    public ResultDataModel() {
    }

    public ResultDataModel(Object result) {
        if (result == null) {
            throw new NullPointerException("result");
        }
        this.setWrappedData(result);
    }

    @Override
    public int getRowCount() {
        if (this.getRows() == null) {
            return -1;
        }
        return this.getRows().length;
    }

    @Override
    public SortedMap<String, Object> getRowData() {
        if (this.getRows() == null) {
            return null;
        }
        if (!this.isRowAvailable()) {
            throw new IllegalArgumentException("row is unavailable");
        }
        return this.getRows()[this._rowIndex];
    }

    @Override
    public int getRowIndex() {
        return this._rowIndex;
    }

    @Override
    public Object getWrappedData() {
        return this._data;
    }

    @Override
    public boolean isRowAvailable() {
        return this.getRows() != null && this._rowIndex >= 0 && this._rowIndex < this.getRows().length;
    }

    @Override
    public void setRowIndex(int rowIndex) {
        if (rowIndex < -1) {
            throw new IllegalArgumentException("illegal rowIndex " + rowIndex);
        }
        int oldRowIndex = this._rowIndex;
        this._rowIndex = rowIndex;
        if (this.getRows() != null && oldRowIndex != this._rowIndex) {
            Object data = this.isRowAvailable() ? this.getRowData() : null;
            DataModelEvent event = new DataModelEvent(this, this._rowIndex, data);
            DataModelListener[] listeners = this.getDataModelListeners();
            int i = 0;
            while (i < listeners.length) {
                listeners[i].rowSelected(event);
                ++i;
            }
        }
    }

    private SortedMap<String, Object>[] getRows() {
        if (this._data == null) {
            return null;
        }
        return null;
    }

    @Override
    public void setWrappedData(Object data) {
        if (data == null) {
            this.setRowIndex(-1);
            this._data = null;
        } else {
            this._rowIndex = -1;
            this.setRowIndex(0);
        }
    }
}

