/*
 * Decompiled with CFR 0.152.
 */
package javax.faces.convert;

import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.el.ValueExpression;
import javax.faces.FacesException;
import javax.faces.application.FacesMessage;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.convert._ParametrizableFacesMessage;

class _MessageUtils {
    private static final String DETAIL_SUFFIX = "_detail";

    _MessageUtils() {
    }

    static FacesMessage getErrorMessage(FacesContext facesContext, String messageId, Object[] args) {
        return _MessageUtils.getMessage(facesContext, facesContext.getViewRoot().getLocale(), FacesMessage.SEVERITY_ERROR, messageId, args);
    }

    static FacesMessage getMessage(FacesContext facesContext, Locale locale, FacesMessage.Severity severity, String messageId, Object[] args) {
        String detail;
        ResourceBundle appBundle = _MessageUtils.getApplicationBundle(facesContext, locale);
        String summary = _MessageUtils.getBundleString(appBundle, messageId);
        if (summary != null) {
            detail = _MessageUtils.getBundleString(appBundle, String.valueOf(messageId) + DETAIL_SUFFIX);
        } else {
            ResourceBundle defBundle = _MessageUtils.getDefaultBundle(facesContext, locale);
            summary = _MessageUtils.getBundleString(defBundle, messageId);
            if (summary != null) {
                detail = _MessageUtils.getBundleString(defBundle, String.valueOf(messageId) + DETAIL_SUFFIX);
            } else {
                detail = _MessageUtils.getBundleString(appBundle, String.valueOf(messageId) + DETAIL_SUFFIX);
                if (detail != null) {
                    summary = null;
                } else {
                    detail = _MessageUtils.getBundleString(defBundle, String.valueOf(messageId) + DETAIL_SUFFIX);
                    if (detail != null) {
                        summary = null;
                    } else {
                        facesContext.getExternalContext().log("No message with id " + messageId + " found in any bundle");
                        return new FacesMessage(severity, messageId, null);
                    }
                }
            }
        }
        if (args != null && args.length > 0) {
            return new _ParametrizableFacesMessage(severity, summary, detail, args, locale);
        }
        return new FacesMessage(severity, summary, detail);
    }

    private static String getBundleString(ResourceBundle bundle, String key) {
        try {
            return bundle == null ? null : bundle.getString(key);
        }
        catch (MissingResourceException missingResourceException) {
            return null;
        }
    }

    private static ResourceBundle getApplicationBundle(FacesContext facesContext, Locale locale) {
        String bundleName = facesContext.getApplication().getMessageBundle();
        return bundleName != null ? _MessageUtils.getBundle(facesContext, locale, bundleName) : null;
    }

    private static ResourceBundle getDefaultBundle(FacesContext facesContext, Locale locale) {
        return _MessageUtils.getBundle(facesContext, locale, "javax.faces.Messages");
    }

    private static ResourceBundle getBundle(FacesContext facesContext, Locale locale, String bundleName) {
        try {
            return ResourceBundle.getBundle(bundleName, locale, facesContext.getClass().getClassLoader());
        }
        catch (MissingResourceException missingResourceException) {
            try {
                return ResourceBundle.getBundle(bundleName, locale, _MessageUtils.class.getClassLoader());
            }
            catch (MissingResourceException missingResourceException2) {
                try {
                    if (System.getSecurityManager() != null) {
                        Object cl = AccessController.doPrivileged(new PrivilegedExceptionAction(){

                            public Object run() throws PrivilegedActionException {
                                return Thread.currentThread().getContextClassLoader();
                            }
                        });
                        return ResourceBundle.getBundle(bundleName, locale, (ClassLoader)cl);
                    }
                    return ResourceBundle.getBundle(bundleName, locale, Thread.currentThread().getContextClassLoader());
                }
                catch (PrivilegedActionException pae) {
                    throw new FacesException(pae);
                }
                catch (MissingResourceException missingResourceException3) {
                    facesContext.getExternalContext().log("resource bundle " + bundleName + " could not be found");
                    return null;
                }
            }
        }
    }

    static Object getLabel(FacesContext facesContext, UIComponent component) {
        Object label = component.getAttributes().get("label");
        ValueExpression expression = null;
        if (label != null && label instanceof String && ((String)label).length() == 0 && (expression = component.getValueExpression("label")) != null) {
            label = null;
        }
        if (label != null) {
            return label;
        }
        ValueExpression valueExpression = expression = expression == null ? component.getValueExpression("label") : expression;
        if (expression != null) {
            return expression;
        }
        return component.getClientId(facesContext);
    }
}

