/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.glassfish.ui.wizards;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import oracle.eclipse.tools.glassfish.GlassFishInstall;
import oracle.eclipse.tools.glassfish.Messages;
import oracle.eclipse.tools.glassfish.ui.wizards.GlassfishRuntimeWizardFragment;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.jst.server.generic.core.internal.GenericServerRuntime;
import org.eclipse.jst.server.generic.core.internal.Trace;
import org.eclipse.jst.server.generic.ui.internal.GenericServerComposite;
import org.eclipse.jst.server.generic.ui.internal.GenericServerCompositeDecorator;
import org.eclipse.jst.server.generic.ui.internal.GenericServerUIMessages;
import org.eclipse.jst.server.generic.ui.internal.SWTUtil;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;
import org.eclipse.wst.server.core.IRuntime;
import org.eclipse.wst.server.core.ServerCore;
import org.eclipse.wst.server.core.TaskModel;
import org.eclipse.wst.server.core.internal.IInstallableRuntime;
import org.eclipse.wst.server.core.internal.ServerPlugin;
import org.eclipse.wst.server.ui.internal.wizard.TaskWizard;
import org.eclipse.wst.server.ui.internal.wizard.fragment.LicenseWizardFragment;
import org.eclipse.wst.server.ui.wizard.IWizardHandle;
import org.eclipse.wst.server.ui.wizard.WizardFragment;

public class GlassfishRuntimeWizardFragmentDecorator
implements GenericServerCompositeDecorator {
    private static final String INSTALL_DIR_NAME = "glassfish";
    private static final String BIN_DIR_NAME = "bin";
    private static final String ADMIN_SCRIPT_NAME = "asadmin";
    private IWizardHandle fWizard;
    private GenericServerRuntime fRuntime;
    private String unzipDirectoryName;
    private Text path;
    private Text runtimeName;
    private Button installButton;
    private Label messageFoundRuntime;
    private GlassfishRuntimeWizardFragment wzdFragment;

    public GlassfishRuntimeWizardFragmentDecorator(GlassfishRuntimeWizardFragment fargment, IWizardHandle wizard, GenericServerRuntime runtime, String unzipDirName) {
        this.fWizard = wizard;
        this.fRuntime = runtime;
        this.unzipDirectoryName = unzipDirName;
        this.wzdFragment = fargment;
    }

    public void setRuntime() {
        GenericServerRuntime newRuntime = this.wzdFragment.getRuntimeDelegate();
        if (newRuntime != this.fRuntime) {
            this.fRuntime = newRuntime;
            String location = this.path.getText();
            this.fRuntime.getRuntimeWorkingCopy().setLocation((IPath)new Path(location));
            this.fRuntime.getRuntimeWorkingCopy().setName(this.runtimeName.getText());
        }
    }

    public void decorate(GenericServerComposite composite) {
        Dialog.applyDialogFont((Control)composite);
        this.runtimeName = SWTUtil.createLabeledText((String)Messages.runtimeName, (String)this.fRuntime.getRuntimeWorkingCopy().getName(), (Composite)composite);
        this.runtimeName.addModifyListener((ModifyListener)new RuntimeNameModifyListener());
        String location = this.fRuntime.getRuntimeWorkingCopy().getLocation() != null ? this.fRuntime.getRuntimeWorkingCopy().getLocation().toString() : "";
        this.path = SWTUtil.createLabeledPath((String)Messages.serverHome, (String)location, (Composite)composite);
        this.path.addModifyListener((ModifyListener)new PathModifyListener());
        String pathText = this.path.getText();
        new Label((Composite)composite, 0);
        this.messageFoundRuntime = new Label((Composite)composite, 0);
        this.messageFoundRuntime.setText("");
        new Label((Composite)composite, 0);
        IInstallableRuntime ir = ServerPlugin.findInstallableRuntime((String)this.fRuntime.getRuntime().getRuntimeType().getId());
        if (ir != null) {
            this.installButton = this.createInstallButton(ir, composite);
            this.installButton.setEnabled(!pathText.isEmpty());
        }
        if (pathText.length() > 0) {
            this.validatePath(pathText);
        }
    }

    private String getInternalDirectoryName(String installDir) {
        return String.valueOf(installDir) + File.separatorChar + this.unzipDirectoryName + File.separatorChar + INSTALL_DIR_NAME;
    }

    private void correctPermissions(String installDir) {
        String osName = System.getProperty("os.name");
        if (!osName.startsWith("Windows")) {
            String binDir = String.valueOf(this.getInternalDirectoryName(installDir)) + File.separatorChar + BIN_DIR_NAME;
            String scriptName = String.valueOf(binDir) + File.separatorChar + ADMIN_SCRIPT_NAME;
            try {
                Runtime.getRuntime().exec("chmod a+x " + scriptName);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public Map getValues() {
        HashMap<String, String> propertyMap = new HashMap<String, String>();
        propertyMap.put("sunappserver.rootdirectory", this.path.getText());
        propertyMap.put("sunappserver.runtimeName", this.runtimeName.getText());
        return propertyMap;
    }

    private void validatePath(String path) {
        if (path.length() < 1) {
            this.fWizard.setMessage(GenericServerUIMessages.emptyPath, 3);
            this.installButton.setEnabled(false);
        } else if (!this.pathExist(path)) {
            this.fWizard.setMessage(NLS.bind((String)Messages.pathDoesNotExist, (Object)"Specified path"), 3);
            this.installButton.setEnabled(false);
        } else if (this.pathInstallable(path)) {
            this.fWizard.setMessage(Messages.canInstallPath, 3);
            this.installButton.setEnabled(true);
        } else {
            boolean isInvalid = this.validate();
            if (isInvalid) {
                String glassfishDir = String.valueOf(path) + File.separatorChar + INSTALL_DIR_NAME;
                String unzipDirName = this.getInternalDirectoryName(path);
                if (this.pathExist(glassfishDir)) {
                    this.fWizard.setMessage(NLS.bind((String)Messages.possibleInstallExists, (Object)INSTALL_DIR_NAME), 3);
                    this.installButton.setEnabled(false);
                } else if (this.pathExist(unzipDirName)) {
                    this.fWizard.setMessage(NLS.bind((String)Messages.possibleInstallExists, (Object)(String.valueOf(this.unzipDirectoryName) + File.separatorChar + INSTALL_DIR_NAME)), 3);
                    this.installButton.setEnabled(false);
                }
            } else {
                this.installButton.setEnabled(false);
                if (!this.pathWriteable(path)) {
                    this.fWizard.setMessage(NLS.bind((String)Messages.pathNotWritable, (Object)"Specified path"), 3);
                    this.installButton.setEnabled(false);
                }
            }
        }
    }

    private boolean pathWriteable(String path2) {
        return true;
    }

    private boolean pathInstallable(String path) {
        File f = new File(path);
        return f.exists() && f.isDirectory() && f.list().length == 0;
    }

    private boolean pathExist(String path) {
        File f = new File(path);
        return f.exists();
    }

    public boolean validate() {
        this.setRuntime();
        String location = this.path.getText();
        if (this.messageFoundRuntime.getText().isEmpty()) {
            this.identifyRuntime(location);
        }
        this.fRuntime.setServerDefinitionId(this.fRuntime.getRuntime().getRuntimeType().getId());
        this.fRuntime.setServerInstanceProperties(this.getValues());
        IStatus status = this.fRuntime.validate();
        if (status == null || status.isOK()) {
            this.fWizard.setMessage(null, 0);
            this.fRuntime.getRuntimeWorkingCopy().setLocation((IPath)new Path(location));
            this.fRuntime.getRuntimeWorkingCopy().setName(this.runtimeName.getText());
            if (this.messageFoundRuntime.getText().isEmpty()) {
                this.identifyRuntime(location);
            }
            this.fWizard.update();
            return false;
        }
        this.fWizard.setMessage(status.getMessage(), 3);
        this.fWizard.update();
        return true;
    }

    private void identifyRuntime(String location) {
        String v;
        GlassFishInstall gfInstall = GlassFishInstall.find((File)new File(location));
        if (gfInstall != null && (v = gfInstall.versionString()) != null) {
            this.messageFoundRuntime.setText(NLS.bind((String)Messages.runtimeIdentified, (Object)v));
            this.messageFoundRuntime.getParent().layout();
        }
    }

    private Button createInstallButton(final IInstallableRuntime ir, final GenericServerComposite composite) {
        Button installButton = SWTUtil.createButton((Composite)composite, (String)GenericServerUIMessages.installServerButton);
        Label label = new Label((Composite)composite, 0);
        label.setText("(to enable Install Server, enter a path to a new directory....)");
        installButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent se) {
                final String selectedDirectory = GlassfishRuntimeWizardFragmentDecorator.this.path.getText();
                if (selectedDirectory != null) {
                    String license = null;
                    try {
                        license = ir.getLicense((IProgressMonitor)new NullProgressMonitor());
                    }
                    catch (CoreException e) {
                        Trace.trace((byte)2, (String)"Error getting license", (Throwable)e);
                    }
                    TaskModel taskModel = new TaskModel();
                    taskModel.putObject("license", (Object)license);
                    TaskWizard wizard2 = new TaskWizard(GenericServerUIMessages.installServerButton, new WizardFragment(){

                        protected void createChildFragments(List list) {
                            list.add(new LicenseWizardFragment());
                        }
                    }, taskModel);
                    WizardDialog dialog2 = new WizardDialog(composite.getShell(), (IWizard)wizard2);
                    if (dialog2.open() == 1) {
                        return;
                    }
                    IRunnableWithProgress runnable = new IRunnableWithProgress(){

                        public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                            try {
                                monitor.beginTask(Messages.downloadingServer, -1);
                                ir.install((IPath)new Path(selectedDirectory), monitor);
                                GlassfishRuntimeWizardFragmentDecorator.this.correctPermissions(selectedDirectory);
                                monitor.done();
                            }
                            catch (CoreException e) {
                                Trace.trace((byte)2, (String)"Error installing runtime", (Throwable)e);
                            }
                        }
                    };
                    try {
                        GlassfishRuntimeWizardFragmentDecorator.this.fWizard.run(true, true, runnable);
                        GlassfishRuntimeWizardFragmentDecorator.this.path.setText(GlassfishRuntimeWizardFragmentDecorator.this.getInternalDirectoryName(selectedDirectory));
                        GlassfishRuntimeWizardFragmentDecorator.this.validate();
                    }
                    catch (Exception e) {
                        Trace.trace((byte)2, (String)"Error installing runtime", (Throwable)e);
                    }
                }
            }
        });
        return installButton;
    }

    private final class PathModifyListener
    implements ModifyListener {
        private PathModifyListener() {
        }

        public void modifyText(ModifyEvent e) {
            GlassfishRuntimeWizardFragmentDecorator.this.messageFoundRuntime.setText("");
            String path = ((Text)e.widget).getText();
            GlassfishRuntimeWizardFragmentDecorator.this.validatePath(path);
        }
    }

    private final class RuntimeNameModifyListener
    implements ModifyListener {
        private RuntimeNameModifyListener() {
        }

        public void modifyText(ModifyEvent e) {
            String name = ((Text)e.widget).getText();
            if (name == null || name.isEmpty()) {
                GlassfishRuntimeWizardFragmentDecorator.this.fWizard.setMessage(Messages.emptyRuntimeName, 3);
                return;
            }
            IRuntime[] runtimes = ServerCore.getRuntimes();
            int i = 0;
            while (i < runtimes.length) {
                if (name.equals(runtimes[i].getName())) {
                    GlassfishRuntimeWizardFragmentDecorator.this.fWizard.setMessage(Messages.duplicateRuntimeName, 3);
                    return;
                }
                ++i;
            }
            GlassfishRuntimeWizardFragmentDecorator.this.validate();
        }
    }
}

