/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.glassfish.ui.wizards;

import oracle.eclipse.tools.glassfish.ui.wizards.GlassfishRuntimeWizardFragmentDecorator;
import oracle.eclipse.tools.glassfish.ui.wizards.JDKSelectDecorator;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jst.server.generic.core.internal.GenericServerRuntime;
import org.eclipse.jst.server.generic.ui.internal.GenericServerComposite;
import org.eclipse.jst.server.generic.ui.internal.GenericServerCompositeDecorator;
import org.eclipse.jst.server.generic.ui.internal.GenericServerUIMessages;
import org.eclipse.jst.server.generic.ui.internal.ServerDefinitionTypeAwareWizardFragment;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.wst.server.core.IRuntimeWorkingCopy;
import org.eclipse.wst.server.ui.wizard.IWizardHandle;

public abstract class GlassfishRuntimeWizardFragment
extends ServerDefinitionTypeAwareWizardFragment {
    private GenericServerCompositeDecorator[] fDecorators;

    public boolean isComplete() {
        GenericServerRuntime runtime = this.getRuntimeDelegate();
        if (runtime == null) {
            return false;
        }
        IStatus status = runtime.validate();
        return status != null && status.isOK();
    }

    public void createContent(Composite parent, IWizardHandle handle) {
        this.fDecorators = new GenericServerCompositeDecorator[2];
        this.fDecorators[0] = new JDKSelectDecorator(this, this.getWizard(), this.getRuntimeDelegate());
        this.fDecorators[1] = new GlassfishRuntimeWizardFragmentDecorator(this, this.getWizard(), this.getRuntimeDelegate(), this.getUnzipDirectoryName());
        new GenericServerComposite(parent, this.fDecorators);
    }

    protected abstract String getUnzipDirectoryName();

    public void enter() {
        int i = 0;
        while (i < this.fDecorators.length) {
            if (this.fDecorators[i].validate()) {
                return;
            }
            ++i;
        }
    }

    public void exit() {
        int i = 0;
        while (i < this.fDecorators.length) {
            if (this.fDecorators[i].validate()) {
                return;
            }
            ++i;
        }
    }

    GenericServerRuntime getRuntimeDelegate() {
        IRuntimeWorkingCopy wc = (IRuntimeWorkingCopy)this.getTaskModel().getObject("runtime");
        if (wc == null) {
            return null;
        }
        return (GenericServerRuntime)wc.loadAdapter(GenericServerRuntime.class, (IProgressMonitor)new NullProgressMonitor());
    }

    public String description() {
        String rName = this.getRuntimeName();
        if (rName == null || rName.length() < 1) {
            rName = "Generic";
        }
        return NLS.bind((String)GenericServerUIMessages.runtimeWizardDescription, (Object)rName);
    }

    public String title() {
        String rName = this.getRuntimeName();
        if (rName == null || rName.length() < 1) {
            rName = "Generic";
        }
        return NLS.bind((String)GenericServerUIMessages.runtimeWizardTitle, (Object)rName);
    }

    private String getRuntimeName() {
        if (this.getRuntimeDelegate() != null && this.getRuntimeDelegate().getRuntime() != null) {
            return this.getRuntimeDelegate().getRuntime().getRuntimeType().getName();
        }
        return null;
    }
}

