/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.glassfish.ui.wizards;

import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import oracle.eclipse.tools.glassfish.GlassfishGenericServer;
import oracle.eclipse.tools.glassfish.GlassfishGenericServerBehaviour;
import oracle.eclipse.tools.glassfish.GlassfishToolsPlugin;
import oracle.eclipse.tools.glassfish.ServerStatus;
import oracle.eclipse.tools.glassfish.utils.ServerStatusHelper;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jst.server.generic.servertype.definition.Property;
import org.eclipse.jst.server.generic.servertype.definition.ServerRuntime;
import org.eclipse.jst.server.generic.ui.internal.SWTUtil;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.wst.common.frameworks.internal.dialog.ui.MessageDialog;
import org.eclipse.wst.server.core.IServerWorkingCopy;
import org.eclipse.wst.server.ui.wizard.IWizardHandle;
import org.eclipse.wst.server.ui.wizard.WizardFragment;

public class GFWizardCreation
extends WizardFragment {
    private Helper helper;
    private IWizardHandle handle;
    private boolean isValid = false;

    public Composite createComposite(Composite parent, IWizardHandle handle) {
        this.handle = handle;
        Composite container = new Composite(parent, 0);
        GridLayout grid = new GridLayout(1, false);
        grid.marginWidth = 0;
        container.setLayout((Layout)grid);
        container.setLayoutData((Object)new GridData(1808));
        handle.setImageDescriptor(ImageDescriptor.createFromURL((URL)GlassfishToolsPlugin.getInstance().getBundle().getEntry("/icons/wizard75x66.png")));
        handle.setTitle("GlassFish Application Server");
        handle.setDescription("Enter the configuration parameters for this GlassFish domain...");
        IServerWorkingCopy server = this.getServer();
        GlassfishGenericServer gf = (GlassfishGenericServer)server.loadAdapter(GlassfishGenericServer.class, null);
        this.helper = new Helper(handle, gf, server);
        Composite cp = new Composite(container, 0);
        GridLayout layout = new GridLayout(3, false);
        cp.setLayout((Layout)layout);
        cp.setLayoutData((Object)new GridData(1808));
        this.helper.decorate(cp);
        return container;
    }

    public boolean hasComposite() {
        return true;
    }

    private IServerWorkingCopy getServer() {
        IServerWorkingCopy server = (IServerWorkingCopy)this.getTaskModel().getObject("server");
        return server;
    }

    public void enter() {
        IServerWorkingCopy server = this.getServer();
        server.setAttribute("auto-publish-setting", 1);
        GlassfishGenericServer gf = (GlassfishGenericServer)server.loadAdapter(GlassfishGenericServer.class, null);
        this.isValid = false;
        this.helper.updateServer(gf, server);
        this.helper.validate();
    }

    public boolean isComplete() {
        return this.isValid;
    }

    public void exit() {
    }

    class Helper {
        private GlassfishGenericServer glassfish;
        private IServerWorkingCopy serverCopy;
        private ArrayList<Control> fPropertyControls = null;
        protected String fLastMessage;
        protected IWizardHandle fWizard;
        private Text path = null;
        private Text adminName = null;
        private Text adminPassword = null;
        private Text adminport = null;
        private Button preserveSessions = null;
        private Label domainDirLabel = null;
        private Label adminportLabel = null;
        private Button pingButton = null;
        private Button domainBrowseButton = null;
        private ModifyListener pathModifyListener = new PathModifyListener();

        public void updateServer(GlassfishGenericServer server, IServerWorkingCopy scopy) {
            this.glassfish = server;
            this.serverCopy = scopy;
            if (this.path.isDisposed()) {
                return;
            }
            if (!this.glassfish.isRemote()) {
                String defaultLocation = "" + this.serverCopy.getRuntime().getLocation();
                File f = new File(defaultLocation, "/domains/domain1");
                defaultLocation = f.getAbsolutePath();
                this.path.removeModifyListener(this.pathModifyListener);
                this.path.setText(defaultLocation);
                this.path.addModifyListener(this.pathModifyListener);
                this.path.setVisible(true);
                this.domainBrowseButton.setVisible(true);
                this.domainDirLabel.setVisible(true);
                this.adminport.setVisible(false);
                this.adminportLabel.setVisible(false);
                this.pingButton.setVisible(false);
            } else {
                this.path.setVisible(false);
                this.domainBrowseButton.setVisible(false);
                this.domainDirLabel.setVisible(false);
                this.adminport.setVisible(true);
                this.adminportLabel.setVisible(true);
                this.pingButton.setVisible(true);
            }
        }

        public Helper(IWizardHandle handle, GlassfishGenericServer server, IServerWorkingCopy scopy) {
            this.glassfish = server;
            this.fWizard = handle;
            this.serverCopy = scopy;
        }

        public void decorate(Composite parent) {
            this.fPropertyControls = new ArrayList();
            Map<String, Property> serverProps = this.getServerProperties(this.glassfish.getServerDefinition());
            Property prop = null;
            String defaultLocation = "" + this.serverCopy.getRuntime().getLocation();
            File f = new File(defaultLocation, "/domains/domain1");
            defaultLocation = f.getAbsolutePath();
            prop = serverProps.get("sunappserver.domainpath");
            this.domainDirLabel = new Label(parent, 0);
            this.domainDirLabel.setText(prop.getLabel());
            GridData gridData = new GridData(4, 1, true, false);
            gridData.horizontalSpan = 1;
            this.path = new Text(parent, 2052);
            this.path.setLayoutData((Object)gridData);
            this.path.setText(prop.getDefault());
            this.path.setData((Object)"sunappserver.domainpath");
            this.fPropertyControls.add((Control)this.path);
            this.domainBrowseButton = SWTUtil.createButton((Composite)parent, (String)"Browse");
            this.path.addModifyListener(this.pathModifyListener);
            final Shell s = this.domainBrowseButton.getShell();
            this.domainBrowseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    DirectoryDialog dlg = new DirectoryDialog(s);
                    dlg.setFilterPath(Helper.this.path.getText().replace('\\', '/'));
                    dlg.setMessage("Select a GlassFish Domain Directory");
                    String res = dlg.open();
                    if (res != null) {
                        Helper.this.path.setText(res.replace('\\', '/'));
                    }
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                    this.widgetSelected(e);
                }
            });
            prop = serverProps.get("sunappserver.adminname");
            Label adminNameLabel = new Label(parent, 0);
            adminNameLabel.setText(prop.getLabel());
            gridData = new GridData(4, 1, true, false);
            gridData.horizontalSpan = 2;
            this.adminName = new Text(parent, 2052);
            this.adminName.setText(prop.getDefault());
            this.adminName.setData((Object)"sunappserver.adminname");
            this.adminName.setLayoutData((Object)gridData);
            this.adminName.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    Helper.this.validate();
                }
            });
            this.fPropertyControls.add((Control)this.adminName);
            prop = serverProps.get("sunappserver.adminpassword");
            Label adminPassLabel = new Label(parent, 0);
            adminPassLabel.setText(prop.getLabel());
            gridData = new GridData(4, 1, true, false);
            gridData.horizontalSpan = 2;
            this.adminPassword = new Text(parent, 2052);
            this.adminPassword.setEchoChar('*');
            this.adminPassword.setData((Object)"sunappserver.adminpassword");
            this.adminPassword.setLayoutData((Object)gridData);
            this.adminPassword.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    Helper.this.validate();
                }
            });
            this.fPropertyControls.add((Control)this.adminPassword);
            prop = serverProps.get("sunappserver.adminserverportnumber");
            GridData gridData2 = new GridData(4, 1, true, false);
            gridData2.horizontalSpan = 2;
            this.adminportLabel = new Label(parent, 0);
            this.adminportLabel.setText(prop.getLabel());
            this.adminport = new Text(parent, 2052);
            this.adminport.setText(prop.getDefault());
            this.adminport.setLayoutData((Object)gridData2);
            this.adminport.setData((Object)"sunappserver.adminserverportnumber");
            this.adminport.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    Helper.this.validate();
                }
            });
            this.fPropertyControls.add((Control)this.adminport);
            prop = serverProps.get("sunappserver.keepSessions");
            this.preserveSessions = new Button(parent, 32);
            this.preserveSessions.setText(prop.getLabel());
            this.preserveSessions.setSelection(Boolean.parseBoolean(prop.getDefault()));
            gridData = new GridData();
            gridData.horizontalSpan = 3;
            this.preserveSessions.setLayoutData((Object)gridData);
            this.preserveSessions.setData((Object)"sunappserver.keepSessions");
            this.fPropertyControls.add((Control)this.preserveSessions);
            this.pingButton = SWTUtil.createButton((Composite)parent, (String)"Ping Server...");
            Listener listener = new Listener(){

                public void handleEvent(Event event) {
                    Helper.this.validateRemote();
                }
            };
            this.pingButton.addListener(13, listener);
            Dialog.applyDialogFont((Control)parent);
        }

        protected Group createGroup(Composite parent) {
            Group group = new Group(parent, 0);
            GridData data = new GridData(768);
            data.horizontalSpan = 2;
            group.setLayoutData((Object)data);
            GridLayout layout = new GridLayout();
            layout.numColumns = 2;
            group.setLayout((Layout)layout);
            return group;
        }

        public Map getValues() {
            HashMap<String, String> propertyMap = new HashMap<String, String>();
            int i = 0;
            while (i < this.fPropertyControls.size()) {
                Control c = this.fPropertyControls.get(i);
                String prop = (String)c.getData();
                if (prop != null && c.isVisible() && c.isEnabled()) {
                    if (this.fPropertyControls.get(i) instanceof Button) {
                        Button button = (Button)this.fPropertyControls.get(i);
                        propertyMap.put(prop, Boolean.toString(button.getSelection()));
                    } else if (this.fPropertyControls.get(i) instanceof Combo) {
                        Combo combo = (Combo)this.fPropertyControls.get(i);
                        int index = combo.getSelectionIndex();
                        if (index > 0) {
                            propertyMap.put(prop, combo.getItem(index));
                        } else {
                            propertyMap.put(prop, combo.getText());
                        }
                    } else {
                        Text text = (Text)this.fPropertyControls.get(i);
                        propertyMap.put(prop, text.getText());
                    }
                }
                ++i;
            }
            return propertyMap;
        }

        private Map<String, Property> getServerProperties(ServerRuntime serverDef) {
            HashMap<String, Property> propertiesMap = new HashMap<String, Property>(serverDef.getProperty().size());
            int i = 0;
            while (i < serverDef.getProperty().size()) {
                Property p = (Property)serverDef.getProperty().get(i);
                propertiesMap.put(p.getId(), p);
                ++i;
            }
            return propertiesMap;
        }

        public boolean validate() {
            IStatus status = null;
            if (this.glassfish != null) {
                this.glassfish.setServerInstanceProperties(this.getValues());
                status = this.glassfish.validate();
            }
            if (status != null && !status.isOK()) {
                this.pingButton.setEnabled(false);
                GFWizardCreation.this.isValid = false;
                this.fWizard.setMessage(status.getMessage(), 3);
                this.fWizard.update();
                return false;
            }
            this.pingButton.setEnabled(true);
            GFWizardCreation.this.isValid = true;
            this.fWizard.setMessage(null, 0);
            this.fWizard.update();
            return true;
        }

        public boolean validateRemote() {
            boolean isRemote = this.glassfish.isRemote();
            if (isRemote) {
                ServerStatus s = ServerStatusHelper.checkServerStatus((GlassfishGenericServer)this.glassfish);
                if (!s.equals((Object)ServerStatus.RUNNING_DOMAIN_MATCHING)) {
                    StringBuilder errorMessage = new StringBuilder();
                    errorMessage.append("Cannot communicate with ");
                    errorMessage.append(this.glassfish.getServer().getHost());
                    errorMessage.append(":");
                    errorMessage.append(this.glassfish.getAdminServerPort());
                    errorMessage.append(" remote server.");
                    if (s.equals((Object)ServerStatus.STOPPED_NOT_LISTENING)) {
                        errorMessage.append(" Is it up?");
                    } else if (s.equals((Object)ServerStatus.RUNNING_REMOTE_NOT_SECURE)) {
                        errorMessage.append(" Is it secure? (Hint: run asadmin enable-secure-admin)");
                    } else if (s.equals((Object)ServerStatus.RUNNING_CREDENTIAL_PROBLEM)) {
                        errorMessage.append(" Wrong user name or password. Check your credentials.");
                    } else if (s.equals((Object)ServerStatus.RUNNING_PROXY_ERROR)) {
                        errorMessage.append(" Check your proxy settings.");
                    } else if (s.equals((Object)ServerStatus.RUNNING_CONNECTION_ERROR)) {
                        errorMessage.append(" Is it up?");
                        errorMessage.append(" Is it secure? (Hint: run asadmin enable-secure-admin)");
                    }
                    Status status = new Status(4, "oracle.eclipse.tools.glassfish", errorMessage.toString());
                    MessageDialog.openMessage((Shell)Display.getDefault().getActiveShell(), (String)"Error", (String)"Error connecting to remote server", (IStatus)status);
                    return false;
                }
                String remoteServerVersion = GlassfishGenericServerBehaviour.getVersion((GlassfishGenericServer)this.glassfish);
                String thisServerVersion = GFWizardCreation.this.getServer().getRuntime().getRuntimeType().getVersion();
                int n = thisServerVersion.indexOf(".X");
                if (n > 0) {
                    thisServerVersion = thisServerVersion.substring(0, n + 1);
                }
                if (remoteServerVersion != null && remoteServerVersion.indexOf(thisServerVersion) < 0) {
                    String errorMessage = "The remote server version is " + remoteServerVersion;
                    Status status = new Status(4, "oracle.eclipse.tools.glassfish", errorMessage.toString());
                    MessageDialog.openMessage((Shell)Display.getDefault().getActiveShell(), (String)"Error", (String)"Server versions not match", (IStatus)status);
                    return false;
                }
            }
            org.eclipse.jface.dialogs.MessageDialog.openInformation((Shell)Display.getDefault().getActiveShell(), (String)"Success", (String)"Connecting to remote server succeeded");
            return true;
        }

        private final class PathModifyListener
        implements ModifyListener {
            private PathModifyListener() {
            }

            public void modifyText(ModifyEvent e) {
                String path = ((Text)e.widget).getText();
                if (path.length() < 1) {
                    GFWizardCreation.this.isValid = false;
                    Helper.this.fLastMessage = "Specify a valid GlassFish Domain directory";
                    Helper.this.fWizard.setMessage(Helper.this.fLastMessage, 3);
                    Helper.this.fWizard.update();
                } else {
                    Helper.this.validate();
                }
            }
        }
    }
}

