/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.glassfish.ui.serverview.actions;

import java.net.URL;
import oracle.eclipse.tools.glassfish.GlassfishGenericServer;
import oracle.eclipse.tools.glassfish.GlassfishGenericServerBehaviour;
import oracle.eclipse.tools.glassfish.GlassfishToolsPlugin;
import oracle.eclipse.tools.glassfish.ui.serverview.DeployedWebServicesNode;
import oracle.eclipse.tools.glassfish.ui.serverview.WebServiceNode;
import oracle.eclipse.tools.glassfish.utils.Utils;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.swt.widgets.Event;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.browser.IWebBrowser;
import org.eclipse.ui.browser.IWorkbenchBrowserSupport;

public class WSDLInfoWebServiceAction
extends Action {
    ISelection selection;

    public WSDLInfoWebServiceAction(ISelection selection) {
        this.setText("Show WDSL content in Browser");
        this.selection = selection;
    }

    public void runWithEvent(Event event) {
        if (this.selection instanceof TreeSelection) {
            TreeSelection ts = (TreeSelection)this.selection;
            Object obj = ts.getFirstElement();
            if (obj instanceof WebServiceNode) {
                WebServiceNode module = (WebServiceNode)obj;
                DeployedWebServicesNode target = (DeployedWebServicesNode)module.getParent();
                try {
                    GlassfishGenericServerBehaviour be = target.getServer().getServerBehaviourAdapter();
                    IWorkbenchBrowserSupport browserSupport = PlatformUI.getWorkbench().getBrowserSupport();
                    IWebBrowser browser = browserSupport.createBrowser(6, null, null, null);
                    GlassfishGenericServer server = be.getSunAppServer();
                    String host = server.getServer().getHost();
                    int port = Integer.parseInt(server.getServerPort());
                    String url = String.valueOf(Utils.getHttpListenerProtocol((String)host, (int)port)) + "://" + host + ":" + port + "/" + module.getWSInfo().getName();
                    browser.openURL(new URL(url));
                }
                catch (Exception e) {
                    GlassfishToolsPlugin.logMessage((String)("Error opening browser: " + e.getMessage()));
                }
            }
            super.run();
        }
    }

    public void run() {
        this.runWithEvent(null);
    }
}

