/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.glassfish.ui.resources.wizards;

import java.util.ArrayList;
import java.util.List;
import oracle.eclipse.tools.glassfish.ui.resources.JMSInfo;
import oracle.eclipse.tools.glassfish.ui.resources.wizards.Messages;
import oracle.eclipse.tools.glassfish.utils.ResourceUtils;
import org.eclipse.core.resources.IProject;
import org.eclipse.jem.util.emf.workbench.ProjectUtilities;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.glassfish.tools.ide.server.parser.ResourcesReader;

public class JMSResourceWizardPage
extends WizardPage {
    private Text jndiText;
    private Button queueRButton;
    private Button topicRButton;
    private Button queueConnectionRButton;
    private Button topicConnectionRButton;
    private Button connectionRButton;
    private IProject selectedProject;
    private List<IProject> candidateProjects;
    private JMSInfo jmsInfo;
    private Combo projectNameCombo;
    private List<String> resources = new ArrayList<String>();
    private String defaultJndiName = "jms/myQueue";

    public JMSResourceWizardPage(IProject project, List<IProject> projects) {
        super("wizardPage");
        this.setTitle(Messages.jmsWizardTitle);
        this.setDescription(Messages.jmsWizardDescription);
        this.selectedProject = project;
        this.candidateProjects = projects;
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        container.setLayout((Layout)layout);
        Label label = new Label(container, 0);
        label.setText(Messages.ProjectName);
        this.projectNameCombo = new Combo(container, 12);
        GridDataFactory.defaultsFor((Control)this.projectNameCombo).span(2, 1).applyTo((Control)this.projectNameCombo);
        this.projectNameCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }

            public void widgetSelected(SelectionEvent e) {
                String newSelection = JMSResourceWizardPage.this.projectNameCombo.getText();
                if (newSelection != null) {
                    JMSResourceWizardPage.this.selectedProject = ProjectUtilities.getProject((String)newSelection);
                    JMSResourceWizardPage.this.resources = ResourceUtils.getResources((IProject)JMSResourceWizardPage.this.selectedProject, (ResourcesReader.ResourceType[])new ResourcesReader.ResourceType[]{ResourcesReader.ResourceType.JDBC_RESOURCE});
                    JMSResourceWizardPage.this.dialogChanged();
                }
            }
        });
        label = new Label(container, 0);
        label.setText(Messages.JNDIName);
        this.jndiText = new Text(container, 2052);
        GridDataFactory.defaultsFor((Control)this.jndiText).span(2, 1).applyTo((Control)this.jndiText);
        this.jndiText.setText(this.defaultJndiName);
        this.jndiText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                JMSResourceWizardPage.this.dialogChanged();
            }
        });
        label = new Label(container, 0);
        GridDataFactory.defaultsFor((Control)label).span(3, 1).applyTo((Control)label);
        label = new Label(container, 0);
        label.setText(Messages.lblChooseType);
        GridDataFactory.defaultsFor((Control)label).span(3, 1).applyTo((Control)label);
        label = new Label(container, 0);
        GridDataFactory.defaultsFor((Control)label).span(3, 1).applyTo((Control)label);
        label = new Label(container, 0);
        label.setText(Messages.lblAdminObject);
        GridDataFactory.defaultsFor((Control)label).span(3, 1).applyTo((Control)label);
        GridData gridData = new GridData();
        gridData.horizontalIndent = 40;
        gridData.horizontalSpan = 3;
        gridData.horizontalAlignment = 4;
        this.queueRButton = new Button(container, 16);
        this.queueRButton.setText(Messages.lblQueue);
        this.queueRButton.setLayoutData((Object)gridData);
        this.queueRButton.setSelection(true);
        this.topicRButton = new Button(container, 16);
        this.topicRButton.setText(Messages.lblTopic);
        this.topicRButton.setLayoutData((Object)gridData);
        label = new Label(container, 0);
        GridDataFactory.defaultsFor((Control)label).span(3, 1).applyTo((Control)label);
        label = new Label(container, 0);
        label.setText(Messages.lblConnector);
        GridDataFactory.defaultsFor((Control)label).span(3, 1).applyTo((Control)label);
        this.queueConnectionRButton = new Button(container, 16);
        this.queueConnectionRButton.setText(Messages.lblQueueConnectionFactory);
        this.queueConnectionRButton.setLayoutData((Object)gridData);
        this.topicConnectionRButton = new Button(container, 16);
        this.topicConnectionRButton.setText(Messages.lblTopicConnectionFactory);
        this.topicConnectionRButton.setLayoutData((Object)gridData);
        this.connectionRButton = new Button(container, 16);
        this.connectionRButton.setText(Messages.lblConnectionFactory);
        this.connectionRButton.setLayoutData((Object)gridData);
        this.initialize();
        this.dialogChanged();
        this.setControl((Control)container);
    }

    private void initialize() {
        this.resources = ResourceUtils.getResources((IProject)this.selectedProject, (ResourcesReader.ResourceType[])new ResourcesReader.ResourceType[]{ResourcesReader.ResourceType.CONNECTOR_RESOURCE, ResourcesReader.ResourceType.ADMIN_OBJECT_RESOURCE});
        if (this.resources.contains(this.defaultJndiName)) {
            String jndiName = ResourceUtils.getUniqueResourceName((String)this.defaultJndiName, this.resources);
            this.jndiText.setText(jndiName);
        }
        this.populateCombos();
        this.dialogChanged();
    }

    public String getJNDIName() {
        return this.jndiText.getText();
    }

    public String getResourceType() {
        String resourceType = null;
        if (this.queueRButton.getSelection()) {
            resourceType = "javax.jms.Queue";
        } else if (this.topicRButton.getSelection()) {
            resourceType = "javax.jms.Topic";
        } else if (this.queueConnectionRButton.getSelection()) {
            resourceType = "javax.jms.QueueConnectionFactory";
        } else if (this.topicConnectionRButton.getSelection()) {
            resourceType = "javax.jms.TopicConnectionFactory";
        } else if (this.connectionRButton.getSelection()) {
            resourceType = "javax.jms.ConnectionFactory";
        }
        return resourceType;
    }

    public IProject getSelectedProject() {
        return this.selectedProject;
    }

    private void dialogChanged() {
        boolean hasProject;
        this.setPageComplete(false);
        boolean bl = hasProject = this.projectNameCombo.getSelectionIndex() != -1;
        if (!hasProject) {
            this.setErrorMessage(Messages.errorProjectMissing);
            return;
        }
        String jndiName = this.getJNDIName();
        if (jndiName.length() == 0) {
            this.setErrorMessage(Messages.errorJndiNameMissing);
            return;
        }
        if (ResourceUtils.isDuplicate((String)jndiName, this.resources)) {
            this.setErrorMessage(NLS.bind((String)Messages.errorDuplicateName, (Object)jndiName));
            return;
        }
        if (this.getResourceType() == null || this.getResourceType().length() == 0) {
            this.setErrorMessage(Messages.errorResourceTypeMissing);
            return;
        }
        this.setPageComplete(true);
        this.setErrorMessage(null);
    }

    private void populateCombos() {
        this.projectNameCombo.removeAll();
        String selectProjectName = this.selectedProject != null ? this.selectedProject.getName() : null;
        int selectionIndex = -1;
        int i = 0;
        while (i < this.candidateProjects.size()) {
            IProject nextProject = this.candidateProjects.get(i);
            String projectName = nextProject.getName();
            this.projectNameCombo.add(projectName);
            if (projectName.equals(selectProjectName)) {
                selectionIndex = i;
            }
            ++i;
        }
        if (selectionIndex != -1 && this.projectNameCombo.getItemCount() > 0) {
            this.projectNameCombo.select(selectionIndex);
        } else {
            this.selectedProject = null;
        }
    }

    public JMSInfo getJMSInfo() {
        this.jmsInfo = new JMSInfo();
        this.jmsInfo.setJndiName(this.getJNDIName());
        this.jmsInfo.setResourceType(this.getResourceType());
        return this.jmsInfo;
    }
}

