/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.webtier.javawebapp.document;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.CopyOnWriteArrayList;
import oracle.eclipse.tools.application.common.services.appservices.IAppLocalizer;
import oracle.eclipse.tools.application.common.services.appservices.IBundleResource;
import oracle.eclipse.tools.application.common.services.documentservices.DOMUtil;
import oracle.eclipse.tools.application.common.services.documentservices.IDocumentLocalizationContext;
import oracle.eclipse.tools.application.common.services.documentservices.LocalizationRangeStore;
import oracle.eclipse.tools.application.common.services.documentservices.internal.IDocumentLocalizationContextWorkingCopy;
import oracle.eclipse.tools.common.services.document.AbstractDocumentService;
import oracle.eclipse.tools.common.services.document.IDocument;
import oracle.eclipse.tools.common.services.project.technology.ITechnologyExtensionIdentifier;

public abstract class AbstractJavaAppDocumentLocalizationContext
extends AbstractDocumentService
implements IDocumentLocalizationContextWorkingCopy,
Comparable<IDocumentLocalizationContext> {
    private final ITechnologyExtensionIdentifier _id;
    private final IAppLocalizer _localizer;
    protected final DOMUtil _domUtil;
    protected final LocalizationRangeStore<String> _bundleStore;
    protected final LocalizationRangeStore<Locale> _localeStore;
    private final CopyOnWriteArrayList<IDocumentLocalizationContext.ILocalizationListener> _listeners;
    private final List<IDocumentLocalizationContext.LocalizationChange> _queuedChangeEvents;
    private final RangeStoreListener _rangeStoreListener;

    public AbstractJavaAppDocumentLocalizationContext(IDocument doc, ITechnologyExtensionIdentifier id, IAppLocalizer localizer) {
        super(doc);
        this._id = id;
        this._localizer = localizer;
        this._domUtil = new DOMUtil();
        this._queuedChangeEvents = new ArrayList<IDocumentLocalizationContext.LocalizationChange>();
        this._listeners = new CopyOnWriteArrayList();
        this._rangeStoreListener = new RangeStoreListener(this._queuedChangeEvents);
        this._bundleStore = new LocalizationRangeStore((Object)"", IDocumentLocalizationContext.LocalizationChange.Type.BUNDLE);
        this._bundleStore.addListener((LocalizationRangeStore.IRangeStoreListener)this._rangeStoreListener);
        this._localeStore = new LocalizationRangeStore((Object)new Locale(""), IDocumentLocalizationContext.LocalizationChange.Type.LOCALE);
        this._localeStore.addListener((LocalizationRangeStore.IRangeStoreListener)this._rangeStoreListener);
    }

    public String getImplicitBundleName(int offset) {
        return null;
    }

    protected String getDefaultBundleName() {
        return this._localizer.getDefaultBaseName();
    }

    @Override
    public abstract int compareTo(IDocumentLocalizationContext var1);

    protected final int useMeBefore() {
        return -1;
    }

    protected final int useMeAfter() {
        return 1;
    }

    public final ITechnologyExtensionIdentifier getOwner() {
        return this._id;
    }

    public Locale resolveLocale(int offset, List<Locale> preferredLocales) {
        return this._localizer.resolveLocale(preferredLocales);
    }

    public Collection<Locale> getAvailableLocale() {
        return Collections.emptyList();
    }

    public LocalizationRangeStore<String> getBundleRangeStore() {
        return this._bundleStore;
    }

    public LocalizationRangeStore<Locale> getLocaleRangeStore() {
        return this._localeStore;
    }

    public void dispose() {
        this._localizer.dispose();
        this._bundleStore.removeListener((LocalizationRangeStore.IRangeStoreListener)this._rangeStoreListener);
        this._localeStore.removeListener((LocalizationRangeStore.IRangeStoreListener)this._rangeStoreListener);
        this._listeners.clear();
    }

    public final IBundleResource resolveBundle(int offset, String baseName, Locale locale) {
        throw new UnsupportedOperationException("resolveBundle should not be called from individual JavaApp service adapters.  Use the main web apps context obtained from IDocument.getAdapter()");
    }

    public void addListener(IDocumentLocalizationContext.ILocalizationListener listener) {
        this._listeners.addIfAbsent(listener);
    }

    public void removeListener(IDocumentLocalizationContext.ILocalizationListener listener) {
        this._listeners.remove(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flushQueuedEvents() {
        List<IDocumentLocalizationContext.LocalizationChange> list = this._queuedChangeEvents;
        synchronized (list) {
            if (!this._queuedChangeEvents.isEmpty()) {
                this.fireEvent(new IDocumentLocalizationContext.LocalizationChangeEvent(this.getDocument(), this._queuedChangeEvents));
                this._queuedChangeEvents.clear();
            }
        }
    }

    protected final void fireEvent(IDocumentLocalizationContext.LocalizationChangeEvent event) {
        for (IDocumentLocalizationContext.ILocalizationListener listener : this._listeners) {
            listener.changeOccurred(event);
        }
    }

    private static class RangeStoreListener
    implements LocalizationRangeStore.IRangeStoreListener {
        private final List<IDocumentLocalizationContext.LocalizationChange> _updateMe;

        public RangeStoreListener(List<IDocumentLocalizationContext.LocalizationChange> updateMe) {
            this._updateMe = updateMe;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void changeOccurred(LocalizationRangeStore.RangeStoreChangeEvent event) {
            List<IDocumentLocalizationContext.LocalizationChange> list = this._updateMe;
            synchronized (list) {
                this._updateMe.add(event.getChange());
            }
        }
    }
}

