/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.webtier.javawebapp.dependency.artifact.collection.javaee;

import java.io.IOException;
import oracle.eclipse.tools.application.common.services.collection.IStructuredDocumentCollectionContext;
import oracle.eclipse.tools.common.services.dependency.artifact.IArtifact;
import oracle.eclipse.tools.common.services.dependency.artifact.resource.ResourceArtifact;
import oracle.eclipse.tools.common.services.dependency.structuredmodel.IStructuredXMLModelVisitor;
import oracle.eclipse.tools.common.services.dependency.structuredmodel.IVisitableDOMModel;
import oracle.eclipse.tools.common.services.dependency.structuredmodel.StructuredModelFactory;
import oracle.eclipse.tools.common.util.ProgressMonitorUtil;
import oracle.eclipse.tools.common.util.logging.LoggingService;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMAttr;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMDocument;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMElement;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.w3c.dom.Element;

public class JavaEEWebApplicationCollector {
    private static final String WEB_APP_ELEMENT_NAME = "web-app";
    private static final String SERVLET_ELEMENT_NAME = "servlet";
    private static final String JSP_FILE_ELEMENT_NAME = "jsp-file";
    private static final String WEB_APP_VERSION_NAME = "version";
    private static final String JSP_CONFIG_ELEMENT_NAME = "jsp-config";
    private static final String TAGLIB_ELEMENT_NAME = "taglib";
    private static final String TAGLIB_LOCATION_ELEMENT_NAME = "taglib-location";
    private static final String JSP_PROPERTY_GROUP_ELEMENT_NAME = "jsp-property-group";
    private static final String INCLUDE_CODA_ELEMENT_NAME = "include-coda";
    private static final String INCLUDE_PRELUDE_ELEMENT_NAME = "include-prelude";
    private static final String ERROR_PAGE_ELEMENT_NAME = "error-page";
    private static final String LOCATION_ELEMENT_NAME = "location";
    private final String collectorID;
    private final IStructuredDocumentCollectionContext context;
    private final IFile webXml;

    private JavaEEWebApplicationCollector(IFile webXml, IStructuredDocumentCollectionContext context, String collectorID) {
        this.webXml = webXml;
        this.context = context;
        this.collectorID = collectorID;
    }

    public void collect(IProgressMonitor monitor) {
        block17: {
            block19: {
                IVisitableDOMModel domModel = null;
                try {
                    ProgressMonitorUtil.beginTask((IProgressMonitor)monitor, (String)"Collect JavaEE Artifacts for web.xml", (int)5);
                    ResourceArtifact webXmlArtifact = this.context.ensureResourceArtifact((IResource)this.webXml);
                    this.context.resetCollection((IArtifact)webXmlArtifact, this.collectorID);
                    domModel = StructuredModelFactory.getVisitableModelForRead((IFile)this.webXml);
                    if (domModel != null) {
                        domModel.accept((IStructuredXMLModelVisitor)new Visitor(this.context, webXmlArtifact));
                    }
                }
                catch (CoreException ce) {
                    LoggingService.logException((String)"oracle.eclipse.tools.webtier.javawebapp", (CoreException)ce);
                    if (domModel != null) {
                        try {
                            domModel.dispose();
                        }
                        catch (IllegalStateException illegalStateException) {}
                    }
                    ProgressMonitorUtil.done((IProgressMonitor)monitor);
                    break block17;
                }
                catch (IOException ioe) {
                    block18: {
                        try {
                            LoggingService.logException((String)"oracle.eclipse.tools.webtier.javawebapp", (Throwable)ioe);
                            if (domModel == null) break block18;
                        }
                        catch (Throwable throwable) {
                            if (domModel != null) {
                                try {
                                    domModel.dispose();
                                }
                                catch (IllegalStateException illegalStateException) {}
                            }
                            ProgressMonitorUtil.done((IProgressMonitor)monitor);
                            throw throwable;
                        }
                        try {
                            domModel.dispose();
                        }
                        catch (IllegalStateException illegalStateException) {}
                    }
                    ProgressMonitorUtil.done((IProgressMonitor)monitor);
                    break block17;
                }
                if (domModel == null) break block19;
                try {
                    domModel.dispose();
                }
                catch (IllegalStateException illegalStateException) {}
            }
            ProgressMonitorUtil.done((IProgressMonitor)monitor);
        }
    }

    /* synthetic */ JavaEEWebApplicationCollector(IFile iFile, IStructuredDocumentCollectionContext iStructuredDocumentCollectionContext, String string, JavaEEWebApplicationCollector javaEEWebApplicationCollector) {
        this(iFile, iStructuredDocumentCollectionContext, string);
    }

    public static class JavaEEWebApplicationCollectorBuilder {
        private String collectorID = null;
        private IStructuredDocumentCollectionContext context = null;
        private IFile webXml = null;

        public JavaEEWebApplicationCollectorBuilder setCollectorID(String collectorID) {
            this.collectorID = collectorID;
            return this;
        }

        public JavaEEWebApplicationCollectorBuilder setContext(IStructuredDocumentCollectionContext context) {
            this.context = context;
            return this;
        }

        public JavaEEWebApplicationCollectorBuilder setWebXmlFile(IFile webXml) {
            this.webXml = webXml;
            return this;
        }

        public JavaEEWebApplicationCollector build() {
            if (this.collectorID == null || this.context == null || this.webXml == null) {
                throw new IllegalStateException("collectorID, context and webXml setters must be called with non-null args.");
            }
            return new JavaEEWebApplicationCollector(this.webXml, this.context, this.collectorID, null);
        }
    }

    private class Visitor
    implements IStructuredXMLModelVisitor {
        private final ResourceArtifact webXmlArtifact;
        private final IStructuredDocumentCollectionContext sdContext;

        public Visitor(IStructuredDocumentCollectionContext context, ResourceArtifact webXmlArtifact) {
            this.sdContext = context;
            this.webXmlArtifact = webXmlArtifact;
        }

        public boolean visit(IDOMElement element) {
            String nodeName;
            String string = nodeName = element == null ? null : element.getNodeName();
            if (JavaEEWebApplicationCollector.SERVLET_ELEMENT_NAME.equals(nodeName) || JavaEEWebApplicationCollector.JSP_CONFIG_ELEMENT_NAME.equals(nodeName) || JavaEEWebApplicationCollector.ERROR_PAGE_ELEMENT_NAME.equals(nodeName) || JavaEEWebApplicationCollector.TAGLIB_ELEMENT_NAME.equals(nodeName) || JavaEEWebApplicationCollector.JSP_PROPERTY_GROUP_ELEMENT_NAME.equals(nodeName)) {
                return true;
            }
            if (JavaEEWebApplicationCollector.JSP_FILE_ELEMENT_NAME.equals(nodeName) || JavaEEWebApplicationCollector.LOCATION_ELEMENT_NAME.equals(nodeName) || JavaEEWebApplicationCollector.TAGLIB_LOCATION_ELEMENT_NAME.equals(nodeName) || JavaEEWebApplicationCollector.INCLUDE_CODA_ELEMENT_NAME.equals(nodeName) || JavaEEWebApplicationCollector.INCLUDE_PRELUDE_ELEMENT_NAME.equals(nodeName)) {
                this.sdContext.createResourceReferenceFromElement((IArtifact)this.webXmlArtifact, element, false, JavaEEWebApplicationCollector.this.collectorID);
            } else if (JavaEEWebApplicationCollector.WEB_APP_ELEMENT_NAME.equals(nodeName)) {
                this.getWebAppVersion((Element)element);
                return true;
            }
            return false;
        }

        public boolean visit(IDOMNode node) {
            return false;
        }

        public boolean visit(IDOMAttr attribute) {
            return false;
        }

        public boolean visit(IDOMDocument document) {
            return true;
        }

        private Float getWebAppVersion(Element webAppElement) {
            if (webAppElement.getAttribute(JavaEEWebApplicationCollector.WEB_APP_VERSION_NAME) != null) {
                try {
                    return Float.valueOf(webAppElement.getAttribute(JavaEEWebApplicationCollector.WEB_APP_VERSION_NAME));
                }
                catch (NumberFormatException numberFormatException) {}
            }
            return null;
        }
    }
}

