/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.webtier.javawebapp.dependency.artifact.collection;

import java.util.Collections;
import java.util.Set;
import oracle.eclipse.tools.application.common.services.collection.IStructuredDocumentCollectionContext;
import oracle.eclipse.tools.application.common.services.collection.IStructuredDocumentResourceCollectionContext;
import oracle.eclipse.tools.application.common.services.collection.IStructuredModelCollectionVisitor;
import oracle.eclipse.tools.common.services.dependency.artifact.IArtifact;
import oracle.eclipse.tools.common.services.dependency.artifact.IResourceContext;
import oracle.eclipse.tools.common.services.dependency.artifact.collection.IResourceCollectionContext;
import oracle.eclipse.tools.webtier.javawebapp.dependency.artifact.collection.WebApplicationDescriptorTypeFilter;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMAttr;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMDocument;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMElement;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;

public class WebApplicationCollector
implements IStructuredModelCollectionVisitor {
    private static final String WEB_APP_ELEMENT_NAME = "web-app";
    private static final String SERVLET_ELEMENT_NAME = "servlet";
    private static final String JSP_FILE_ELEMENT_NAME = "jsp-file";
    private static final String JSP_CONFIG_ELEMENT_NAME = "jsp-config";
    private static final String TAGLIB_ELEMENT_NAME = "taglib";
    private static final String TAGLIB_LOCATION_ELEMENT_NAME = "taglib-location";
    private static final String JSP_PROPERTY_GROUP_ELEMENT_NAME = "jsp-property-group";
    private static final String INCLUDE_CODA_ELEMENT_NAME = "include-coda";
    private static final String INCLUDE_PRELUDE_ELEMENT_NAME = "include-prelude";
    private static final String ERROR_PAGE_ELEMENT_NAME = "error-page";
    private static final String LOCATION_ELEMENT_NAME = "location";
    IStructuredDocumentCollectionContext structuredContext = null;
    private boolean isWebXml = false;
    private IArtifact webXmlArtifact = null;

    public void beginResource(IStructuredDocumentResourceCollectionContext resourceContext, IProgressMonitor monitor) {
        if (monitor != null && monitor.isCanceled()) {
            return;
        }
        resourceContext.resetCollection(this.getID());
        this.webXmlArtifact = this.structuredContext.ensureResourceArtifact(resourceContext.getResource());
        this.isWebXml = this.webXmlArtifact != null;
    }

    public void endResource(IStructuredDocumentResourceCollectionContext resourceContext, IProgressMonitor monitor) {
        this.isWebXml = false;
        this.webXmlArtifact = null;
    }

    public String getID() {
        return "WEB";
    }

    public void startCollecting(IStructuredDocumentCollectionContext context, IProgressMonitor monitor) {
        this.structuredContext = context;
    }

    public IStatus stopCollecting(IProgressMonitor monitor) {
        return Status.OK_STATUS;
    }

    public boolean visit(IDOMNode node) {
        return false;
    }

    public boolean visit(IDOMAttr attribute) {
        return false;
    }

    public boolean visit(IDOMElement element) {
        String nodeName;
        String string = nodeName = element == null ? null : element.getNodeName();
        if (SERVLET_ELEMENT_NAME.equals(nodeName) || JSP_CONFIG_ELEMENT_NAME.equals(nodeName) || ERROR_PAGE_ELEMENT_NAME.equals(nodeName) || TAGLIB_ELEMENT_NAME.equals(nodeName) || JSP_PROPERTY_GROUP_ELEMENT_NAME.equals(nodeName) || WEB_APP_ELEMENT_NAME.equals(nodeName)) {
            return true;
        }
        if (JSP_FILE_ELEMENT_NAME.equals(nodeName) || LOCATION_ELEMENT_NAME.equals(nodeName) || TAGLIB_LOCATION_ELEMENT_NAME.equals(nodeName) || INCLUDE_CODA_ELEMENT_NAME.equals(nodeName) || INCLUDE_PRELUDE_ELEMENT_NAME.equals(nodeName)) {
            this.structuredContext.createResourceReferenceFromElement(this.webXmlArtifact, element, false, this.getID());
        }
        return false;
    }

    public boolean visit(IDOMDocument document) {
        return this.isWebXml;
    }

    public boolean match(IResourceCollectionContext context) {
        return WebApplicationDescriptorTypeFilter.getInstance().match((IResourceContext)context);
    }

    public final Set<IResource> getDependentResources(Set<IResource> changedResources, IProgressMonitor monitor) {
        return Collections.emptySet();
    }
}

