/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.webtier.javawebapp.dependency.artifact.collection;

import java.util.Set;
import oracle.eclipse.tools.application.common.services.collection.AbstractArtifactCollector;
import oracle.eclipse.tools.application.common.services.collection.IStructuredDocumentResourceCollectionContext;
import oracle.eclipse.tools.application.common.services.variables.JavaResourceBundleDataType;
import oracle.eclipse.tools.application.common.services.variables.ValueReference;
import oracle.eclipse.tools.application.common.services.variables.Variable;
import oracle.eclipse.tools.application.common.services.variables.VariableReferenceIterator;
import oracle.eclipse.tools.application.common.services.variables.VariablesController;
import oracle.eclipse.tools.application.common.services.variables.VariablesIterator;
import oracle.eclipse.tools.common.services.dependency.artifact.ArtifactReferenceLocation;
import oracle.eclipse.tools.common.services.dependency.artifact.IArtifact;
import oracle.eclipse.tools.common.services.dependency.artifact.IArtifactReference;
import oracle.eclipse.tools.common.services.dependency.artifact.IArtifactReferenceLocation;
import oracle.eclipse.tools.common.services.dependency.artifact.Range;
import oracle.eclipse.tools.common.services.dependency.artifact.ResourceLocation;
import oracle.eclipse.tools.common.services.dependency.artifact.resource.ResourceArtifact;
import oracle.eclipse.tools.webtier.javawebapp.dependency.artifact.collection.JavaResourceBundleReference;
import oracle.eclipse.tools.webtier.javawebapp.dependency.artifact.collection.JavaResourceBundleReferenceLocation;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMAttr;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMDocument;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMElement;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;

public class BundleReferenceCollector
extends AbstractArtifactCollector {
    protected BundleReferenceCollector(String id, Set<String> contentTypes) {
        super(id, contentTypes);
    }

    public void beginResource(IStructuredDocumentResourceCollectionContext resourceContext, IProgressMonitor monitor) {
        IFile file;
        ResourceArtifact artifact;
        super.beginResource(resourceContext, monitor);
        if (monitor != null && monitor.isCanceled()) {
            return;
        }
        if (resourceContext.getResource().getType() == 1 && (artifact = this.structuredContext.ensureResourceArtifact((IResource)(file = (IFile)resourceContext.getResource()))) != null) {
            Variable var;
            VariableReferenceIterator iter = VariablesController.getInstance().referenceIterator(file, false);
            while (iter.hasNext() && (monitor == null || !monitor.isCanceled())) {
                ValueReference reference = iter.next();
                var = reference.getVariable();
                if (!(var.getType() instanceof JavaResourceBundleDataType)) continue;
                JavaResourceBundleDataType bundleType = (JavaResourceBundleDataType)var.getType();
                ResourceLocation loc = new ResourceLocation((IResource)file, reference.getLocation());
                JavaResourceBundleReference ref = new JavaResourceBundleReference((IArtifact)artifact, bundleType, file);
                ref.addLocation((IArtifactReferenceLocation)new JavaResourceBundleReferenceLocation((IArtifactReferenceLocation)new ArtifactReferenceLocation(loc, true, this.getID()), reference.getFieldName()));
                this.structuredContext.addReferencedArtifact((IArtifact)artifact, (IArtifactReference)ref, true, (byte)0);
            }
            if (monitor != null && monitor.isCanceled()) {
                return;
            }
            VariablesIterator varIter = VariablesController.getInstance().iterator(file, false);
            while (varIter.hasNext() && (monitor == null || !monitor.isCanceled())) {
                IResource declarationFile;
                IMarker marker;
                var = varIter.next();
                if (!(var.getType() instanceof JavaResourceBundleDataType) || (marker = var.getMarker()) == null || !file.equals((Object)(declarationFile = marker.getResource()))) continue;
                int start = marker.getAttribute("charStart", -1);
                int end = marker.getAttribute("charEnd", -1);
                if (start == -1 || end <= 0 || end <= start) continue;
                Range range = new Range((long)start, (long)(end - start));
                JavaResourceBundleDataType bundleType = (JavaResourceBundleDataType)var.getType();
                ResourceLocation loc = new ResourceLocation((IResource)file, range);
                JavaResourceBundleReference ref = new JavaResourceBundleReference((IArtifact)artifact, bundleType, file);
                ref.addLocation((IArtifactReferenceLocation)new JavaResourceBundleReferenceLocation((IArtifactReferenceLocation)new ArtifactReferenceLocation(loc, true, this.getID()), null));
                this.structuredContext.addReferencedArtifact((IArtifact)artifact, (IArtifactReference)ref, true, (byte)0);
            }
        }
    }

    public boolean visit(IDOMNode node) {
        return false;
    }

    public boolean visit(IDOMElement element) {
        return false;
    }

    public boolean visit(IDOMDocument document) {
        return false;
    }

    public boolean visit(IDOMAttr attribute) {
        return false;
    }
}

