/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.webtier.javawebapp.app;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import oracle.eclipse.tools.application.common.services.appservices.IAppLocalizer;
import oracle.eclipse.tools.application.common.services.appservices.IBundleResource;
import oracle.eclipse.tools.application.common.services.appservices.TechComposingAppService;
import oracle.eclipse.tools.application.common.services.webapp.javasrc.ParentAndResource;
import oracle.eclipse.tools.common.services.project.EnvFileListener;
import oracle.eclipse.tools.common.services.project.FileEvent;
import oracle.eclipse.tools.common.services.project.Project;
import oracle.eclipse.tools.common.services.project.technology.ITechnologyExtensionIdentifier;
import oracle.eclipse.tools.webtier.javawebapp.app.JavaWebAppLocalizer;
import org.eclipse.core.resources.IFile;

public class JavaWebAppLocalizerService
extends TechComposingAppService<IAppLocalizer>
implements IAppLocalizer {
    private final JavaWebAppLocalizer _javaLocalizer;
    private final CopyOnWriteArrayList<IAppLocalizer.IAppLocalizationChangeListener> _listeners;
    private final MyEnvFileListener _localizerListener;

    public JavaWebAppLocalizerService(Project project) {
        super(project);
        this._javaLocalizer = new JavaWebAppLocalizer(project);
        this._listeners = new CopyOnWriteArrayList();
        this._localizerListener = new MyEnvFileListener(this){

            @Override
            protected void fireEvent(IAppLocalizer.AppLocalizationChangeEvent event) {
                JavaWebAppLocalizerService.this.fireEvent(event);
            }
        };
        this._javaLocalizer.addListener(this._localizerListener);
    }

    protected void fireEvent(IAppLocalizer.AppLocalizationChangeEvent event) {
        for (IAppLocalizer.IAppLocalizationChangeListener listener : this._listeners) {
            listener.changeOccurred(event);
        }
    }

    private List<IAppLocalizer> getSortedExtensions() {
        List extensions = this.createComposedServiceList(IAppLocalizer.class);
        Collections.sort(extensions);
        return extensions;
    }

    public Locale resolveLocale(List<Locale> preferredLocales) {
        List<IAppLocalizer> extensions = this.getSortedExtensions();
        for (IAppLocalizer context : extensions) {
            Locale locale = context.resolveLocale(preferredLocales);
            if (locale == null) continue;
            return locale;
        }
        return null;
    }

    public void dispose() {
        this._javaLocalizer.removeListener(this._localizerListener);
        this._javaLocalizer.dispose();
        this._listeners.clear();
    }

    public Set<String> getAllBaseNames() {
        return this._javaLocalizer.getAllBaseNames();
    }

    public Set<String> getAllBaseNames(boolean includeJarFiles) {
        return this._javaLocalizer.getAllBaseNames(includeJarFiles);
    }

    public Set<ParentAndResource> getAllBaseNamesWithParents(boolean includeJarFiles) {
        return this._javaLocalizer.getAllBaseNamesWithParents(includeJarFiles);
    }

    public Collection<Locale> getAvailableLocales(String baseName) {
        return this._javaLocalizer.getAvailableLocales(baseName);
    }

    public Collection<IFile> getBundleFiles(String baseName) {
        return this._javaLocalizer.getAllResourceFiles(baseName);
    }

    public IBundleResource resolveBundle(String baseName, Locale locale) {
        return this._javaLocalizer.resolveBundle(baseName, locale);
    }

    public ITechnologyExtensionIdentifier getOwner() {
        throw new UnsupportedOperationException("This is a special context that aggregates other technlogies");
    }

    public String getDefaultBaseName() {
        return this._javaLocalizer.getDefaultBaseName();
    }

    public void addListener(IAppLocalizer.IAppLocalizationChangeListener listener) {
        this._listeners.addIfAbsent(listener);
    }

    public void removeListener(IAppLocalizer.IAppLocalizationChangeListener listener) {
        this._listeners.remove(listener);
    }

    static abstract class MyEnvFileListener
    implements EnvFileListener {
        private final IAppLocalizer _appLocalizer;

        public MyEnvFileListener(IAppLocalizer appLocalizer) {
            this._appLocalizer = appLocalizer;
        }

        protected abstract void fireEvent(IAppLocalizer.AppLocalizationChangeEvent var1);

        public void fileAdded(FileEvent event) {
            this.fireEvent(new IAppLocalizer.AppLocalizationChangeEvent(this._appLocalizer, event));
        }

        public void fileChanged(FileEvent event) {
            this.fireEvent(new IAppLocalizer.AppLocalizationChangeEvent(this._appLocalizer, event));
        }

        public void fileMoved(FileEvent event) {
            this.fireEvent(new IAppLocalizer.AppLocalizationChangeEvent(this._appLocalizer, event));
        }

        public void fileRemoved(FileEvent event) {
            this.fireEvent(new IAppLocalizer.AppLocalizationChangeEvent(this._appLocalizer, event));
        }
    }
}

