/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.webtier.javawebapp;

import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLStreamHandler;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.List;
import java.util.Vector;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import oracle.eclipse.tools.application.common.services.util.LogMgr;
import oracle.eclipse.tools.common.util.classloader.MultiParentClassLoader;
import oracle.eclipse.tools.common.util.classloader.jarnocache.JarProtocolHandlerWithoutLeak;
import oracle.eclipse.tools.common.util.logging.LoggingService;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;

public class WebTierJarClassLoader
extends ClassLoader {
    private static final boolean DEBUG_CLASSLOADER = Boolean.valueOf(Platform.getDebugOption((String)"oracle.eclipse.tools.webtier.javawebapp/debug/classloader"));
    private List<ClassPathEntry> _openFiles;
    private final List<ClassPathEntry> _files;
    private List<JarCLInputStream> _openStreams = new LinkedList<JarCLInputStream>();
    private boolean _open = false;
    private IJavaProject _jproj;

    public WebTierJarClassLoader(IJavaProject jproj, boolean filterOutExternals) {
        this(jproj, filterOutExternals, null);
    }

    public WebTierJarClassLoader(IJavaProject jproj, boolean filterOutExternals, ClassLoader parent) {
        super(parent);
        this._jproj = jproj;
        this._files = this.getProjectClassPathEntries(filterOutExternals);
    }

    public synchronized void open() {
        if (this._open) {
            return;
        }
        this._openFiles = new ArrayList<ClassPathEntry>(this._files.size());
        for (ClassPathEntry cpEntry : this._files) {
            this.openEntry(cpEntry);
        }
        this._open = true;
        this._openStreams = new LinkedList<JarCLInputStream>();
    }

    private void openEntry(ClassPathEntry cpEntry) {
        long time = System.nanoTime();
        long openTime = System.nanoTime();
        cpEntry.open();
        if (DEBUG_CLASSLOADER) {
            System.out.printf(">>>>>>   Cost of opening cpEntry %s is %d\n", cpEntry.toString(), System.nanoTime() - openTime);
        }
        this._openFiles.add(cpEntry);
        this._recursiveGetManifestJars(cpEntry, this._openFiles, true);
        if (DEBUG_CLASSLOADER) {
            System.out.printf(">>>>>>   Cost of initializing cpEntry %s is %d\n", cpEntry.toString(), System.nanoTime() - time);
        }
    }

    private List<ClassPathEntry> getProjectClassPathEntries(boolean filterOutExternals) {
        ArrayList<ClassPathEntry> result;
        block14: {
            result = new ArrayList<ClassPathEntry>();
            if (this._jproj == null) break block14;
            try {
                long time = System.nanoTime();
                IPackageFragmentRoot[] entries = this._jproj.getAllPackageFragmentRoots();
                if (DEBUG_CLASSLOADER) {
                    System.out.printf("\t>>>>> Cost of getting frag roots is %d\n", System.nanoTime() - time);
                }
                IPackageFragmentRoot[] iPackageFragmentRootArray = entries;
                int n = entries.length;
                int n2 = 0;
                while (n2 < n) {
                    block16: {
                        ClassPathEntry newInternalCPEntry;
                        block17: {
                            IResource resource;
                            IPackageFragmentRoot entry;
                            block15: {
                                entry = iPackageFragmentRootArray[n2];
                                newInternalCPEntry = null;
                                if (!entry.isExternal()) break block15;
                                if (filterOutExternals) break block16;
                                IPath path = entry.getPath();
                                newInternalCPEntry = entry.isArchive() ? new JarClassPathEntry(path.toFile(), entry) : new DirectoryClassPathEntry(path);
                                break block17;
                            }
                            if (entry.isArchive()) {
                                File file;
                                IPath rawLocation;
                                resource = entry.getResource();
                                if (resource != null && resource.exists() && (rawLocation = resource.getRawLocation()) != null && (file = rawLocation.toFile()) != null) {
                                    newInternalCPEntry = new JarClassPathEntry(file, entry);
                                }
                            } else {
                                resource = entry.getCorrespondingResource();
                                if (entry.getKind() == 1) {
                                    if (entry.getResource().getProject().equals((Object)this._jproj.getProject())) {
                                        IClasspathEntry cpEntry = JavaCore.getResolvedClasspathEntry((IClasspathEntry)entry.getRawClasspathEntry());
                                        IPath path = cpEntry.getOutputLocation();
                                        if (path == null) {
                                            path = this._jproj.getOutputLocation();
                                            path = this._jproj.getProject().getLocation().append(path.removeFirstSegments(1));
                                        } else {
                                            path = this._jproj.getProject().getWorkspace().getRoot().getLocation().append(path);
                                        }
                                        newInternalCPEntry = new DirectoryClassPathEntry(path);
                                    } else {
                                        IPath path = entry.getJavaProject().getOutputLocation();
                                        path = entry.getJavaProject().getProject().getLocation().append(path.removeFirstSegments(1));
                                        newInternalCPEntry = new DirectoryClassPathEntry(path);
                                    }
                                } else {
                                    newInternalCPEntry = new DirectoryClassPathEntry(resource.getLocation());
                                }
                            }
                        }
                        if (newInternalCPEntry != null) {
                            result.add(newInternalCPEntry);
                        }
                    }
                    ++n2;
                }
            }
            catch (JavaModelException e) {
                LogMgr.getUnhandledExceptionLogger().error("getAllTypes failed:", (Exception)((Object)e));
            }
        }
        return result;
    }

    public synchronized void close() {
        if (!this._open) {
            return;
        }
        this._open = false;
        for (JarCLInputStream st : this._openStreams) {
            try {
                st.close();
            }
            catch (IOException ioe) {
                LoggingService.logException((String)"oracle.eclipse.tools.webtier.javawebapp", (Throwable)ioe, (String)"Failed to close stream");
            }
        }
        this._openStreams = null;
        for (ClassPathEntry cpEntry : this._openFiles) {
            cpEntry.close();
        }
        this._openFiles = null;
    }

    public Collection<ClassPathEntry> getReachableJarFiles() {
        return this._files;
    }

    public Collection<ClassPathEntry> getFiles() {
        return Collections.unmodifiableCollection(this._files);
    }

    private synchronized void closeInputStream(JarCLInputStream in) {
        if (this._open) {
            this._openStreams.remove(in);
        }
    }

    @Override
    protected synchronized Class<?> findClass(String name) throws ClassNotFoundException {
        Package pkg;
        byte[] b;
        if (!this._open) {
            this.open();
        }
        if ((b = this.loadClassData(name)) == null) {
            throw new ClassNotFoundException("Could not find class " + name);
        }
        Class<?> clazz = this.defineClass(name, b, 0, b.length);
        String pkgName = this.getPackageName(name);
        if (pkgName != null && (pkg = this.getPackage(pkgName)) == null) {
            this.definePackage(pkgName, null, null, null, null, null, null, null);
        }
        return clazz;
    }

    private String getPackageName(String fullyQualifiedName) {
        int index = fullyQualifiedName.lastIndexOf(46);
        if (index != -1) {
            return fullyQualifiedName.substring(0, index);
        }
        return null;
    }

    /*
     * Loose catch block
     */
    private byte[] loadClassData(String name) {
        int len;
        name = name.replace('.', '/');
        InputStream input = this.getResourceAsStreamInternal(name = String.valueOf(name) + ".class");
        if (input == null) {
            return null;
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        byte[] buf = new byte[1024];
        while ((len = input.read(buf)) > 0) {
            baos.write(buf, 0, len);
        }
        baos.close();
        byte[] byArray = baos.toByteArray();
        try {
            input.close();
        }
        catch (IOException iOException) {}
        return byArray;
        catch (IOException iOException) {
            try {}
            catch (Throwable throwable) {
                try {
                    input.close();
                }
                catch (IOException iOException2) {}
                throw throwable;
            }
            try {
                input.close();
            }
            catch (IOException iOException3) {}
            return null;
        }
    }

    private synchronized InputStream getResourceAsStreamInternal(String name) {
        InputStream input = null;
        if (this.getParent() != null) {
            input = this.getParent().getResourceAsStream(name);
        }
        if (input != null) {
            return input;
        }
        if (!this._open) {
            this.open();
        }
        for (ClassPathEntry file : this._openFiles) {
            InputStream inStream = file.getResourceAsStream(name);
            if (inStream == null) continue;
            return inStream;
        }
        return null;
    }

    @Override
    public synchronized InputStream getResourceAsStream(String name) {
        InputStream is = this.getResourceAsStreamInternal(name);
        if (is != null) {
            JarCLInputStream result = new JarCLInputStream(is);
            if (!this._open) {
                this.open();
            }
            this._openStreams.add(result);
            return result;
        }
        return null;
    }

    @Override
    protected synchronized URL findResource(String name) {
        URL parentURL = null;
        if (this.getParent() != null) {
            parentURL = this.getParent().getResource(name);
        }
        if (parentURL != null) {
            return parentURL;
        }
        long time = System.nanoTime();
        if (!this._open) {
            this.open();
        }
        if (DEBUG_CLASSLOADER) {
            System.out.printf("\t>>>>> Cost to open classloader: %d\n", System.nanoTime() - time);
        }
        time = System.nanoTime();
        for (ClassPathEntry f : this._openFiles) {
            URL url = f.findResource(name);
            if (url == null) continue;
            if (DEBUG_CLASSLOADER) {
                System.out.printf("\t>>>>> Cost to find resource in JarClassLoader: %d\n", System.nanoTime() - time);
            }
            return url;
        }
        return null;
    }

    @Override
    protected synchronized Enumeration<URL> findResources(String name) throws IOException {
        if (!this._open) {
            this.open();
        }
        Vector<URL> urls = new Vector<URL>();
        for (ClassPathEntry file : this._openFiles) {
            URL url = file.findResource(name);
            if (url == null) continue;
            urls.add(url);
        }
        return urls.elements();
    }

    private void _recursiveGetManifestJars(ClassPathEntry jarFile, List<ClassPathEntry> manifestJars, boolean openJars) {
        if (!jarFile.isJarFile()) {
            return;
        }
        JarFile jar = null;
        try {
            jar = ((JarClassPathEntry)jarFile).getJarFile();
            if (jar != null) {
                String[] rgPaths;
                Manifest mf = jar.getManifest();
                if (mf == null) {
                    return;
                }
                String classpath = mf.getMainAttributes().getValue(Attributes.Name.CLASS_PATH);
                if (classpath == null) {
                    return;
                }
                File parent = ((JarClassPathEntry)jarFile).getFile().getParentFile();
                String[] stringArray = rgPaths = classpath.split(" ");
                int n = rgPaths.length;
                int n2 = 0;
                while (n2 < n) {
                    JarClassPathEntry cpEntry;
                    File file;
                    String path = stringArray[n2];
                    if (path.length() != 0 && (file = new File(parent, path)).exists() && !manifestJars.contains(cpEntry = new JarClassPathEntry(file, null))) {
                        if (openJars) {
                            cpEntry.open();
                        }
                        manifestJars.add(cpEntry);
                        this._recursiveGetManifestJars(cpEntry, manifestJars);
                    }
                    ++n2;
                }
            } else {
                File file = ((JarClassPathEntry)jarFile).getFile();
                if (file.exists()) {
                    this.openEntry(new DirectoryClassPathEntry((IPath)new Path(file.getPath())));
                }
            }
        }
        catch (IOException iOException) {}
    }

    private void _recursiveGetManifestJars(ClassPathEntry jarFile, List<ClassPathEntry> manifestJars) {
        this._recursiveGetManifestJars(jarFile, manifestJars, false);
    }

    public static final void close(ClassLoader loader) {
        if (loader != null) {
            if (loader instanceof WebTierJarClassLoader) {
                ((WebTierJarClassLoader)loader).close();
                if (loader.getParent() != null && loader.getParent() != loader) {
                    WebTierJarClassLoader.close(loader.getParent());
                }
            } else if (loader instanceof MultiParentClassLoader) {
                ClassLoader[] parents = ((MultiParentClassLoader)loader).getAllParents();
                if (parents != null) {
                    ClassLoader[] classLoaderArray = parents;
                    int n = parents.length;
                    int n2 = 0;
                    while (n2 < n) {
                        ClassLoader parent = classLoaderArray[n2];
                        WebTierJarClassLoader.close(parent);
                        ++n2;
                    }
                }
            } else if (loader.getParent() != null && loader.getParent() != loader) {
                WebTierJarClassLoader.close(loader.getParent());
            }
        }
    }

    private static abstract class ClassPathEntry {
        protected boolean _open = false;
        protected final File _file;

        protected ClassPathEntry(IPath path) {
            this(path.toFile());
        }

        protected ClassPathEntry(File file) {
            this._file = file;
        }

        public final synchronized File getFile() {
            return this._file;
        }

        public void open() {
            if (this._open) {
                return;
            }
            this._open = true;
            this.doOpen();
        }

        protected abstract void doOpen();

        public void close() {
            if (!this._open) {
                return;
            }
            this._open = false;
            this.doClose();
        }

        protected abstract void doClose();

        public abstract boolean isJarFile();

        public abstract boolean equals(Object var1);

        public abstract int hashCode();

        public URL findResource(String name) {
            if (!this._open) {
                this.open();
            }
            return this.doFindResource(name);
        }

        protected abstract URL doFindResource(String var1);

        public synchronized InputStream getResourceAsStream(String name) {
            if (!this._open) {
                this.open();
            }
            return this.doGetResourceAsStream(name);
        }

        protected abstract InputStream doGetResourceAsStream(String var1);
    }

    private static class DirectoryClassPathEntry
    extends ClassPathEntry {
        public DirectoryClassPathEntry(IPath path) {
            super(path);
        }

        @Override
        protected void doOpen() {
        }

        @Override
        protected void doClose() {
        }

        @Override
        public boolean isJarFile() {
            return false;
        }

        public String toString() {
            return "DirectoryClassPathEntry: " + this._file != null ? this._file.toString() : "<uninitialized>";
        }

        @Override
        public boolean equals(Object o) {
            if (!(o instanceof DirectoryClassPathEntry)) {
                return false;
            }
            if (this._file == null) {
                return o == null;
            }
            return this._file.equals(((DirectoryClassPathEntry)o)._file);
        }

        @Override
        public int hashCode() {
            if (this._file == null) {
                return 0;
            }
            return this._file.hashCode();
        }

        @Override
        protected URL doFindResource(String name) {
            if (this._file != null) {
                try {
                    File file = new File(this._file, name);
                    if (file.exists()) {
                        return file.toURI().toURL();
                    }
                }
                catch (MalformedURLException malformedURLException) {}
            }
            return null;
        }

        @Override
        protected InputStream doGetResourceAsStream(String name) {
            if (this._file != null) {
                try {
                    File file = new File(this._file, name);
                    if (file.exists()) {
                        return new BufferedInputStream(new FileInputStream(file));
                    }
                }
                catch (FileNotFoundException fileNotFoundException) {}
            }
            return null;
        }
    }

    private class JarCLInputStream
    extends InputStream {
        private boolean _closed = false;
        private final InputStream _input;

        public JarCLInputStream(InputStream origInput) {
            this._input = origInput;
        }

        @Override
        public void close() throws IOException {
            if (this._closed) {
                return;
            }
            try {
                super.close();
                if (this._input != null) {
                    this._input.close();
                }
                this._closed = true;
            }
            finally {
                WebTierJarClassLoader.this.closeInputStream(this);
            }
        }

        @Override
        public int read() throws IOException {
            return this._input.read();
        }

        @Override
        public int available() throws IOException {
            return this._input.available();
        }

        @Override
        public synchronized void mark(int readlimit) {
            this._input.mark(readlimit);
        }

        @Override
        public boolean markSupported() {
            return this._input.markSupported();
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            return this._input.read(b, off, len);
        }

        @Override
        public int read(byte[] b) throws IOException {
            return this._input.read(b);
        }

        @Override
        public synchronized void reset() throws IOException {
            this._input.reset();
        }

        @Override
        public long skip(long n) throws IOException {
            return this._input.skip(n);
        }
    }

    private static class JarClassPathEntry
    extends ClassPathEntry {
        private JarFile _jarfile;

        public JarClassPathEntry(File file, IPackageFragmentRoot packageRoot) {
            super(file);
        }

        @Override
        protected void doOpen() {
            try {
                long time = System.nanoTime();
                this._jarfile = new JarFile(this._file);
                if (DEBUG_CLASSLOADER) {
                    System.out.printf(">>>>> Cost of opening JarFile %s is %d\n", this._file.toString(), System.nanoTime() - time);
                }
            }
            catch (FileNotFoundException fileNotFoundException) {
            }
            catch (IOException ioe) {
                LoggingService.logException((String)"oracle.eclipse.tools.webtier.javawebapp", (Throwable)ioe, (String)("Unable to create JarFile for cpEntry: " + this._file));
                this._open = false;
            }
        }

        public JarFile getJarFile() {
            return this._jarfile;
        }

        @Override
        protected void doClose() {
            try {
                if (this._jarfile != null) {
                    this._jarfile.close();
                }
                this._jarfile = null;
            }
            catch (IOException ioe) {
                LoggingService.logException((String)"oracle.eclipse.tools.webtier.javawebapp", (Throwable)ioe, (String)("Failed to close jar: " + this._jarfile));
            }
        }

        @Override
        public boolean isJarFile() {
            return true;
        }

        public String toString() {
            return "JarClassPathEntry: " + this._jarfile != null ? this._jarfile.toString() : "<uninitialized>";
        }

        @Override
        public boolean equals(Object o) {
            if (!(o instanceof JarClassPathEntry)) {
                return false;
            }
            if (this._jarfile == null) {
                return o == null;
            }
            return this._jarfile.getName().equals(((JarClassPathEntry)o)._jarfile.getName());
        }

        @Override
        public int hashCode() {
            if (this._jarfile == null || this._jarfile.getName() == null) {
                return 0;
            }
            return this._jarfile.getName().hashCode();
        }

        @Override
        protected URL doFindResource(String name) {
            ZipEntry entry;
            if (this._jarfile != null && (entry = this._jarfile.getEntry(name)) != null) {
                try {
                    String fileUrl = this._file.toURI().toURL().toExternalForm();
                    return new URL("jar", "", -1, String.valueOf(fileUrl) + "!/" + name, (URLStreamHandler)new JarProtocolHandlerWithoutLeak());
                }
                catch (MalformedURLException malformedURLException) {}
            }
            return null;
        }

        @Override
        protected InputStream doGetResourceAsStream(String name) {
            if (this._jarfile != null) {
                try {
                    ZipEntry entry = this._jarfile.getEntry(name);
                    if (entry != null) {
                        return this._jarfile.getInputStream(entry);
                    }
                }
                catch (IOException ioe) {
                    LoggingService.logException((String)"oracle.eclipse.tools.webtier.javawebapp", (Throwable)ioe, (String)("Unable to get entry from jar: " + this._jarfile));
                }
            }
            return null;
        }
    }
}

