/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.webtier.javawebapp;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicInteger;
import oracle.eclipse.tools.application.common.services.appservices.IAppClassLoaderProvider;
import oracle.eclipse.tools.application.common.services.util.LogMgr;
import oracle.eclipse.tools.application.common.services.util.WorkspaceUtil;
import oracle.eclipse.tools.common.util.classloader.JarClassLoader;
import oracle.eclipse.tools.webtier.javawebapp.JarSafeJarClassLoader;
import oracle.eclipse.tools.webtier.javawebapp.ReusableClassLoader;
import oracle.eclipse.tools.webtier.javawebapp.WebTierJarClassLoader;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;

final class WebAppClassLoaderManager {
    private final ClassLoaderReference _currentReference;
    private final UpdateJob _updateJob;
    private static final boolean DEBUG_CLASSLOADER = Boolean.valueOf(Platform.getDebugOption((String)"oracle.eclipse.tools.webtier.javawebapp/debug/classloader"));
    private static final String KEY_CLASSLOADER_UPDATE_TIMEOUT = "oracle.eclipse.tools.webtier.javawebapp.classloader.update.timeout";
    private static final int DEFAULT_TIMEOUT = 60000;
    private static final int MINIMUM_TIMEOUT = 500;
    public static final int CLASSLOADER_UPDATE_TIMEOUT;

    static {
        String val = System.getProperty(KEY_CLASSLOADER_UPDATE_TIMEOUT, String.valueOf(60000));
        int intVal = 60000;
        try {
            Integer integerVal = Integer.valueOf(val);
            intVal = integerVal;
        }
        catch (NumberFormatException numberFormatException) {}
        if (DEBUG_CLASSLOADER) {
            System.out.println("> WebAppClassLoaderTimeOut: " + String.valueOf(intVal) + "ms <");
        }
        CLASSLOADER_UPDATE_TIMEOUT = intVal;
    }

    public WebAppClassLoaderManager(IProject project) {
        JarClassLoader cl = new JarClassLoader(Collections.EMPTY_LIST);
        AtomicInteger versionStampCounter = new AtomicInteger(0);
        this._currentReference = new ClassLoaderReference(new ReusableClassLoader(project, (ClassLoader)cl, Integer.valueOf(versionStampCounter.incrementAndGet())));
        this._updateJob = new UpdateJob(project, this._currentReference, versionStampCounter);
    }

    public void dispose() {
        this._currentReference.dispose();
        this._updateJob.cancel();
        this._updateJob.dispose();
    }

    public IAppClassLoaderProvider.IClassLoader get() throws CoreException {
        return this._currentReference.get();
    }

    public IAppClassLoaderProvider.IUpdateEvent invalidate() {
        return this._updateJob.run();
    }

    private static class ClassLoaderReference {
        private ReusableClassLoader _loader;

        public ClassLoaderReference(ReusableClassLoader loader) {
            this._loader = loader;
        }

        public final synchronized ReusableClassLoader get() {
            if (this._loader != null) {
                this._loader.acquire();
            }
            return this._loader;
        }

        public final synchronized void set(ReusableClassLoader loader) {
            this._loader = loader;
        }

        public void dispose() {
            if (this._loader != null) {
                this._loader.dispose();
                this._loader = null;
            }
        }
    }

    private static class UpdateEvent
    implements IAppClassLoaderProvider.IUpdateEvent {
        private final Object _waitObject = new Object();
        private final IProject _project;
        private final Integer _timestamp;
        private volatile boolean _isSignalled;

        public UpdateEvent(IProject project, Integer timestamp) {
            this._project = project;
            this._timestamp = timestamp;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean waitForSignal(int timeoutMs) {
            ISchedulingRule rule;
            Job currentJob = Job.getJobManager().currentJob();
            if (currentJob != null && (rule = currentJob.getRule()) != null && rule.isConflicting((ISchedulingRule)this._project)) {
                throw new IllegalStateException("Cannot block on event while holding a rule that conflicts with the update job");
            }
            if (timeoutMs < 500) {
                throw new IllegalArgumentException("timeout must be at least " + String.valueOf(500) + " milliseconds");
            }
            if (this._isSignalled) {
                return true;
            }
            int timeSlice = 500;
            int maxTries = (int)Math.ceil(timeoutMs / 500);
            int numTries = 0;
            while (!this._isSignalled && numTries < maxTries) {
                Object object = this._waitObject;
                synchronized (object) {
                    try {
                        ++numTries;
                        this._waitObject.wait(timeSlice);
                    }
                    catch (InterruptedException interruptedException) {
                    }
                }
            }
            return this._isSignalled;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void signal() {
            Object object = this._waitObject;
            synchronized (object) {
                this._isSignalled = true;
                this._waitObject.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final boolean isSatisfied(Integer timeStamp) {
            Object object = this._waitObject;
            synchronized (object) {
                return timeStamp.compareTo(this._timestamp) >= 0;
            }
        }

        public boolean isSignalled() {
            return this._isSignalled;
        }
    }

    private static class UpdateEventManager {
        private final CopyOnWriteArrayList<UpdateEvent> _waitingEvents = new CopyOnWriteArrayList();

        private UpdateEventManager() {
        }

        public synchronized void addEvent(UpdateEvent updateEvent) {
            this._waitingEvents.add(updateEvent);
        }

        public synchronized void signalUpdate(Integer timeStamp) {
            ArrayList<UpdateEvent> satisfied = new ArrayList<UpdateEvent>();
            for (UpdateEvent event : this._waitingEvents) {
                if (!event.isSatisfied(timeStamp)) continue;
                satisfied.add(event);
            }
            for (UpdateEvent satisfiedEvent : satisfied) {
                this._waitingEvents.remove(satisfiedEvent);
                satisfiedEvent.signal();
            }
        }
    }

    private static class UpdateJob
    extends WorkspaceJob {
        private final ClassLoaderReference _updateReference;
        private final IJavaProject _jproj;
        private final IProject _project;
        private final AtomicInteger _nextVersionStamp;
        private volatile Integer _currentStamp;
        private final UpdateEventManager _manager = new UpdateEventManager();

        public UpdateJob(IProject project, ClassLoaderReference updateReference, AtomicInteger runningVersionCounter) {
            super("Updating classloader");
            this._updateReference = updateReference;
            this._jproj = JavaCore.create((IProject)project);
            this._nextVersionStamp = runningVersionCounter;
            this._currentStamp = this._nextVersionStamp.intValue();
            this._project = project;
            this.setRule((ISchedulingRule)project.getWorkspace().getRoot());
        }

        public IStatus runInWorkspace(IProgressMonitor monitor) throws CoreException {
            this._currentStamp = this._nextVersionStamp.incrementAndGet();
            if (!this._project.isAccessible()) {
                this._manager.signalUpdate(this._currentStamp);
                return Status.OK_STATUS;
            }
            ReusableClassLoader newLoader = this.createAppClassLoader(this._currentStamp);
            try (ReusableClassLoader oldLoader = this._updateReference.get();){
                this._updateReference.set(newLoader);
                if (oldLoader != null) {
                    oldLoader.markStale();
                }
            }
            this._manager.signalUpdate(this._currentStamp);
            if (DEBUG_CLASSLOADER) {
                System.out.println(">>>>> Classloader updated for " + this._jproj.getProject().getName());
            }
            return Status.OK_STATUS;
        }

        private ReusableClassLoader createAppClassLoader(Integer timestamp) {
            ClassLoader cl = null;
            if ("true".equals(System.getProperty("useWebtierClassLoader"))) {
                if (DEBUG_CLASSLOADER) {
                    System.out.println(">>>> Creating new classloader for: " + this._project.getName());
                }
                cl = new WebTierJarClassLoader(this._jproj, false);
            } else {
                if (DEBUG_CLASSLOADER) {
                    System.out.println(">>>> Creating old classloader for: " + this._project.getName());
                }
                List<JarSafeJarClassLoader.ClassPathEntry> jarFiles = this.getProjectClassPathUrls(false);
                cl = new JarSafeJarClassLoader(jarFiles);
            }
            return new ReusableClassLoader(this._project, cl, timestamp);
        }

        private List<JarSafeJarClassLoader.ClassPathEntry> getProjectClassPathUrls(boolean filterOutExternals) {
            ArrayList<JarSafeJarClassLoader.ClassPathEntry> result = new ArrayList<JarSafeJarClassLoader.ClassPathEntry>();
            if (this._jproj != null && this._jproj.exists()) {
                try {
                    IPackageFragmentRoot[] entries;
                    IPackageFragmentRoot[] iPackageFragmentRootArray = entries = this._jproj.getAllPackageFragmentRoots();
                    int n = entries.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IPackageFragmentRoot entry = iPackageFragmentRootArray[n2];
                        IPath path = null;
                        IResource res = JarSafeJarClassLoader.ClassPathEntry.NOT_A_WORKSPACE_RESOURCE;
                        if (entry.isExternal()) {
                            if (!filterOutExternals) {
                                path = entry.getPath();
                                try {
                                    URL url = path.toFile().getAbsoluteFile().toURI().toURL();
                                    res = WorkspaceUtil.convertToResource((IProject)this._project, (URL)url);
                                    if (res == null) {
                                        res = JarSafeJarClassLoader.ClassPathEntry.NOT_A_WORKSPACE_RESOURCE;
                                    }
                                }
                                catch (MalformedURLException malformedURLException) {
                                    res = null;
                                }
                            }
                        } else if (entry.isArchive()) {
                            path = entry.getResource().getRawLocation();
                            res = entry.getResource();
                        } else {
                            IResource resource = entry.getCorrespondingResource();
                            res = entry.getResource();
                            if (entry.getKind() == 1) {
                                if (entry.getResource().getProject().equals((Object)this._jproj.getProject())) {
                                    IClasspathEntry cpEntry = JavaCore.getResolvedClasspathEntry((IClasspathEntry)entry.getRawClasspathEntry());
                                    path = cpEntry.getOutputLocation();
                                    if (path == null) {
                                        path = this._jproj.getOutputLocation();
                                        path = this._jproj.getProject().getLocation().append(path.removeFirstSegments(1));
                                    } else {
                                        path = this._jproj.getProject().getWorkspace().getRoot().getLocation().append(path);
                                    }
                                } else {
                                    path = entry.getJavaProject().getOutputLocation();
                                    path = entry.getJavaProject().getProject().getLocation().append(path.removeFirstSegments(1));
                                }
                            } else {
                                path = resource.getLocation();
                            }
                        }
                        if (path != null) {
                            result.add(new JarSafeJarClassLoader.ClassPathEntry(path.toFile(), res));
                        }
                        ++n2;
                    }
                }
                catch (JavaModelException e) {
                    LogMgr.getUnhandledExceptionLogger().error("getAllTypes failed:", (Exception)((Object)e));
                }
            }
            return result;
        }

        public IAppClassLoaderProvider.IUpdateEvent run() {
            Integer currentStamp = this._currentStamp;
            UpdateEvent updateEvent = new UpdateEvent(this._project, currentStamp + 1);
            this._manager.addEvent(updateEvent);
            this.schedule();
            return updateEvent;
        }

        public void dispose() {
            this._updateReference.dispose();
        }
    }
}

