/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.webtier.javawebapp;

import java.beans.Introspector;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import oracle.eclipse.tools.application.common.services.appservices.IAppClassLoaderProvider;
import oracle.eclipse.tools.application.common.services.appservices.IAppLocalizer;
import oracle.eclipse.tools.application.common.services.appservices.IBundleResource;
import oracle.eclipse.tools.application.common.services.appservices.IDatatypeProvider;
import oracle.eclipse.tools.application.common.services.appservices.IWebRootResolver;
import oracle.eclipse.tools.application.common.services.javatypes.FindDelta;
import oracle.eclipse.tools.application.common.services.javatypes.JDTDataTypeIntrospector;
import oracle.eclipse.tools.application.common.services.javatypes.JavaDeltaVisitor;
import oracle.eclipse.tools.application.common.services.techextservices.IDataTypeIntrospector;
import oracle.eclipse.tools.application.common.services.variables.DataType;
import oracle.eclipse.tools.application.common.services.variables.VariablesController;
import oracle.eclipse.tools.application.common.services.webapp.javasrc.ParentAndResource;
import oracle.eclipse.tools.common.services.dependency.model.internal.ITechnologyDiscoveryStore;
import oracle.eclipse.tools.common.services.project.Project;
import oracle.eclipse.tools.common.services.project.app.services.IAppService;
import oracle.eclipse.tools.common.services.project.technology.AbstractTechnologyExtension;
import oracle.eclipse.tools.common.services.project.technology.ITechnologyDescriptor;
import oracle.eclipse.tools.common.services.project.technology.ITechnologyExtensionIdentifier;
import oracle.eclipse.tools.common.util.logging.LoggingService;
import oracle.eclipse.tools.webtier.javawebapp.Activator;
import oracle.eclipse.tools.webtier.javawebapp.JavaWebAppRootResolver;
import oracle.eclipse.tools.webtier.javawebapp.WebAppClassLoaderManager;
import oracle.eclipse.tools.webtier.javawebapp.app.JavaWebAppLocalizerService;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jdt.core.ElementChangedEvent;
import org.eclipse.jdt.core.IElementChangedListener;
import org.eclipse.jdt.core.IJavaElementDelta;
import org.eclipse.jdt.core.JavaCore;

public class JavaWebAppTechnologyExtension
extends AbstractTechnologyExtension
implements IAppClassLoaderProvider,
IDatatypeProvider,
IAppLocalizer,
ITechnologyDiscoveryStore {
    public static final String ID = "javawebapp";
    private static final boolean DEBUG_CLASSLOADER = Boolean.valueOf(Platform.getDebugOption((String)"oracle.eclipse.tools.webtier.javawebapp/debug/classloader"));
    private static final boolean DEBUG_CLASSLOADER_CALL = Boolean.valueOf(Platform.getDebugOption((String)"oracle.eclipse.tools.webtier.javawebapp/debug/classloader/fetch"));
    private final IDataTypeIntrospector _introspector;
    private final IAppLocalizer _appLocalizer;
    private final WebAppClassLoaderManager _clManager;
    private IElementChangedListener _elemChangedListener;
    private IResourceChangeListener _resourceChangeListener;
    private IContainer webRoot;
    private boolean webRootInitalized = false;

    public JavaWebAppTechnologyExtension(Project project, ITechnologyDescriptor techDescriptor) {
        super(project, techDescriptor);
        this._introspector = new JDTDataTypeIntrospector(project.getEclipseProject());
        this._clManager = new WebAppClassLoaderManager(project.getEclipseProject());
        this._appLocalizer = new JavaWebAppLocalizerService(project);
        boolean appXrayDisabled = oracle.eclipse.tools.common.services.Activator.getDefault().getPreferences().getProjectPreferences(project.getEclipseProject()).isDisabled();
        this.addClassPathChangeListeners(appXrayDisabled);
    }

    public IAppClassLoaderProvider.IClassLoader getAppClassLoader() {
        try {
            IAppClassLoaderProvider.IClassLoader loader;
            if (DEBUG_CLASSLOADER_CALL) {
                System.out.println("> Call to getClassLoader() in " + this.getProject().getEclipseProject().getName());
            }
            if ((loader = this._clManager.get()) == null) {
                throw new AssertionError((Object)"Invariant: Class loader must never be null");
            }
            return loader;
        }
        catch (CoreException e) {
            LoggingService.logException((Plugin)Activator.getDefault(), (CoreException)e);
            return null;
        }
    }

    public IAppClassLoaderProvider.IUpdateEvent reset() {
        if (DEBUG_CLASSLOADER) {
            System.out.println(">>> Invalidating classloader in " + this.getProject().getEclipseProject().getName());
        }
        IAppClassLoaderProvider.IUpdateEvent event = this._clManager.invalidate();
        Introspector.flushCaches();
        return event;
    }

    public DataType getDataType(String typeName, Set<String> importedTypeNames) {
        return this.getDataType(typeName, importedTypeNames, Collections.EMPTY_MAP);
    }

    public DataType getDataType(String typeName, Set<String> importedTypeNames, Map additionalFields) {
        return this.getIntrospector().introspect(typeName, importedTypeNames, additionalFields);
    }

    public final IDataTypeIntrospector getIntrospector() {
        return this._introspector;
    }

    public boolean hasClass(String fullyQualifiedClassName) {
        try (IAppClassLoaderProvider.IClassLoader classLoader = null;){
            classLoader = this.getAppClassLoader();
            classLoader.loadClass(fullyQualifiedClassName);
            return true;
        }
    }

    public void close() {
        super.close();
        if (this._appLocalizer != null) {
            this._appLocalizer.dispose();
        }
        if (this._resourceChangeListener != null) {
            ResourcesPlugin.getWorkspace().removeResourceChangeListener(this._resourceChangeListener);
            this._resourceChangeListener = null;
        }
        if (this._elemChangedListener != null) {
            JavaCore.removeElementChangedListener((IElementChangedListener)this._elemChangedListener);
            this._elemChangedListener = null;
        }
        if (this._introspector instanceof JDTDataTypeIntrospector) {
            ((JDTDataTypeIntrospector)this._introspector).dispose();
        }
        if (this._clManager != null) {
            this._clManager.dispose();
        }
        Introspector.flushCaches();
    }

    public void addListener(IAppLocalizer.IAppLocalizationChangeListener listener) {
        this._appLocalizer.addListener(listener);
    }

    public void dispose() {
        throw new UnsupportedOperationException("Clients should never dispose the java web app localizer.  The localizer will be disposed on technology extension disposal");
    }

    public Set<String> getAllBaseNames() {
        return this._appLocalizer.getAllBaseNames();
    }

    public Set<String> getAllBaseNames(boolean includeJarFiles) {
        return this._appLocalizer.getAllBaseNames(includeJarFiles);
    }

    public Set<ParentAndResource> getAllBaseNamesWithParents(boolean includeJarFiles) {
        return this._appLocalizer.getAllBaseNamesWithParents(includeJarFiles);
    }

    public Collection<Locale> getAvailableLocales(String baseName) {
        return this._appLocalizer.getAvailableLocales(baseName);
    }

    public Collection<IFile> getBundleFiles(String baseName) {
        return this._appLocalizer.getBundleFiles(baseName);
    }

    public String getDefaultBaseName() {
        return this._appLocalizer.getDefaultBaseName();
    }

    public ITechnologyExtensionIdentifier getOwner() {
        return this._appLocalizer.getOwner();
    }

    public void removeListener(IAppLocalizer.IAppLocalizationChangeListener listener) {
        this._appLocalizer.removeListener(listener);
    }

    public IBundleResource resolveBundle(String baseName, Locale locale) {
        return this._appLocalizer.resolveBundle(baseName, locale);
    }

    public Locale resolveLocale(List<Locale> preferredLocale) {
        return this._appLocalizer.resolveLocale(preferredLocale);
    }

    private void addClassPathChangeListeners(boolean appXrayDisabled) {
        this.addResourceChangeListener(appXrayDisabled);
        this.addElementChangedListener();
    }

    private void addResourceChangeListener(boolean appXrayDisabled) {
        if (appXrayDisabled) {
            this._resourceChangeListener = new IResourceChangeListener(){
                private boolean doReset = false;
                private boolean skipDelta = false;

                public void resourceChanged(IResourceChangeEvent event) {
                    try {
                        this.doReset = false;
                        this.skipDelta = false;
                        if (event.getDelta() != null) {
                            event.getDelta().accept(this.getVisitor());
                        }
                        if (this.doReset) {
                            if (DEBUG_CLASSLOADER) {
                                System.out.println(">> TechExt ResourceChange Event <<");
                            }
                            JavaWebAppTechnologyExtension.this.reset();
                        }
                    }
                    catch (CoreException e) {
                        LoggingService.logException((Plugin)Activator.getDefault(), (Throwable)e, (String)"Error during resourceChangeEvent");
                    }
                }

                private IResourceDeltaVisitor getVisitor() {
                    return new IResourceDeltaVisitor(){
                        private String CLASS_FILE_EXT = "class";
                        private String PROPERTY_FILE_EXT = "property";

                        public boolean visit(IResourceDelta delta) throws CoreException {
                            IResource resource = delta.getResource();
                            if (resource.getType() == 4 && (delta.getFlags() & 0x4000) != 0) {
                                IProject proj = (IProject)resource;
                                if (proj.isAccessible() && proj == JavaWebAppTechnologyExtension.this.getProject().getEclipseProject()) {
                                    if (DEBUG_CLASSLOADER) {
                                        System.out.println("+++ " + JavaWebAppTechnologyExtension.this.getProject().getEclipseProject().getName() + " has opened");
                                    }
                                    doReset = true;
                                    return true;
                                }
                            } else if (resource instanceof IFile) {
                                IProject project = resource.getProject();
                                String fileType = null;
                                if (project != JavaWebAppTechnologyExtension.this.getProject().getEclipseProject().getProject()) {
                                    skipDelta = true;
                                    return false;
                                }
                                if (delta.getFlags() == 131072) {
                                    return false;
                                }
                                IFile file = (IFile)resource;
                                if (this.isClassFile(file)) {
                                    fileType = this.CLASS_FILE_EXT;
                                } else if (this.isPropertyFile(file)) {
                                    fileType = this.PROPERTY_FILE_EXT;
                                } else if (this.isJSPFile(file)) {
                                    return false;
                                }
                                if (fileType == null) {
                                    return false;
                                }
                                switch (delta.getKind()) {
                                    case 1: 
                                    case 2: 
                                    case 4: {
                                        if (DEBUG_CLASSLOADER) {
                                            System.out.println(String.valueOf(fileType) + " file changed in " + JavaWebAppTechnologyExtension.this.getProject().getEclipseProject().getName());
                                        }
                                        doReset = true;
                                        return true;
                                    }
                                }
                                return false;
                            }
                            if (!doReset && !skipDelta) {
                                IResourceDelta[] iResourceDeltaArray = delta.getAffectedChildren();
                                int n = iResourceDeltaArray.length;
                                int n2 = 0;
                                while (n2 < n) {
                                    IResourceDelta subDelta = iResourceDeltaArray[n2];
                                    subDelta.accept((IResourceDeltaVisitor)this);
                                    ++n2;
                                }
                            }
                            return true;
                        }

                        private boolean isClassFile(IFile file) {
                            return file.getFileExtension() != null ? file.getFileExtension().equals(this.CLASS_FILE_EXT) : false;
                        }

                        private boolean isPropertyFile(IFile file) {
                            return file.getFileExtension() != null ? file.getFileExtension().equals(this.PROPERTY_FILE_EXT) : false;
                        }

                        private boolean isJSPFile(IFile file) {
                            return file.getName().startsWith(this.getJSPPrefix());
                        }

                        private String getJSPPrefix() {
                            StringBuffer buf = new StringBuffer("__2F_");
                            buf.append(JavaWebAppTechnologyExtension.this.getProject().getEclipseProject().getName()).append("_");
                            return buf.toString();
                        }
                    };
                }
            };
            ResourcesPlugin.getWorkspace().addResourceChangeListener(this._resourceChangeListener, 15);
        }
    }

    private void addElementChangedListener() {
        this._elemChangedListener = new IElementChangedListener(){

            public void elementChanged(final ElementChangedEvent event) {
                IJavaElementDelta delta = event.getDelta();
                FindDelta findDelta = new FindDelta(){

                    protected boolean matches(IJavaElementDelta delta) {
                        IProject resProject;
                        if (event.getType() == 1 && delta.getKind() == 4 && (delta.getFlags() & 0x200000) != 0 && delta.getResourceDeltas() != null && delta.getResourceDeltas().length > 0 && (resProject = this.getCurrentProject(delta.getResourceDeltas()[0])) == JavaWebAppTechnologyExtension.this.getProject().getEclipseProject()) {
                            if (DEBUG_CLASSLOADER) {
                                System.out.println("classpath changed in " + JavaWebAppTechnologyExtension.this.getProject().getEclipseProject().getName());
                            }
                            return true;
                        }
                        return false;
                    }

                    private IProject getCurrentProject(IResourceDelta res) {
                        return res.getResource().getProject();
                    }
                };
                findDelta.accept(delta, JavaDeltaVisitor.VisitOrder.PREORDER);
                if (findDelta.getDeltas().size() > 0) {
                    JavaWebAppTechnologyExtension.this.reset();
                }
            }
        };
        JavaCore.addElementChangedListener((IElementChangedListener)this._elemChangedListener);
    }

    public <T extends IAppService> T getAppService(Class<T> serviceType) {
        if (serviceType == ITechnologyDiscoveryStore.class) {
            return (T)((Object)this);
        }
        if (serviceType == IWebRootResolver.class) {
            IProject eclipseProject = this.getProject().getEclipseProject();
            if (!this.webRootInitalized && !JavaWebAppRootResolver.hasModuleNature(eclipseProject)) {
                IFolder findWebInfFolder = JavaWebAppRootResolver.findWebInfFolder(eclipseProject);
                if (findWebInfFolder != null && findWebInfFolder.isAccessible()) {
                    this.webRoot = findWebInfFolder.getParent();
                }
                this.webRootInitalized = true;
            }
            return (T)new JavaWebAppRootResolver(eclipseProject, this.webRoot);
        }
        return (T)super.getAppService(serviceType);
    }

    public IStatus load(int saveNumber) {
        return VariablesController.getInstance().load(this.getProject().getEclipseProject(), saveNumber);
    }

    public IStatus store(int saveNumber, int prevSaveNumber) {
        return VariablesController.getInstance().store(this.getProject().getEclipseProject(), saveNumber, prevSaveNumber);
    }
}

