/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.webtier.javawebapp;

import oracle.eclipse.tools.application.common.services.appservices.IWebRootResolver;
import oracle.eclipse.tools.webtier.javawebapp.Activator;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualFolder;

public class JavaWebAppRootResolver
implements IWebRootResolver {
    private static final String MODULE_NATURE_ID = "org.eclipse.wst.common.modulecore.ModuleCoreNature";
    private final IProject project;
    private final IContainer webRoot;

    public JavaWebAppRootResolver(IProject project, IContainer webRoot) {
        this.project = project;
        this.webRoot = webRoot;
    }

    public IResource getResourceForPath(String webRootRelativePath) {
        IVirtualComponent component;
        if (JavaWebAppRootResolver.hasModuleNature(this.project) && (component = ComponentCore.createComponent((IProject)this.project)) != null) {
            IVirtualFolder rootFolder = component.getRootFolder();
            IContainer underlyingFolder = rootFolder.getUnderlyingFolder();
            return this.tryToResolveResource(webRootRelativePath, underlyingFolder);
        }
        if (this.webRoot != null) {
            return this.tryToResolveResource(webRootRelativePath, this.webRoot);
        }
        return null;
    }

    private IResource tryToResolveResource(String webRootRelativePath, IContainer underlyingFolder) {
        IResource findMember = underlyingFolder.findMember(webRootRelativePath);
        if (findMember != null) {
            return findMember;
        }
        return underlyingFolder.getFile((IPath)new Path(webRootRelativePath));
    }

    public static IFolder findWebInfFolder(IProject eclipseProject) {
        final IFolder[] webInf = new IFolder[1];
        try {
            eclipseProject.accept(new IResourceVisitor(){

                public boolean visit(IResource resource) throws CoreException {
                    if (resource.getType() == 2 && "WEB-INF".equals(resource.getName())) {
                        webInf[0] = (IFolder)resource;
                        return false;
                    }
                    return webInf[0] == null;
                }
            });
            return webInf[0];
        }
        catch (CoreException e) {
            Activator.log(e);
            return null;
        }
    }

    static boolean hasModuleNature(IProject project) {
        try {
            if (project != null && project.isAccessible()) {
                return project.getNature(MODULE_NATURE_ID) != null;
            }
        }
        catch (CoreException coreException) {}
        return false;
    }
}

