/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.webtier.javawebapp;

import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLStreamHandler;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Vector;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import oracle.eclipse.tools.application.common.services.util.WorkspaceUtil;
import oracle.eclipse.tools.common.util.classloader.JarClassLoader;
import oracle.eclipse.tools.common.util.classloader.MultiParentClassLoader;
import oracle.eclipse.tools.common.util.classloader.jarnocache.JarProtocolHandlerWithoutLeak;
import oracle.eclipse.tools.common.util.logging.LoggingService;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;

public class JarSafeJarClassLoader
extends ClassLoader {
    private List<ClassPathEntry> _openFiles;
    private final LinkedHashSet<ClassPathEntry> _classpathEntries;
    private List<JarCLInputStream> _openStreams = new LinkedList<JarCLInputStream>();
    private boolean _open = false;

    public JarSafeJarClassLoader(List<ClassPathEntry> jarFiles) {
        this(jarFiles, null);
    }

    public JarSafeJarClassLoader(List<ClassPathEntry> files, ClassLoader parent) {
        super(parent);
        this._classpathEntries = new LinkedHashSet<ClassPathEntry>(files);
    }

    public synchronized void open() {
        if (this._open) {
            return;
        }
        this._openFiles = new ArrayList<ClassPathEntry>(this._classpathEntries.size());
        for (ClassPathEntry cpEntry : this._classpathEntries) {
            cpEntry.open();
            this._openFiles.add(cpEntry);
            this._recursiveGetManifestJars(cpEntry, this._openFiles, true);
        }
        this.releaseWorkspaceJarFiles();
        this._open = true;
        this._openStreams = new LinkedList<JarCLInputStream>();
    }

    void releaseWorkspaceJarFiles() {
        if (this._openFiles == null) {
            return;
        }
        for (ClassPathEntry entry : this._openFiles) {
            if (!entry.isWorkspaceJarFile()) continue;
            entry.close();
        }
    }

    public synchronized void close() {
        if (!this._open) {
            return;
        }
        this._open = false;
        for (JarCLInputStream st : this._openStreams) {
            try {
                st.close();
            }
            catch (IOException ioe) {
                LoggingService.logException((String)"oracle.eclipse.tools.webtier.javawebapp", (Throwable)ioe, (String)"Failed to close stream");
            }
        }
        this._openStreams = null;
        for (ClassPathEntry cpEntry : this._openFiles) {
            cpEntry.close();
        }
        this._openFiles = null;
    }

    public Collection<ClassPathEntry> getReachableJarFiles() {
        return this._classpathEntries;
    }

    public Collection<ClassPathEntry> getFiles() {
        return Collections.unmodifiableCollection(this._classpathEntries);
    }

    private synchronized void closeInputStream(JarCLInputStream in) {
        if (this._open) {
            this._openStreams.remove(in);
        }
    }

    @Override
    protected synchronized Class<?> findClass(String name) throws ClassNotFoundException {
        Package pkg;
        byte[] b;
        if (!this._open) {
            this.open();
        }
        if ((b = this.loadClassData(name)) == null) {
            throw new ClassNotFoundException("Could not find class " + name);
        }
        Class<?> clazz = this.defineClass(name, b, 0, b.length);
        String pkgName = this.getPackageName(name);
        if (pkgName != null && (pkg = this.getPackage(pkgName)) == null) {
            this.definePackage(pkgName, null, null, null, null, null, null, null);
        }
        return clazz;
    }

    private String getPackageName(String fullyQualifiedName) {
        int index = fullyQualifiedName.lastIndexOf(46);
        if (index != -1) {
            return fullyQualifiedName.substring(0, index);
        }
        return null;
    }

    /*
     * Loose catch block
     */
    private byte[] loadClassData(String name) {
        int len;
        name = name.replace('.', '/');
        InputStream input = this.getResourceAsStreamInternal(name = String.valueOf(name) + ".class");
        if (input == null) {
            return null;
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        byte[] buf = new byte[1024];
        while ((len = input.read(buf)) > 0) {
            baos.write(buf, 0, len);
        }
        baos.close();
        byte[] byArray = baos.toByteArray();
        try {
            input.close();
        }
        catch (IOException iOException) {}
        return byArray;
        catch (IOException iOException) {
            try {}
            catch (Throwable throwable) {
                try {
                    input.close();
                }
                catch (IOException iOException2) {}
                throw throwable;
            }
            try {
                input.close();
            }
            catch (IOException iOException3) {}
            return null;
        }
    }

    private synchronized InputStream getResourceAsStreamInternal(String name) {
        InputStream input = null;
        if (this.getParent() != null) {
            input = this.getParent().getResourceAsStream(name);
        }
        if (input != null) {
            return input;
        }
        if (!this._open) {
            this.open();
        }
        for (ClassPathEntry file : this._openFiles) {
            InputStream inStream = file.getResourceAsStream(name);
            if (inStream == null) continue;
            return inStream;
        }
        return null;
    }

    @Override
    public synchronized InputStream getResourceAsStream(String name) {
        InputStream is = this.getResourceAsStreamInternal(name);
        if (is != null) {
            JarCLInputStream result = new JarCLInputStream(is);
            if (!this._open) {
                this.open();
            }
            this._openStreams.add(result);
            return result;
        }
        return null;
    }

    @Override
    protected synchronized URL findResource(String name) {
        URL parentURL = null;
        if (this.getParent() != null) {
            parentURL = this.getParent().getResource(name);
        }
        if (parentURL != null) {
            return parentURL;
        }
        if (!this._open) {
            this.open();
        }
        for (ClassPathEntry f : this._openFiles) {
            URL url = f.findResource(name);
            if (url == null) continue;
            return url;
        }
        return null;
    }

    @Override
    protected synchronized Enumeration<URL> findResources(String name) throws IOException {
        if (!this._open) {
            this.open();
        }
        Vector<URL> urls = new Vector<URL>();
        for (ClassPathEntry file : this._openFiles) {
            URL url = file.findResource(name);
            if (url == null) continue;
            urls.add(url);
        }
        return urls.elements();
    }

    private void _recursiveGetManifestJars(ClassPathEntry jarFile, List<ClassPathEntry> manifestJars, boolean openJars) {
        if (!jarFile.isJarFile()) {
            return;
        }
        JarFile jar = null;
        try {
            String[] rgPaths;
            jar = jarFile.getJarFile();
            Manifest mf = jar.getManifest();
            if (mf == null) {
                return;
            }
            String classpath = mf.getMainAttributes().getValue(Attributes.Name.CLASS_PATH);
            if (classpath == null) {
                return;
            }
            File parent = jarFile.getFile().getParentFile();
            String[] stringArray = rgPaths = classpath.split(" ");
            int n = rgPaths.length;
            int n2 = 0;
            while (n2 < n) {
                ClassPathEntry cpEntry;
                File file;
                String path = stringArray[n2];
                if (path.length() != 0 && (file = new File(parent, path)).exists() && !manifestJars.contains(cpEntry = new ClassPathEntry(file))) {
                    if (openJars) {
                        cpEntry.open();
                    }
                    manifestJars.add(cpEntry);
                    this._recursiveGetManifestJars(cpEntry, manifestJars);
                }
                ++n2;
            }
        }
        catch (IOException iOException) {}
    }

    private void _recursiveGetManifestJars(ClassPathEntry jarFile, List<ClassPathEntry> manifestJars) {
        this._recursiveGetManifestJars(jarFile, manifestJars, false);
    }

    public static final void close(ClassLoader loader) {
        if (loader != null) {
            if (loader instanceof JarClassLoader) {
                ((JarClassLoader)loader).close();
                if (loader.getParent() != null && loader.getParent() != loader) {
                    JarSafeJarClassLoader.close(loader.getParent());
                }
            } else if (loader instanceof MultiParentClassLoader) {
                ClassLoader[] parents = ((MultiParentClassLoader)loader).getAllParents();
                if (parents != null) {
                    ClassLoader[] classLoaderArray = parents;
                    int n = parents.length;
                    int n2 = 0;
                    while (n2 < n) {
                        ClassLoader parent = classLoaderArray[n2];
                        JarSafeJarClassLoader.close(parent);
                        ++n2;
                    }
                }
            } else if (loader.getParent() != null && loader.getParent() != loader) {
                JarSafeJarClassLoader.close(loader.getParent());
            }
        }
    }

    static class ClassPathEntry {
        public static final IResource NOT_A_WORKSPACE_RESOURCE = ResourcesPlugin.getWorkspace().getRoot();
        private JarFile _jarfile;
        private final File _file;
        private boolean _open = false;
        private final IResource _resource;

        public ClassPathEntry(File file, IResource resource) {
            this._file = file;
            this._resource = resource;
        }

        public ClassPathEntry(File file) {
            this(file, null);
        }

        private boolean isWorkspaceJarFile() {
            return this.isWorkspaceFile(this._file) && !this._file.isDirectory();
        }

        private boolean isWorkspaceFile(File file) {
            if (this._resource == NOT_A_WORKSPACE_RESOURCE) {
                return false;
            }
            if (this._resource != null && this._resource.getType() == 1) {
                return true;
            }
            IFile workspaceFile = WorkspaceUtil.getWorkspaceFile((File)file);
            return workspaceFile != null && workspaceFile.exists();
        }

        private JarFile getJarFile() {
            if (!this._open) {
                this.open();
            }
            return this._jarfile;
        }

        private File getFile() {
            return this._file;
        }

        private void open() {
            if (this._open) {
                return;
            }
            this._open = true;
            if (this.isJarFile(this._file)) {
                try {
                    this._jarfile = new JarFile(this._file);
                }
                catch (IOException ioe) {
                    LoggingService.logException((String)"oracle.eclipse.tools.webtier.javawebapp", (Throwable)ioe, (String)("Unable to create JarFile for file: " + this._file));
                    this._open = false;
                }
            }
        }

        private void close() {
            if (!this._open) {
                return;
            }
            this._open = false;
            try {
                if (this._jarfile != null) {
                    this._jarfile.close();
                    this._jarfile = null;
                }
            }
            catch (IOException ioe) {
                LoggingService.logException((String)"oracle.eclipse.tools.webtier.javawebapp", (Throwable)ioe, (String)("Failed to close jar: " + this._jarfile));
            }
        }

        private boolean isJarFile() {
            if (!this._open) {
                this.open();
            }
            return this._jarfile != null;
        }

        public boolean equals(Object o) {
            File f = ((ClassPathEntry)o)._file;
            if (f == null && this._file == null) {
                return true;
            }
            if (f != null && this._file != null) {
                return this._file.equals(f);
            }
            return false;
        }

        public int hashCode() {
            if (this._file == null) {
                return 0;
            }
            return this._file.hashCode();
        }

        private boolean isJarFile(File file) {
            try {
                if (file != null && !file.isDirectory() && (file.getName().endsWith("jar") || file.getName().endsWith("zip"))) {
                    return true;
                }
            }
            catch (Exception exception) {}
            return false;
        }

        private URL findResource(String name) {
            if (!this._open) {
                this.open();
            }
            try {
                File file;
                if (this._jarfile != null) {
                    ZipEntry entry = this._jarfile.getEntry(name);
                    if (entry != null) {
                        String fileUrl = this._file.toURI().toURL().toExternalForm();
                        return new URL("jar", "", -1, String.valueOf(fileUrl) + "!/" + name, (URLStreamHandler)new JarProtocolHandlerWithoutLeak());
                    }
                } else if (this._file != null && (file = new File(this._file, name)).exists()) {
                    return file.toURI().toURL();
                }
            }
            catch (MalformedURLException malformedURLException) {}
            return null;
        }

        private synchronized InputStream getResourceAsStream(String name) {
            if (!this._open) {
                this.open();
            }
            if (this._jarfile != null) {
                try {
                    ZipEntry entry = this._jarfile.getEntry(name);
                    if (entry != null) {
                        InputStream zipInput = this._jarfile.getInputStream(entry);
                        return zipInput;
                    }
                }
                catch (IOException ioe) {
                    LoggingService.logException((String)"oracle.eclipse.tools.webtier.javawebapp", (Throwable)ioe, (String)("Unable to get entry from jar: " + this._jarfile));
                }
            } else if (this._file != null) {
                try {
                    File file = new File(this._file, name);
                    if (file.exists()) {
                        return new BufferedInputStream(new FileInputStream(file));
                    }
                }
                catch (FileNotFoundException fileNotFoundException) {}
            }
            return null;
        }
    }

    private class JarCLInputStream
    extends InputStream {
        private boolean _closed = false;
        private final InputStream _input;

        public JarCLInputStream(InputStream origInput) {
            this._input = origInput;
        }

        @Override
        public void close() throws IOException {
            if (this._closed) {
                return;
            }
            try {
                super.close();
                if (this._input != null) {
                    this._input.close();
                }
                this._closed = true;
            }
            finally {
                JarSafeJarClassLoader.this.closeInputStream(this);
            }
        }

        @Override
        public int read() throws IOException {
            return this._input.read();
        }

        @Override
        public int available() throws IOException {
            return this._input.available();
        }

        @Override
        public synchronized void mark(int readlimit) {
            this._input.mark(readlimit);
        }

        @Override
        public boolean markSupported() {
            return this._input.markSupported();
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            return this._input.read(b, off, len);
        }

        @Override
        public int read(byte[] b) throws IOException {
            return this._input.read(b);
        }

        @Override
        public synchronized void reset() throws IOException {
            this._input.reset();
        }

        @Override
        public long skip(long n) throws IOException {
            return this._input.skip(n);
        }
    }
}

