/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.shared_ui.quick_outline;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.progress.UIJob;
import org.python.pydev.shared_core.structure.DataAndImageTreeNode;
import org.python.pydev.shared_ui.SharedUiPlugin;
import org.python.pydev.shared_ui.dialogs.DialogMemento;
import org.python.pydev.shared_ui.dialogs.TreeSelectionDialog;
import org.python.pydev.shared_ui.quick_outline.IOutlineEntry;

public abstract class BaseQuickOutlineSelectionDialog
extends TreeSelectionDialog {
    protected DataAndImageTreeNode<IOutlineEntry> root;
    protected DataAndImageTreeNode<IOutlineEntry> rootWithParents;
    protected int startLineIndex = -1;
    protected DataAndImageTreeNode<IOutlineEntry> initialSelection;
    private final DialogMemento memento;
    private KeyListener ctrlOlistener;
    private boolean showParentHierarchy;
    private Label labelCtrlO;
    protected final UIJob uiJobSetRootWithParentsInput = new UIJob("Set input"){

        public IStatus runInUIThread(IProgressMonitor monitor) {
            if (!monitor.isCanceled()) {
                BaseQuickOutlineSelectionDialog.this.getTreeViewer().setInput(BaseQuickOutlineSelectionDialog.this.rootWithParents);
            } else {
                BaseQuickOutlineSelectionDialog.this.rootWithParents = null;
            }
            return Status.OK_STATUS;
        }
    };

    protected BaseQuickOutlineSelectionDialog(Shell shell, String pluginId, ILabelProvider labelProvider, ITreeContentProvider contentProvider) {
        super(shell, labelProvider, contentProvider);
        this.setShellStyle(this.getShellStyle() & 0xFFFEFFFF);
        this.memento = SharedUiPlugin.getDefault() != null ? new DialogMemento(this.getShell(), String.valueOf(pluginId) + ".actions.QuickShowOutline") : null;
        this.setMessage("Filter (press enter to go to selected element)");
        this.setTitle("Quick Outline");
        this.setAllowMultiple(false);
        this.showParentHierarchy = false;
    }

    protected void toggleShowParentHierarchy() {
        this.showParentHierarchy = !this.showParentHierarchy;
        this.updateShowParentHierarchyMessage();
        TreeViewer treeViewer = this.getTreeViewer();
        if (this.showParentHierarchy) {
            this.calculateHierarchyWithParents();
        } else {
            this.calculateHierarchy();
            treeViewer.setInput(this.root);
        }
    }

    protected abstract void calculateHierarchy();

    protected abstract void calculateHierarchyWithParents();

    protected void configureShell(final Shell shell) {
        super.configureShell(shell);
        shell.addShellListener(new ShellListener(){

            public void shellIconified(ShellEvent e) {
            }

            public void shellDeiconified(ShellEvent e) {
            }

            public void shellDeactivated(ShellEvent e) {
                shell.close();
            }

            public void shellClosed(ShellEvent e) {
            }

            public void shellActivated(ShellEvent e) {
            }
        });
    }

    public Control createDialogArea(Composite parent) {
        if (this.memento != null) {
            this.memento.readSettings();
        }
        Control ret = super.createDialogArea(parent);
        this.ctrlOlistener = new KeyListener(){

            public void keyReleased(KeyEvent e) {
            }

            public void keyPressed(KeyEvent e) {
                if ((e.keyCode == 111 || e.keyCode == 79) && e.stateMask == 262144) {
                    BaseQuickOutlineSelectionDialog.this.toggleShowParentHierarchy();
                }
            }
        };
        this.text.addKeyListener(this.ctrlOlistener);
        this.text.addKeyListener(new KeyListener(){

            public void keyReleased(KeyEvent e) {
            }

            public void keyPressed(KeyEvent e) {
                if (e.keyCode == 13 || e.keyCode == 10 || e.keyCode == 0x1000050) {
                    BaseQuickOutlineSelectionDialog.this.okPressed();
                }
            }
        });
        this.getTreeViewer().getTree().addKeyListener(this.ctrlOlistener);
        return ret;
    }

    protected Control createButtonBar(Composite parent) {
        this.labelCtrlO = new Label(parent, 0);
        this.labelCtrlO.addKeyListener(this.ctrlOlistener);
        this.updateShowParentHierarchyMessage();
        return this.labelCtrlO;
    }

    protected void updateShowParentHierarchyMessage() {
        if (this.showParentHierarchy) {
            this.labelCtrlO.setText("Press Ctrl+O to hide parent hierarchy.");
        } else {
            this.labelCtrlO.setText("Press Ctrl+O to show parent hierarchy.");
        }
    }

    public boolean close() {
        if (this.memento != null) {
            this.memento.writeSettings(this.getShell());
        }
        return super.close();
    }

    protected Point getInitialSize() {
        if (this.memento != null) {
            return this.memento.getInitialSize(super.getInitialSize(), this.getShell());
        }
        return new Point(640, 480);
    }

    protected Point getInitialLocation(Point initialSize) {
        if (this.memento != null) {
            return this.memento.getInitialLocation(initialSize, super.getInitialLocation(initialSize), this.getShell());
        }
        return new Point(250, 250);
    }

    protected int getDefaultMargins() {
        return 0;
    }

    protected int getDefaultSpacing() {
        return 0;
    }
}

