/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.shared_ui.bindings;

import java.util.ArrayList;
import org.eclipse.core.commands.ParameterizedCommand;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.bindings.Binding;
import org.eclipse.jface.bindings.TriggerSequence;
import org.eclipse.jface.bindings.keys.KeySequence;
import org.eclipse.jface.bindings.keys.KeyStroke;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.IHandlerService;
import org.eclipse.ui.keys.IBindingService;
import org.python.pydev.shared_core.log.Log;
import org.python.pydev.shared_core.structure.Tuple;

public class KeyBindingHelper {
    public static boolean matchesContentAssistKeybinding(KeyEvent event) {
        return KeyBindingHelper.matchesKeybinding(event, "org.eclipse.ui.edit.text.contentAssist.proposals");
    }

    public static KeySequence getContentAssistProposalBinding() {
        return KeyBindingHelper.getCommandKeyBinding("org.eclipse.ui.edit.text.contentAssist.proposals");
    }

    public static boolean matchesQuickAssistKeybinding(KeyEvent event) {
        return KeyBindingHelper.matchesKeybinding(event, "org.eclipse.jdt.ui.edit.text.java.correction.assist.proposals");
    }

    public static KeySequence getQuickAssistProposalBinding() {
        return KeyBindingHelper.getCommandKeyBinding("org.eclipse.jdt.ui.edit.text.java.correction.assist.proposals");
    }

    public static boolean matchesKeybinding(KeyEvent event, String commandId) {
        int keyCode = event.keyCode;
        int stateMask = event.stateMask;
        return KeyBindingHelper.matchesKeybinding(keyCode, stateMask, commandId);
    }

    public static boolean matchesKeybinding(int keyCode, int stateMask, String commandId) {
        TriggerSequence[] activeBindingsFor;
        IBindingService bindingSvc = (IBindingService)PlatformUI.getWorkbench().getAdapter(IBindingService.class);
        TriggerSequence[] triggerSequenceArray = activeBindingsFor = bindingSvc.getActiveBindingsFor(commandId);
        int n = activeBindingsFor.length;
        int n2 = 0;
        while (n2 < n) {
            KeySequence keySequence;
            TriggerSequence seq = triggerSequenceArray[n2];
            if (seq instanceof KeySequence && KeyBindingHelper.matchesKeybinding(keyCode, stateMask, keySequence = (KeySequence)seq)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static boolean matchesKeybinding(int keyCode, int stateMask, KeySequence keySequence) {
        KeyStroke[] keyStrokes;
        KeyStroke[] keyStrokeArray = keyStrokes = keySequence.getKeyStrokes();
        int n = keyStrokes.length;
        int n2 = 0;
        while (n2 < n) {
            KeyStroke keyStroke = keyStrokeArray[n2];
            if (keyStroke.getNaturalKey() == keyCode && ((keyStroke.getModifierKeys() & stateMask) != 0 || keyStroke.getModifierKeys() == stateMask)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static KeySequence getCommandKeyBinding(String commandId) {
        Binding[] bindings;
        Assert.isNotNull((Object)commandId);
        IBindingService bindingSvc = (IBindingService)PlatformUI.getWorkbench().getAdapter(IBindingService.class);
        TriggerSequence keyBinding = bindingSvc.getBestActiveBindingFor(commandId);
        if (keyBinding instanceof KeySequence) {
            return (KeySequence)keyBinding;
        }
        ArrayList<Tuple> matches = new ArrayList<Tuple>();
        Binding[] bindingArray = bindings = bindingSvc.getBindings();
        int n = bindings.length;
        int n2 = 0;
        while (n2 < n) {
            Binding binding = bindingArray[n2];
            ParameterizedCommand command = binding.getParameterizedCommand();
            if (command != null && commandId.equals(command.getId())) {
                matches.add(new Tuple((Object)binding, (Object)command));
            }
            ++n2;
        }
        for (Tuple tuple : matches) {
            if (!(((Binding)tuple.o1).getTriggerSequence() instanceof KeySequence)) continue;
            KeySequence keySequence = (KeySequence)((Binding)tuple.o1).getTriggerSequence();
            return keySequence;
        }
        return null;
    }

    public static void executeCommand(String commandId) {
        IHandlerService handlerService = (IHandlerService)PlatformUI.getWorkbench().getService(IHandlerService.class);
        try {
            handlerService.executeCommand(commandId, null);
        }
        catch (Exception e) {
            Log.log((Throwable)e);
        }
    }
}

