/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.core.internal.e44;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.apache.maven.index.fs.Lock;
import org.apache.maven.index.fs.Locker;

public class EquinoxLocker
implements Locker {
    private static final String E43_LOCATION_HELPER = "org.eclipse.core.runtime.internal.adaptor.BasicLocation";
    private static final String E44_LOCATION_HELPER = "org.eclipse.osgi.internal.location.LocationHelper";

    public Lock lock(File directory) throws IOException {
        File lockFile = new File(directory, ".lock");
        ClassLoader cl = EquinoxLocker.class.getClassLoader();
        try {
            Object locker;
            Class<?> locationHelper;
            try {
                locationHelper = cl.loadClass(E44_LOCATION_HELPER);
                Method createLockerMethod = locationHelper.getMethod("createLocker", File.class, String.class, Boolean.TYPE);
                locker = createLockerMethod.invoke(null, lockFile, null, false);
            }
            catch (ClassNotFoundException classNotFoundException) {
                locationHelper = cl.loadClass(E43_LOCATION_HELPER);
                Method createLockerMethod = locationHelper.getMethod("createLocker", File.class, String.class);
                locker = createLockerMethod.invoke(null, lockFile, null);
            }
            Method lockMethod = locker.getClass().getMethod("lock", null);
            lockMethod.invoke(locker, null);
            return new EquinoxLock(locker);
        }
        catch (InvocationTargetException e) {
            if (e.getCause() instanceof IOException) {
                throw (IOException)e.getCause();
            }
            throw new RuntimeException(e);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static class EquinoxLock
    implements Lock {
        private Object locker;

        public EquinoxLock(Object locker) {
            this.locker = locker;
        }

        public void release() {
            try {
                Method releaseMethod = this.locker.getClass().getMethod("release", null);
                releaseMethod.invoke(this.locker, null);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }
}

