/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.core.internal.archetype;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.maven.archetype.catalog.Archetype;
import org.apache.maven.archetype.common.ArchetypeArtifactManager;
import org.apache.maven.archetype.exception.UnknownArchetype;
import org.apache.maven.archetype.metadata.ArchetypeDescriptor;
import org.apache.maven.archetype.source.ArchetypeDataSource;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.codehaus.plexus.PlexusContainer;
import org.codehaus.plexus.component.repository.exception.ComponentLookupException;
import org.codehaus.plexus.util.IOUtil;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.m2e.core.MavenPlugin;
import org.eclipse.m2e.core.embedder.ICallable;
import org.eclipse.m2e.core.embedder.IMaven;
import org.eclipse.m2e.core.embedder.IMavenExecutionContext;
import org.eclipse.m2e.core.internal.NoSuchComponentException;
import org.eclipse.m2e.core.internal.archetype.ArchetypeCatalogFactory;
import org.eclipse.m2e.core.internal.archetype.ArchetypeCatalogsWriter;

public class ArchetypeManager {
    private final Map<String, ArchetypeCatalogFactory> catalogs = new LinkedHashMap<String, ArchetypeCatalogFactory>();
    private final File configFile;
    private final ArchetypeCatalogsWriter writer;
    final ArchetypeArtifactManager aaMgr;
    private final org.apache.maven.archetype.Archetype archetyper;
    private final PlexusContainer container;

    public ArchetypeManager(PlexusContainer container, File configFile) {
        this.container = container;
        this.configFile = configFile;
        this.writer = new ArchetypeCatalogsWriter();
        try {
            this.aaMgr = (ArchetypeArtifactManager)container.lookup(ArchetypeArtifactManager.class);
            this.archetyper = (org.apache.maven.archetype.Archetype)container.lookup(org.apache.maven.archetype.Archetype.class);
        }
        catch (ComponentLookupException ex) {
            throw new NoSuchComponentException(ex);
        }
    }

    public Collection<ArchetypeCatalogFactory> getArchetypeCatalogs() {
        return new ArrayList<ArchetypeCatalogFactory>(this.catalogs.values());
    }

    public void addArchetypeCatalogFactory(ArchetypeCatalogFactory factory) {
        if (factory != null) {
            this.catalogs.put(factory.getId(), factory);
        }
    }

    public void removeArchetypeCatalogFactory(String catalogId) {
        this.catalogs.remove(catalogId);
    }

    public ArchetypeCatalogFactory getArchetypeCatalogFactory(String catalogId) {
        return this.catalogs.get(catalogId);
    }

    public void readCatalogs() throws IOException {
        if (this.configFile.exists()) {
            FileInputStream is = null;
            try {
                is = new FileInputStream(this.configFile);
                Collection<ArchetypeCatalogFactory> catalogs = this.writer.readArchetypeCatalogs(is);
                Iterator<ArchetypeCatalogFactory> it = catalogs.iterator();
                while (it.hasNext()) {
                    this.addArchetypeCatalogFactory(it.next());
                }
            }
            catch (Throwable throwable) {
                IOUtil.close(is);
                throw throwable;
            }
            IOUtil.close((InputStream)is);
        }
    }

    public void saveCatalogs() throws IOException {
        FileOutputStream os = null;
        try {
            os = new FileOutputStream(this.configFile);
            this.writer.writeArchetypeCatalogs(this.getArchetypeCatalogs(), os);
        }
        catch (Throwable throwable) {
            IOUtil.close(os);
            throw throwable;
        }
        IOUtil.close((OutputStream)os);
    }

    public ArtifactRepository getArchetypeRepository(Archetype archetype) throws CoreException {
        String repoUrl = archetype.getRepository();
        if (repoUrl == null || repoUrl.trim().isEmpty()) {
            return null;
        }
        return MavenPlugin.getMaven().createArtifactRepository(String.valueOf(archetype.getArtifactId()) + "-repo", repoUrl);
    }

    public List<?> getRequiredProperties(Archetype archetype, ArtifactRepository remoteArchetypeRepository, IProgressMonitor monitor) throws UnknownArchetype, CoreException {
        final class WrappedUnknownArchetype
        extends RuntimeException {
            public WrappedUnknownArchetype(UnknownArchetype ex) {
                super(ex);
            }
        }
        Assert.isNotNull((Object)archetype, (String)"Archetype can not be null");
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        final String groupId = archetype.getGroupId();
        final String artifactId = archetype.getArtifactId();
        final String version = archetype.getVersion();
        IMaven maven = MavenPlugin.getMaven();
        final ArrayList<ArtifactRepository> repositories = new ArrayList<ArtifactRepository>(maven.getArtifactRepositories());
        if (remoteArchetypeRepository != null) {
            repositories.add(0, remoteArchetypeRepository);
        }
        try {
            return (List)maven.execute(new ICallable<List<?>>(){

                @Override
                public List<?> call(IMavenExecutionContext context, IProgressMonitor monitor) {
                    ArtifactRepository localRepository = context.getLocalRepository();
                    if (ArchetypeManager.this.aaMgr.isFileSetArchetype(groupId, artifactId, version, null, localRepository, repositories)) {
                        ArchetypeDescriptor descriptor;
                        try {
                            descriptor = ArchetypeManager.this.aaMgr.getFileSetArchetypeDescriptor(groupId, artifactId, version, null, localRepository, repositories);
                        }
                        catch (UnknownArchetype ex) {
                            throw new WrappedUnknownArchetype(ex);
                        }
                        return descriptor.getRequiredProperties();
                    }
                    return null;
                }
            }, monitor);
        }
        catch (WrappedUnknownArchetype e) {
            throw (UnknownArchetype)e.getCause();
        }
    }

    public ArchetypeArtifactManager getArchetypeArtifactManager() {
        return this.aaMgr;
    }

    public org.apache.maven.archetype.Archetype getArchetyper() {
        return this.archetyper;
    }

    public ArchetypeDataSource getArchetypeDataSource(String hint) {
        try {
            return (ArchetypeDataSource)this.container.lookup(ArchetypeDataSource.class, hint);
        }
        catch (ComponentLookupException ex) {
            throw new NoSuchComponentException(ex);
        }
    }
}

