/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.common.services.ui.refactor.internal;

import java.util.Set;
import oracle.eclipse.tools.common.services.dependency.artifact.ArtifactControllerFactory;
import oracle.eclipse.tools.common.services.dependency.artifact.IArtifact;
import oracle.eclipse.tools.common.services.dependency.artifact.IArtifactReference;
import oracle.eclipse.tools.common.services.dependency.artifact.IVirtualArtifact;
import oracle.eclipse.tools.common.services.dependency.artifact.Range;
import oracle.eclipse.tools.common.services.dependency.artifact.ResourceLocation;
import oracle.eclipse.tools.common.services.dependency.artifact.resource.ResourceArtifact;
import oracle.eclipse.tools.common.services.dependency.model.internal.DependencyModelManager;
import oracle.eclipse.tools.common.services.refactoring.BundleRefactoringUtil;
import oracle.eclipse.tools.common.services.refactoring.RefactoringUtil;
import oracle.eclipse.tools.common.services.ui.refactor.internal.ArtifactRefactoringWizard;
import oracle.eclipse.tools.common.services.ui.refactor.internal.Messages;
import oracle.eclipse.tools.common.services.ui.refactor.internal.PropertyRefactoringWizard;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.jdt.ui.refactoring.RefactoringSaveHelper;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ltk.ui.refactoring.RefactoringWizard;
import org.eclipse.ltk.ui.refactoring.RefactoringWizardOpenOperation;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMAttr;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;

public class ArtifactRefactoringCommandHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        IFileEditorInput fInput;
        IFile file;
        Object obj;
        ISelection selection = HandlerUtil.getActiveMenuSelection((ExecutionEvent)event);
        if (selection instanceof IStructuredSelection && (obj = ((IStructuredSelection)selection).getFirstElement()) instanceof IVirtualArtifact) {
            IVirtualArtifact artifact = (IVirtualArtifact)obj;
            IFile file2 = (IFile)artifact.getLocation().getResource();
            Shell shell = HandlerUtil.getActiveShell((ExecutionEvent)event);
            ResourceLocation location = artifact.getBoundedLocation();
            if (location == null) {
                location = artifact.getLocation();
            }
            if (location != null && location.getRange() != null) {
                Range replaceRange;
                String rangeString = RefactoringUtil.getRangeString((IFile)file2, (Range)location.getRange());
                String name = artifact.getName();
                if (rangeString != null && name != null && file2.exists() && (replaceRange = RefactoringUtil.getReplaceRange((IFile)file2, (Range)location.getRange(), (String)name)) != null) {
                    this.showDialog(shell, file2, (IArtifact)artifact, replaceRange, null);
                }
            }
            return null;
        }
        IEditorInput eInput = HandlerUtil.getActiveEditorInput((ExecutionEvent)event);
        if (eInput instanceof IFileEditorInput && (file = (fInput = (IFileEditorInput)eInput).getFile()) != null) {
            ResourceArtifact artifact = DependencyModelManager.getInstance().getModel().ensureResourceArtifact((IResource)file);
            if (selection instanceof IStructuredSelection) {
                IDOMNode node = this.findSelectedNode((IStructuredSelection)selection, event);
                if (node != null) {
                    int offset = node.getStartOffset();
                    if (node instanceof IDOMAttr) {
                        offset = ((IDOMAttr)node).getValueRegionStartOffset();
                    }
                    this.refactorArtifactDefinitionAtOffset(file, (IArtifact)artifact, offset, event, node);
                }
            } else if (selection instanceof ITextSelection) {
                int offset = ((ITextSelection)selection).getOffset();
                if (BundleRefactoringUtil.isBundleFile((IResource)file)) {
                    this.refactorReferencesDefinitionsAtOffset(file, artifact, offset, selection, event);
                }
            }
        }
        return null;
    }

    private void refactorReferencesDefinitionsAtOffset(IFile file, ResourceArtifact artifact, int offset, ISelection selection, ExecutionEvent event) {
        Range range = BundleRefactoringUtil.findPropertyKeyRangeAtOffset((IFile)file, (int)offset);
        if (range != null) {
            this.showDialog(event, (IArtifact)artifact, range, null);
        }
    }

    private IDOMNode findSelectedNode(IStructuredSelection selection, ExecutionEvent event) {
        Object obj;
        if (!selection.isEmpty() && (obj = selection.getFirstElement()) instanceof IDOMNode) {
            return (IDOMNode)obj;
        }
        return null;
    }

    private final boolean refactorArtifactDefinitionAtOffset(IFile file, IArtifact artifact, int offset, ExecutionEvent event, IDOMNode node) {
        Set childArtrifacts = ArtifactControllerFactory.getController().getArtifactChildren(artifact);
        for (IArtifact childArtifact : childArtrifacts) {
            Range range;
            ResourceLocation childArtifactLocation;
            ResourceLocation resourceLocation = childArtifactLocation = childArtifact instanceof IVirtualArtifact ? ((IVirtualArtifact)childArtifact).getBoundedLocation() : childArtifact.getLocation();
            if (file.equals((Object)childArtifactLocation.getResource()) && (range = childArtifactLocation.getRange()) != null && range.contains((long)offset)) {
                if (this.refactorArtifactDefinitionAtOffset(file, childArtifact, offset, event, node)) {
                    return true;
                }
                this.showDialog(event, childArtifact, range, node);
                return true;
            }
            if (!this.refactorArtifactDefinitionAtOffset(file, childArtifact, offset, event, node)) continue;
            return true;
        }
        Set references = artifact.getReferences();
        for (IArtifactReference reference : references) {
            IArtifact targetArtifact;
            if (!reference.isTargetDefinedByReferringSource() || !this.refactorArtifactDefinitionAtOffset(file, targetArtifact = reference.getTargetArtifact(), offset, event, node)) continue;
            return true;
        }
        return false;
    }

    private final void showDialog(ExecutionEvent event, IArtifact artifact, Range range, IDOMNode node) {
        IFileEditorInput fInput;
        IFile file;
        Shell activeShell = HandlerUtil.getActiveShell((ExecutionEvent)event);
        if (artifact.getType() != null && artifact.getType().equals("adf-datacontrol-adapter")) {
            MessageDialog.openInformation((Shell)activeShell, (String)Messages.ArtifactRefactoringCommandHandler_adapterRenameInvalidTitle, (String)Messages.ArtifactRefactoringCommandHandler_adapterRenameInvalidMesg);
            return;
        }
        IEditorInput eInput = HandlerUtil.getActiveEditorInput((ExecutionEvent)event);
        if (eInput instanceof IFileEditorInput && (file = (fInput = (IFileEditorInput)eInput).getFile()) != null) {
            this.showDialog(activeShell, file, artifact, range, node);
        }
    }

    protected void showDialog(Shell shell, IFile file, IArtifact artifact, Range range, IDOMNode node) {
        RefactoringSaveHelper saveHelper = new RefactoringSaveHelper(1);
        saveHelper.saveEditors(shell);
        RefactoringWizard refactoringWizard = node == null ? new PropertyRefactoringWizard(file, artifact, range) : new ArtifactRefactoringWizard(file, artifact, range, node);
        RefactoringWizardOpenOperation op = new RefactoringWizardOpenOperation(refactoringWizard);
        try {
            op.run(shell, Messages.RefactorCommandHandler_title);
        }
        catch (InterruptedException interruptedException) {}
    }
}

