/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.common.services.ui.quickfix;

import java.util.Map;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import oracle.eclipse.tools.common.services.catalogue.Catalogue;
import oracle.eclipse.tools.common.services.catalogue.CatalogueIndex;
import oracle.eclipse.tools.common.services.catalogue.ThreadSafeCatalogue;
import oracle.eclipse.tools.common.services.ui.quickfix.QuickFixCatalogue;
import oracle.eclipse.tools.common.services.ui.quickfix.QuickFixCatalogueIndex;
import org.eclipse.ui.IMarkerResolution;

public class ThreadSafeQuickFixCatalogue
extends QuickFixCatalogue {
    private final ThreadSafeCatalogue _superDelegate;
    private final QuickFixCatalogue _delegate;
    private final ReadWriteLock _lock;

    public ThreadSafeQuickFixCatalogue(QuickFixCatalogue catalogue) {
        this._delegate = catalogue;
        this._lock = new ReentrantReadWriteLock();
        this._superDelegate = new ThreadSafeCatalogue((Catalogue)this._delegate, this._lock);
    }

    @Override
    public void addIndex(QuickFixCatalogueIndex index) {
        this._superDelegate.addIndex((CatalogueIndex)index);
    }

    @Override
    public void addResolution(final String srcId, final String id, final IMarkerResolution res) {
        this._superDelegate.executeWriteLockedNoReturn(new Runnable(){

            @Override
            public void run() {
                ThreadSafeQuickFixCatalogue.this._delegate.addResolution(srcId, id, res);
            }
        });
    }

    @Override
    public QuickFixCatalogueIndex getIndex(final String srcId, final String id) {
        return (QuickFixCatalogueIndex)((Object)this._superDelegate.executeReadLocked((ThreadSafeCatalogue.RunnableWithReturn)new ThreadSafeCatalogue.RunnableWithReturn<QuickFixCatalogueIndex>(){

            public QuickFixCatalogueIndex run() {
                return ThreadSafeQuickFixCatalogue.this._delegate.getIndex(srcId, id);
            }
        }));
    }

    @Override
    public QuickFixCatalogueIndex findByKey(final String key) {
        return (QuickFixCatalogueIndex)((Object)this._superDelegate.executeReadLocked((ThreadSafeCatalogue.RunnableWithReturn)new ThreadSafeCatalogue.RunnableWithReturn<QuickFixCatalogueIndex>(){

            public QuickFixCatalogueIndex run() {
                return ThreadSafeQuickFixCatalogue.this._delegate.findByKey(key);
            }
        }));
    }

    public Map<String, ? extends CatalogueIndex> getIndices(String srcId) {
        return this._superDelegate.getIndices(srcId);
    }

    public int size() {
        return this._superDelegate.size();
    }
}

