/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.common.services.ui.jpa;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import oracle.eclipse.tools.common.services.ui.jpa.Messages;
import oracle.eclipse.tools.common.services.util.JPAUtils;
import oracle.eclipse.tools.common.ui.CommonImages;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jpt.jpa.core.context.Entity;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class EntitiesPageComposite
extends Composite {
    public static final String PROP_ENTITIES_CHANGED = "Entities Changed";
    private TableViewer availableEntitiesViewer;
    private TableViewer selectedEntitiesViewer;
    private ISelectionChangedListener availabeEntitiesSelectionListener;
    private ISelectionChangedListener selectedEntitiesSelectionListener;
    private SelectionListener rightBtnSelectionListener;
    private SelectionListener leftBtnSelectionListener;
    private SelectionListener rightAllBtnSelectionListener;
    private SelectionListener leftAllBtnSelectionListener;
    private IDoubleClickListener availabeEntitiesDoubleClickListener;
    private IDoubleClickListener selectedEntitiesDoubleClickListener;
    private Button rightBtn;
    private Button leftBtn;
    private Button rightAllBtn;
    private Button leftAllBtn;
    private List<String> entityNamesToRemove = new ArrayList<String>();
    private PropertyChangeSupport propChangeSupport = new PropertyChangeSupport((Object)this);
    private List<String> selectedSDEntities = new ArrayList<String>();
    private List<Entity> jpaProjectAllEntities = null;
    private String jpaProjectName;

    public EntitiesPageComposite(Composite parent, int style, List<String> serviceDefnEntityNames, String jpaProjectName) {
        super(parent, style);
        this.jpaProjectName = jpaProjectName;
        this.setLayout((Layout)new FormLayout());
        Label availableEntitiesLabel = new Label((Composite)this, 16384);
        availableEntitiesLabel.setText(Messages.EntitiesPageComposite_availableEntities);
        FormData fd_availableEntitiesLabel = new FormData();
        fd_availableEntitiesLabel.top = new FormAttachment(0, 10);
        fd_availableEntitiesLabel.left = new FormAttachment(0, 10);
        availableEntitiesLabel.setLayoutData((Object)fd_availableEntitiesLabel);
        this.availableEntitiesViewer = new TableViewer((Composite)this);
        Table availableEntitiesList = this.availableEntitiesViewer.getTable();
        FormData fd_availableEntitiesList = new FormData();
        fd_availableEntitiesList.top = new FormAttachment((Control)availableEntitiesLabel, 5);
        fd_availableEntitiesList.left = new FormAttachment((Control)availableEntitiesLabel, 0, 16384);
        fd_availableEntitiesList.bottom = new FormAttachment(100);
        fd_availableEntitiesList.right = new FormAttachment(44);
        availableEntitiesList.setLayoutData((Object)fd_availableEntitiesList);
        this.selectedEntitiesViewer = new TableViewer((Composite)this);
        Table selectedEntitiesList = this.selectedEntitiesViewer.getTable();
        Composite btnComposite = new Composite((Composite)this, 0);
        btnComposite.setLayout((Layout)new FormLayout());
        FormData fd_btnComposite = new FormData();
        fd_btnComposite.top = new FormAttachment((Control)availableEntitiesList, 0, 0x1000000);
        fd_btnComposite.left = new FormAttachment((Control)availableEntitiesList);
        btnComposite.setLayoutData((Object)fd_btnComposite);
        this.rightBtn = new Button(btnComposite, 8);
        this.rightAllBtn = new Button(btnComposite, 8);
        FormData fd_rightBtn = new FormData();
        fd_rightBtn.left = new FormAttachment((Control)this.rightAllBtn, 0, 16384);
        fd_rightBtn.right = new FormAttachment((Control)this.rightAllBtn, 0, 131072);
        this.rightBtn.setLayoutData((Object)fd_rightBtn);
        this.rightBtn.setImage(CommonImages.createImage((ImageDescriptor)CommonImages.DESC_BUTTON_MOVE_RIGHT));
        this.rightBtn.setToolTipText(Messages.EntitiesPageComposite_selectEntities);
        this.leftBtn = new Button(btnComposite, 8);
        FormData fd_leftBtn = new FormData();
        fd_leftBtn.top = new FormAttachment((Control)this.rightBtn, 5);
        fd_leftBtn.left = new FormAttachment((Control)this.rightAllBtn, 0, 16384);
        fd_leftBtn.right = new FormAttachment((Control)this.rightAllBtn, 0, 131072);
        this.leftBtn.setLayoutData((Object)fd_leftBtn);
        this.leftBtn.setImage(CommonImages.createImage((ImageDescriptor)CommonImages.DESC_BUTTON_MOVE_LEFT));
        this.leftBtn.setToolTipText(Messages.EntitiesPageComposite_removeEntities);
        FormData fd_rightAllBtn = new FormData();
        fd_rightAllBtn.top = new FormAttachment((Control)this.leftBtn, 15);
        fd_rightAllBtn.left = new FormAttachment(0, 15);
        this.rightAllBtn.setLayoutData((Object)fd_rightAllBtn);
        this.rightAllBtn.setImage(CommonImages.createImage((ImageDescriptor)CommonImages.DESC_BUTTON_MOVE_ALL_RIGHT));
        this.rightAllBtn.setToolTipText(Messages.EntitiesPageComposite_addAllEntities_tooltip);
        this.leftAllBtn = new Button(btnComposite, 8);
        FormData fd_leftAllBtn = new FormData();
        fd_leftAllBtn.top = new FormAttachment((Control)this.rightAllBtn, 5);
        fd_leftAllBtn.left = new FormAttachment((Control)this.rightAllBtn, 0, 16384);
        fd_leftAllBtn.right = new FormAttachment((Control)this.rightAllBtn, 0, 131072);
        this.leftAllBtn.setLayoutData((Object)fd_leftAllBtn);
        this.leftAllBtn.setImage(CommonImages.createImage((ImageDescriptor)CommonImages.DESC_BUTTON_MOVE_ALL_LEFT));
        this.leftAllBtn.setToolTipText(Messages.EntitiesPageComposite_removeAllEntities);
        Label selectedEntitiesLabel = new Label((Composite)this, 16384);
        selectedEntitiesLabel.setText(Messages.EntitiesPageComposite_selectedEntities);
        FormData fd_selectedEntitiesLabel = new FormData();
        fd_selectedEntitiesLabel.top = new FormAttachment((Control)availableEntitiesLabel, 0, 128);
        fd_selectedEntitiesLabel.left = new FormAttachment((Control)selectedEntitiesList, 0, 16384);
        selectedEntitiesLabel.setLayoutData((Object)fd_selectedEntitiesLabel);
        FormData fd_selectedEntitiesList = new FormData();
        fd_selectedEntitiesList.top = new FormAttachment((Control)availableEntitiesList, 0, 128);
        fd_selectedEntitiesList.left = new FormAttachment((Control)btnComposite, 15);
        fd_selectedEntitiesList.bottom = new FormAttachment(100);
        fd_selectedEntitiesList.right = new FormAttachment(100, -10);
        selectedEntitiesList.setLayoutData((Object)fd_selectedEntitiesList);
        btnComposite.setTabList(new Control[]{this.rightBtn, this.leftBtn, this.rightAllBtn, this.leftAllBtn});
        this.setTabList(new Control[]{this.availableEntitiesViewer.getControl(), btnComposite, this.selectedEntitiesViewer.getControl()});
        this.init(serviceDefnEntityNames);
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.propChangeSupport.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.propChangeSupport.removePropertyChangeListener(listener);
    }

    public List<String> getSelectedEntities() {
        return Collections.unmodifiableList(this.selectedSDEntities);
    }

    private void init(List<String> serviceDefnEntityNames) {
        this.availableEntitiesViewer.setContentProvider((IContentProvider)new EntitiesContentProvider());
        this.availableEntitiesViewer.setLabelProvider((IBaseLabelProvider)new EntitiesListLabelProvider());
        this.selectedEntitiesViewer.setContentProvider((IContentProvider)new SelectedEntitiesContentProvider());
        this.selectedEntitiesViewer.setLabelProvider((IBaseLabelProvider)new SelectedEntitiesLabelProvider());
        this.initUI(serviceDefnEntityNames);
        this.createListeners();
        this.addListeners();
    }

    public String getJpaProjectName() {
        return this.jpaProjectName;
    }

    public void setJpaProjectName(String jpaProjectName, List<String> serviceDefnEntityNames) {
        this.jpaProjectName = jpaProjectName;
        this.initUI(serviceDefnEntityNames);
    }

    private void initUI(List<String> serviceDefnEntityNames) {
        IProject[] projects;
        if (this.jpaProjectName == null) {
            return;
        }
        IProject project = null;
        IProject[] iProjectArray = projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        int n = projects.length;
        int n2 = 0;
        while (n2 < n) {
            IProject p = iProjectArray[n2];
            if (p.getName().equals(this.jpaProjectName)) {
                project = p;
                break;
            }
            ++n2;
        }
        if (project != null) {
            this.jpaProjectAllEntities = JPAUtils.getEntities(project);
        }
        if (serviceDefnEntityNames != null && serviceDefnEntityNames.size() > 0) {
            this.selectedSDEntities.addAll(serviceDefnEntityNames);
        }
        this.selectedEntitiesViewer.setInput(this.selectedSDEntities);
        if (this.jpaProjectAllEntities != null) {
            ArrayList<Entity> entitiesToRemove = new ArrayList<Entity>();
            block1: for (Entity entity : this.jpaProjectAllEntities) {
                for (String sdEntity : this.selectedSDEntities) {
                    if (!entity.getPersistentType().getName().equals(sdEntity)) continue;
                    entitiesToRemove.add(entity);
                    continue block1;
                }
            }
            ArrayList<Entity> newList = new ArrayList<Entity>();
            newList.addAll(this.jpaProjectAllEntities);
            newList.removeAll(entitiesToRemove);
            this.availableEntitiesViewer.setInput(Collections.unmodifiableList(newList));
            this.setEnablement();
        }
    }

    private void createListeners() {
        this.rightBtnSelectionListener = new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                IStructuredSelection selection = (IStructuredSelection)EntitiesPageComposite.this.availableEntitiesViewer.getSelection();
                Iterator iterator = selection.iterator();
                ArrayList<Entity> entities = new ArrayList<Entity>();
                while (iterator.hasNext()) {
                    entities.add((Entity)iterator.next());
                }
                EntitiesPageComposite.this.addSelectedEntities(entities);
                EntitiesPageComposite.this.setEnablement();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        };
        this.leftBtnSelectionListener = new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                IStructuredSelection selection = (IStructuredSelection)EntitiesPageComposite.this.selectedEntitiesViewer.getSelection();
                Iterator it = selection.iterator();
                ArrayList<String> selectedEntStr = new ArrayList<String>();
                while (it.hasNext()) {
                    selectedEntStr.add((String)it.next());
                }
                EntitiesPageComposite.this.removeSelectedEntities(selectedEntStr);
                EntitiesPageComposite.this.setEnablement();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        };
        this.rightAllBtnSelectionListener = new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                List entities = (List)EntitiesPageComposite.this.availableEntitiesViewer.getInput();
                if (entities != null && entities.size() > 0) {
                    EntitiesPageComposite.this.addSelectedEntities(entities);
                }
                EntitiesPageComposite.this.setEnablement();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        };
        this.leftAllBtnSelectionListener = new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                EntitiesPageComposite.this.removeSelectedEntities(EntitiesPageComposite.this.selectedSDEntities);
                EntitiesPageComposite.this.setEnablement();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        };
        this.availabeEntitiesSelectionListener = new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                List entities = (List)EntitiesPageComposite.this.availableEntitiesViewer.getInput();
                if (entities == null || entities.size() == 0) {
                    EntitiesPageComposite.this.rightBtn.setEnabled(false);
                } else {
                    EntitiesPageComposite.this.rightBtn.setEnabled(true);
                    EntitiesPageComposite.this.rightAllBtn.setEnabled(entities.size() > 0);
                }
                EntitiesPageComposite.this.leftBtn.setEnabled(false);
                EntitiesPageComposite.this.leftAllBtn.setEnabled(EntitiesPageComposite.this.selectedSDEntities.size() > 0);
            }
        };
        this.selectedEntitiesSelectionListener = new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                List entities = (List)EntitiesPageComposite.this.availableEntitiesViewer.getInput();
                EntitiesPageComposite.this.rightBtn.setEnabled(false);
                EntitiesPageComposite.this.rightAllBtn.setEnabled(entities.size() > 0);
                List rEntities = (List)EntitiesPageComposite.this.selectedEntitiesViewer.getInput();
                if (rEntities == null || rEntities.size() == 0) {
                    EntitiesPageComposite.this.leftBtn.setEnabled(false);
                } else {
                    EntitiesPageComposite.this.leftBtn.setEnabled(true);
                }
                EntitiesPageComposite.this.leftAllBtn.setEnabled(EntitiesPageComposite.this.selectedSDEntities.size() > 0);
            }
        };
        this.availabeEntitiesDoubleClickListener = new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                IStructuredSelection selection = (IStructuredSelection)EntitiesPageComposite.this.availableEntitiesViewer.getSelection();
                Iterator iterator = selection.iterator();
                ArrayList<Entity> entities = new ArrayList<Entity>();
                while (iterator.hasNext()) {
                    entities.add((Entity)iterator.next());
                }
                EntitiesPageComposite.this.addSelectedEntities(entities);
                EntitiesPageComposite.this.setEnablement();
            }
        };
        this.selectedEntitiesDoubleClickListener = new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                IStructuredSelection selection = (IStructuredSelection)EntitiesPageComposite.this.selectedEntitiesViewer.getSelection();
                Iterator it = selection.iterator();
                ArrayList<String> selectedEntStr = new ArrayList<String>();
                while (it.hasNext()) {
                    selectedEntStr.add((String)it.next());
                }
                EntitiesPageComposite.this.removeSelectedEntities(selectedEntStr);
                EntitiesPageComposite.this.setEnablement();
            }
        };
    }

    private void addSelectedEntities(List<Entity> entities) {
        if (this.selectedSDEntities == null) {
            this.selectedSDEntities = new ArrayList<String>();
        }
        for (Entity entity : entities) {
            String name = entity.getPersistentType().getName();
            boolean found = false;
            for (String sde : this.selectedSDEntities) {
                if (!name.equals(sde)) continue;
                found = true;
                break;
            }
            if (found) continue;
            this.selectedSDEntities.add(name);
        }
        this.selectedEntitiesViewer.setInput(this.selectedSDEntities);
        this.selectedEntitiesViewer.refresh();
        List existingEntities = (List)this.availableEntitiesViewer.getInput();
        if (entities.size() > 0) {
            ArrayList newList = new ArrayList(existingEntities);
            newList.removeAll(entities);
            this.availableEntitiesViewer.setInput(Collections.unmodifiableList(newList));
            this.availableEntitiesViewer.refresh();
        }
        this.propChangeSupport.firePropertyChange(PROP_ENTITIES_CHANGED, null, this.selectedSDEntities);
    }

    private void removeSelectedEntities(List<String> selectedEntities) {
        if (selectedEntities.size() == 0) {
            return;
        }
        ArrayList<Entity> entitiesToAdd = new ArrayList<Entity>();
        for (String sdEntity : selectedEntities) {
            boolean found = false;
            for (Entity e : this.jpaProjectAllEntities) {
                if (!sdEntity.equals(e.getPersistentType().getName())) continue;
                entitiesToAdd.add(e);
                found = true;
                break;
            }
            if (found) continue;
            this.entityNamesToRemove.add(sdEntity);
        }
        List availableEntities = (List)this.availableEntitiesViewer.getInput();
        if (availableEntities != null) {
            ArrayList<Entity> newList = new ArrayList<Entity>(availableEntities);
            newList.addAll(entitiesToAdd);
            this.availableEntitiesViewer.setInput(Collections.unmodifiableList(newList));
            this.availableEntitiesViewer.refresh();
        }
        this.selectedSDEntities.removeAll(selectedEntities);
        this.selectedEntitiesViewer.refresh();
        this.propChangeSupport.firePropertyChange(PROP_ENTITIES_CHANGED, null, this.selectedSDEntities);
    }

    protected void setEnablement() {
        List entities = (List)this.availableEntitiesViewer.getInput();
        this.rightBtn.setEnabled(false);
        if (entities != null) {
            this.rightAllBtn.setEnabled(entities.size() > 0);
        } else {
            this.rightAllBtn.setEnabled(false);
        }
        this.leftBtn.setEnabled(false);
        if (this.selectedSDEntities != null) {
            this.leftAllBtn.setEnabled(this.selectedSDEntities.size() > 0);
        } else {
            this.leftAllBtn.setEnabled(false);
        }
    }

    private void addListeners() {
        this.rightBtn.addSelectionListener(this.rightBtnSelectionListener);
        this.leftBtn.addSelectionListener(this.leftBtnSelectionListener);
        this.rightAllBtn.addSelectionListener(this.rightAllBtnSelectionListener);
        this.leftAllBtn.addSelectionListener(this.leftAllBtnSelectionListener);
        this.availableEntitiesViewer.addSelectionChangedListener(this.availabeEntitiesSelectionListener);
        this.availableEntitiesViewer.addDoubleClickListener(this.availabeEntitiesDoubleClickListener);
        this.selectedEntitiesViewer.addSelectionChangedListener(this.selectedEntitiesSelectionListener);
        this.selectedEntitiesViewer.addDoubleClickListener(this.selectedEntitiesDoubleClickListener);
    }

    private static class EntitiesContentProvider
    implements IStructuredContentProvider {
        private List<Entity> entityList;

        private EntitiesContentProvider() {
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            this.entityList = (List)newInput;
        }

        public Object[] getElements(Object inputElement) {
            return this.entityList.toArray();
        }
    }

    private static class EntitiesListLabelProvider
    extends LabelProvider
    implements ILabelProvider {
        private EntitiesListLabelProvider() {
        }

        public String getText(Object element) {
            return element instanceof Entity ? ((Entity)element).getPersistentType().getName() : element.toString();
        }

        public Image getImage(Object element) {
            if (element instanceof Entity) {
                return Images.createImage(Images.DESC_JPA_ENTITY_BEAN);
            }
            return null;
        }
    }

    public static final class Images {
        public static final ImageDescriptor DESC_JPA_ENTITY_BEAN = AbstractUIPlugin.imageDescriptorFromPlugin((String)"oracle.eclipse.tools.common.services.ui", (String)"images/jpa/entity-bean.png");
        private static Map<ImageDescriptor, Image> cache = new HashMap<ImageDescriptor, Image>();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static Image createImage(ImageDescriptor descriptor) {
            Map<ImageDescriptor, Image> map = cache;
            synchronized (map) {
                Image image = cache.get(descriptor);
                if (image == null) {
                    image = descriptor.createImage();
                    cache.put(descriptor, image);
                }
                return image;
            }
        }
    }

    private class SelectedEntitiesContentProvider
    implements IStructuredContentProvider {
        private SelectedEntitiesContentProvider() {
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public Object[] getElements(Object inputElement) {
            return EntitiesPageComposite.this.selectedSDEntities.toArray();
        }
    }

    private static class SelectedEntitiesLabelProvider
    extends LabelProvider
    implements ILabelProvider {
        private SelectedEntitiesLabelProvider() {
        }

        public String getText(Object element) {
            if (element instanceof String) {
                return element.toString();
            }
            return "";
        }

        public Image getImage(Object element) {
            if (element instanceof String) {
                return Images.createImage(Images.DESC_JPA_ENTITY_BEAN);
            }
            return null;
        }
    }
}

