/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.common.services.ui.dependency.util;

import oracle.eclipse.tools.common.ui.CommonImages;
import org.eclipse.jface.resource.CompositeImageDescriptor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Point;

public class OverlayImageDescriptor
extends CompositeImageDescriptor {
    public static final int ERROR = 1;
    public static final int WARNING = 16;
    private Image fBaseImage;
    private int fFlags;
    private Point fSize;

    public OverlayImageDescriptor(Image baseImage, int flags) {
        this.setBaseImage(baseImage);
        this.setFlags(flags);
    }

    protected Point getSize() {
        if (this.fSize == null) {
            ImageData data = this.getBaseImage().getImageData();
            this.setSize(new Point(data.width, data.height));
        }
        return this.fSize;
    }

    public boolean equals(Object object) {
        if (!(object instanceof OverlayImageDescriptor)) {
            return false;
        }
        OverlayImageDescriptor other = (OverlayImageDescriptor)((Object)object);
        return this.getBaseImage().equals((Object)other.getBaseImage()) && this.getFlags() == other.getFlags();
    }

    public int hashCode() {
        return this.getBaseImage().hashCode() | this.getFlags();
    }

    protected void drawCompositeImage(int width, int height) {
        ImageData bg = this.getBaseImage().getImageData();
        if (bg == null) {
            bg = DEFAULT_IMAGE_DATA;
        }
        this.drawImage(bg, 0, 0);
        this.drawOverlays();
    }

    protected void drawOverlays() {
        int flags = this.getFlags();
        ImageData data = null;
        if ((flags & 1) != 0) {
            data = CommonImages.DESC_OVERLAY_ERROR.getImageData();
            int y = this.getSize().y - data.height;
            this.drawImage(data, 0, y);
        } else if ((flags & 0x10) != 0) {
            data = CommonImages.DESC_OVERLAY_WARNING.getImageData();
            int y = this.getSize().y - data.height;
            this.drawImage(data, 0, y);
        }
    }

    protected Image getBaseImage() {
        return this.fBaseImage;
    }

    protected void setBaseImage(Image baseImage) {
        this.fBaseImage = baseImage;
    }

    protected int getFlags() {
        return this.fFlags;
    }

    protected void setFlags(int flags) {
        this.fFlags = flags;
    }

    protected void setSize(Point size) {
        this.fSize = size;
    }
}

