/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.common.services.ui.dependency.prefs;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import oracle.eclipse.tools.common.services.Activator;
import oracle.eclipse.tools.common.services.Preferences;
import oracle.eclipse.tools.common.services.dependency.model.internal.DependencyModelManager;
import oracle.eclipse.tools.common.services.project.technology.AbstractTechnologyDiscoveryProvider;
import oracle.eclipse.tools.common.services.project.technology.ITechnologyExtensionIdentifier;
import oracle.eclipse.tools.common.services.ui.Activator;
import oracle.eclipse.tools.common.services.ui.dependency.prefs.Messages;
import oracle.eclipse.tools.common.ui.dialogs.DialogService;
import oracle.eclipse.tools.common.ui.dialogs.IToggleValue;
import oracle.eclipse.tools.common.ui.dialogs.YesNoToggleValue;
import oracle.eclipse.tools.common.util.logging.LoggingService;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class DependencyPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private static final String TECH_EXT = "oracle.eclipse.tools.common.services.TechnologyExtension";
    private static final String CONFIRM_REFRESH_DIALOG_SUPRESSION_KEY = String.valueOf(DependencyPreferencePage.class.getName()) + ".confirm.refresh";
    private Composite rootComposite;
    private Button enableAllButton = null;
    private Button disableAllButton = null;
    private Button overrideButton = null;
    private Button disableButton = null;
    private Button fileFilterButton = null;
    private Table techExtTable = null;
    private TableViewer techExtList = null;
    private List<ITechnologyExtensionIdentifier> techExtensions;
    private boolean[][] checkPoint;
    private Preferences preferences = null;
    private boolean overrideCheckPoint;
    private boolean disableCheckPoint;
    private boolean systemFilesCheckPoint;

    protected Control createContents(Composite parent) {
        this.preferences = this.getPreferences();
        this.techExtensions = new ArrayList<ITechnologyExtensionIdentifier>(this.getTechExtensions());
        this.createCheckPoint();
        this.rootComposite = new Composite(parent, 0);
        if (this.isDisableBeforeOverride()) {
            this.addDisableOption(this.rootComposite);
            this.addOverride(this.rootComposite);
        } else {
            this.addOverride(this.rootComposite);
            this.addDisableOption(this.rootComposite);
        }
        this.addFileFilter(this.rootComposite);
        GridLayout techExtGroupLayout = new GridLayout();
        techExtGroupLayout.numColumns = 2;
        this.rootComposite.setLayout((Layout)techExtGroupLayout);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)this.rootComposite);
        new Label(this.rootComposite, 0).setLayoutData((Object)new GridData());
        Label listLabel = new Label(this.rootComposite, 0);
        GridData listLabelData = new GridData(768);
        listLabelData.horizontalSpan = 2;
        listLabel.setLayoutData((Object)listLabelData);
        listLabel.setText(Messages.DependencyPreferencePage_ChooseTechnologies);
        this.techExtTable = new Table(this.rootComposite, 67588);
        Point preferredSize = this.techExtTable.computeSize(-1, -1);
        GridDataFactory.fillDefaults().grab(true, true).hint(preferredSize).span(2, 1).applyTo((Control)this.techExtTable);
        this.techExtTable.setHeaderVisible(true);
        this.techExtTable.setLinesVisible(true);
        this.techExtList = new TableViewer(this.techExtTable);
        this.techExtList.setLabelProvider((IBaseLabelProvider)new TechnologyLabelProvider());
        this.techExtList.setContentProvider((IContentProvider)new TechnologyExtensionContentProvider());
        this.setupTableColumns(this.techExtTable);
        this.techExtList.setInput(this.techExtensions);
        this.techExtTable.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                int columnNumber;
                if (e.button != 1) {
                    return;
                }
                TableItem tableItem = DependencyPreferencePage.this.techExtTable.getItem(new Point(e.x, e.y));
                if (tableItem == null || tableItem.isDisposed()) {
                    return;
                }
                int columnsCount = DependencyPreferencePage.this.techExtTable.getColumnCount();
                if (columnsCount == 0) {
                    columnNumber = 0;
                } else {
                    columnNumber = -1;
                    int i = 0;
                    while (i < columnsCount) {
                        Rectangle bounds = tableItem.getBounds(i);
                        if (bounds.contains(e.x, e.y)) {
                            columnNumber = i;
                            break;
                        }
                        ++i;
                    }
                    if (columnNumber == -1) {
                        return;
                    }
                }
                DependencyPreferencePage.this.columnClicked(columnNumber);
            }
        });
        this.techExtTable.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusGained(FocusEvent e) {
                super.focusGained(e);
                if (DependencyPreferencePage.this.techExtTable.getSelectionCount() == 0) {
                    DependencyPreferencePage.this.techExtTable.select(0);
                }
            }
        });
        this.addEnableDisable(this.rootComposite);
        this.updateWidgets();
        this.applyDialogFont(this.rootComposite);
        this.rootComposite.setSize(this.rootComposite.computeSize(-1, -1));
        return this.rootComposite;
    }

    protected Preferences getPreferences() {
        return Activator.getDefault().getPreferences();
    }

    protected boolean isDisableBeforeOverride() {
        return true;
    }

    private void createCheckPoint() {
        this.checkPoint = new boolean[this.techExtensions.size()][];
        int i = 0;
        while (i < this.techExtensions.size()) {
            ITechnologyExtensionIdentifier ite = this.techExtensions.get(i);
            this.checkPoint[i] = new boolean[2];
            this.checkPoint[i][0] = this.preferences.isTechnologyExtensionActiveForDiscovery(ite.getId(), ite.getVersion());
            this.checkPoint[i][1] = this.preferences.isTechnologyExtensionActiveForCollection(ite.getId(), ite.getVersion());
            ++i;
        }
        this.overrideCheckPoint = this.preferences.isProjectSpecificSettingAllowed();
        this.systemFilesCheckPoint = this.preferences.isIgnoreSystemFilePreference();
        this.disableCheckPoint = this.preferences.isDisabled();
    }

    protected List<ITechnologyExtensionIdentifier> getTechExtensions() {
        ArrayList<ITechnologyExtensionIdentifier> techExtIds = new ArrayList<ITechnologyExtensionIdentifier>();
        IConfigurationElement[] configElems = Platform.getExtensionRegistry().getConfigurationElementsFor(TECH_EXT);
        int i = 0;
        while (i < configElems.length) {
            IConfigurationElement config = configElems[i];
            techExtIds.add((ITechnologyExtensionIdentifier)new AbstractTechnologyDiscoveryProvider.TechnologyExtensionIdentifier(config));
            ++i;
        }
        Collections.sort(techExtIds, new Comparator<ITechnologyExtensionIdentifier>(){

            @Override
            public int compare(ITechnologyExtensionIdentifier o1, ITechnologyExtensionIdentifier o2) {
                if (o1.getPriority() > o2.getPriority()) {
                    return 1;
                }
                if (o1.getPriority() < o2.getPriority()) {
                    return -1;
                }
                return 0;
            }
        });
        return techExtIds;
    }

    private void setupTableColumns(Table table) {
        TableColumn techExtColumn = new TableColumn(table, 0);
        techExtColumn.setText(Messages.DependencyPreferencePage_Column0Heading);
        techExtColumn.setWidth(280);
        TableColumn discoveryColumn = new TableColumn(table, 0x1000000);
        discoveryColumn.setText(Messages.DependencyPreferencePage_Column1Heading);
        discoveryColumn.pack();
        TableColumn collectionColumn = new TableColumn(table, 0x1000000);
        collectionColumn.setText(Messages.DependencyPreferencePage_Column2Heading);
        collectionColumn.pack();
    }

    private void addEnableDisable(Composite validatorGroup) {
        this.enableAllButton = new Button(validatorGroup, 8);
        this.enableAllButton.setLayoutData((Object)new GridData());
        this.enableAllButton.setText(Messages.DependencyPreferencePage_EnableButtonLabel);
        this.enableAllButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DependencyPreferencePage.this.performEnableAll();
            }
        });
        this.disableAllButton = new Button(validatorGroup, 8);
        this.disableAllButton.setLayoutData((Object)new GridData());
        this.disableAllButton.setText(Messages.DependencyPreferencePage_DisableButtonLabel);
        this.disableAllButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DependencyPreferencePage.this.performDisableAll();
            }
        });
    }

    protected void addOverride(Composite techExtGroup) {
        GridData gd = new GridData(768);
        gd.horizontalSpan = 2;
        this.overrideButton = new Button(techExtGroup, 32);
        this.overrideButton.setLayoutData((Object)gd);
        this.overrideButton.setText(Messages.DependencyPreferencePage_AllowProjectOverrideText);
        this.overrideButton.setEnabled(true);
        this.overrideButton.setSelection(this.preferences.isProjectSpecificSettingAllowed());
        this.overrideButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DependencyPreferencePage.this.preferences.setProjectSpecificSettingAllowed(DependencyPreferencePage.this.overrideButton.getSelection());
                DependencyPreferencePage.this.overrideButton.setFocus();
            }
        });
    }

    protected void addDisableOption(Composite techExtGroup) {
        GridData gd = new GridData(768);
        gd.horizontalSpan = 2;
        this.disableButton = new Button(techExtGroup, 32);
        this.disableButton.setLayoutData((Object)gd);
        this.disableButton.setText(Messages.DependencyPreferencePage_disable);
        this.disableButton.setEnabled(true);
        this.disableButton.setSelection(this.preferences.isDisabled());
        this.disableButton.setToolTipText(Messages.DependencyPreferencePage_disableHoverText);
        this.disableButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                boolean disabledSelection = DependencyPreferencePage.this.disableButton.getSelection();
                DependencyPreferencePage.this.preferences.setDisabled(disabledSelection);
                if (disabledSelection && DependencyPreferencePage.this.overrideButton != null) {
                    DependencyPreferencePage.this.overrideButton.setSelection(false);
                    DependencyPreferencePage.this.preferences.setProjectSpecificSettingAllowed(false);
                }
                DependencyPreferencePage.this.updateWidgets();
                DependencyPreferencePage.this.disableButton.setFocus();
            }
        });
    }

    protected Button getDisableButton() {
        return this.disableButton;
    }

    protected void addFileFilter(Composite techExtGroup) {
        GridData gd = new GridData(768);
        gd.horizontalSpan = 2;
        this.fileFilterButton = new Button(techExtGroup, 32);
        this.fileFilterButton.setLayoutData((Object)gd);
        this.fileFilterButton.setText(Messages.DependencyPreferencePage_FileFilterText);
        this.fileFilterButton.setEnabled(true);
        this.fileFilterButton.setSelection(this.preferences.isIgnoreSystemFilePreference());
        this.fileFilterButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DependencyPreferencePage.this.preferences.setIgnoreSystemFilePreference(DependencyPreferencePage.this.fileFilterButton.getSelection());
                DependencyPreferencePage.this.fileFilterButton.setFocus();
            }
        });
    }

    private void columnClicked(int columnToEdit) {
        IStructuredSelection selection = (IStructuredSelection)this.techExtList.getSelection();
        ITechnologyExtensionIdentifier ite = (ITechnologyExtensionIdentifier)selection.getFirstElement();
        switch (columnToEdit) {
            case 1: {
                boolean discoveryEnabled = this.toggleDiscoveryPreference(ite);
                if (discoveryEnabled) break;
                this.preferences.setTechnologyExtensionActiveForCollection(ite.getId(), ite.getVersion(), false);
                break;
            }
            case 2: {
                boolean collectionEnabled = this.toggleCollectionPreference(ite);
                if (!collectionEnabled) break;
                this.preferences.setTechnologyExtensionActiveForDiscovery(ite.getId(), ite.getVersion(), true);
                break;
            }
        }
        this.techExtList.refresh();
    }

    private boolean toggleDiscoveryPreference(ITechnologyExtensionIdentifier ite) {
        boolean toggledValue = !this.preferences.isTechnologyExtensionActiveForDiscovery(ite.getId(), ite.getVersion());
        this.preferences.setTechnologyExtensionActiveForDiscovery(ite.getId(), ite.getVersion(), toggledValue);
        return toggledValue;
    }

    private boolean toggleCollectionPreference(ITechnologyExtensionIdentifier ite) {
        boolean toggledValue = !this.preferences.isTechnologyExtensionActiveForCollection(ite.getId(), ite.getVersion());
        this.preferences.setTechnologyExtensionActiveForCollection(ite.getId(), ite.getVersion(), toggledValue);
        return toggledValue;
    }

    protected void updateWidgets() {
        this.techExtList.setInput(this.techExtensions);
        this.techExtList.refresh();
        if (this.overrideButton != null) {
            this.overrideButton.setSelection(this.preferences.isProjectSpecificSettingAllowed());
            this.overrideButton.setEnabled(!this.disableButton.getSelection());
        }
        boolean enableActions = this.shouldEnableActions();
        this.techExtTable.setEnabled(enableActions);
        this.enableAllButton.setEnabled(enableActions);
        this.disableAllButton.setEnabled(enableActions);
        this.fileFilterButton.setEnabled(enableActions);
    }

    protected boolean shouldEnableActions() {
        return !this.preferences.isDisabled();
    }

    private boolean performEnableAll() {
        this.setAllTechExtensions(true);
        this.enableAllButton.setFocus();
        this.techExtList.refresh();
        return true;
    }

    private boolean performDisableAll() {
        this.setAllTechExtensions(false);
        this.disableAllButton.setFocus();
        this.techExtList.refresh();
        return true;
    }

    public boolean performCancel() {
        int i = 0;
        while (i < this.techExtensions.size()) {
            ITechnologyExtensionIdentifier ite = this.techExtensions.get(i);
            if (this.preferences.isTechnologyExtensionActiveForDiscovery(ite.getId(), ite.getVersion()) != this.checkPoint[i][0]) {
                this.preferences.setTechnologyExtensionActiveForDiscovery(ite.getId(), ite.getVersion(), this.checkPoint[i][0]);
            }
            if (this.preferences.isTechnologyExtensionActiveForCollection(ite.getId(), ite.getVersion()) != this.checkPoint[i][1]) {
                this.preferences.setTechnologyExtensionActiveForCollection(ite.getId(), ite.getVersion(), this.checkPoint[i][1]);
            }
            ++i;
        }
        if (this.preferences.isProjectSpecificSettingAllowed() != this.overrideCheckPoint) {
            this.preferences.setProjectSpecificSettingAllowed(this.overrideCheckPoint);
        }
        if (this.preferences.isIgnoreSystemFilePreference() != this.systemFilesCheckPoint) {
            this.preferences.setIgnoreSystemFilePreference(this.systemFilesCheckPoint);
        }
        if (this.preferences.isDisabled() != this.disableCheckPoint) {
            this.preferences.setDisabled(this.disableCheckPoint);
        }
        return super.performCancel();
    }

    protected void performDefaults() {
        super.performDefaults();
        this.preferences.resetToDefaultDisabled();
        this.preferences.resetToDefaultProjectSpecificSettingAllowed();
        this.preferences.resetToDefaultIgnoreSystemFilePreference();
        for (ITechnologyExtensionIdentifier ite : this.techExtensions) {
            this.preferences.resetToDefaultTechnologyExtensionActiveForDiscovery(ite.getId(), ite.getVersion());
            this.preferences.resetToDefaultTechnologyExtensionActiveForCollection(ite.getId(), ite.getVersion());
        }
        this.techExtList.refresh();
        this.disableButton.setSelection(this.preferences.isDisabled());
        this.updateWidgets();
    }

    public boolean performOk() {
        IPreferenceStore store;
        IToggleValue val;
        if (!this.preferences.flush()) {
            return false;
        }
        boolean refreshNeeded = false;
        int i = 0;
        while (i < this.techExtensions.size()) {
            ITechnologyExtensionIdentifier ite = this.techExtensions.get(i);
            if (this.preferences.isTechnologyExtensionActiveForDiscovery(ite.getId(), ite.getVersion()) != this.checkPoint[i][0] || this.preferences.isTechnologyExtensionActiveForCollection(ite.getId(), ite.getVersion()) != this.checkPoint[i][1]) {
                refreshNeeded = true;
                break;
            }
            ++i;
        }
        refreshNeeded |= this.preferences.isProjectSpecificSettingAllowed() ^ this.overrideCheckPoint;
        this.createCheckPoint();
        Activator.getDefault().preferencesChanged();
        if ((refreshNeeded |= this.preferences.isDisabled() ^ this.disableCheckPoint) && (val = DialogService.showSuppressibleYesNoDialog((String)Messages.DependencyPreferencePage_refresh_title, (String)Messages.DependencyPreferencePage_refresh_text, (IPreferenceStore)(store = oracle.eclipse.tools.common.services.ui.Activator.getDefault().getPreferenceStore()), (String)CONFIRM_REFRESH_DIALOG_SUPRESSION_KEY, (IToggleValue)YesNoToggleValue.NO)) == YesNoToggleValue.YES) {
            Display.getCurrent().asyncExec(new Runnable(){

                @Override
                public void run() {
                    IRunnableWithProgress runnable = DependencyPreferencePage.this.getRefreshRunnable();
                    try {
                        new ProgressMonitorDialog(Display.getCurrent().getActiveShell()).run(true, false, runnable);
                    }
                    catch (InvocationTargetException e) {
                        LoggingService.logException((String)"oracle.eclipse.tools.common.services.ui", (Throwable)e);
                    }
                    catch (InterruptedException e) {
                        LoggingService.logException((String)"oracle.eclipse.tools.common.services.ui", (Throwable)e);
                    }
                }
            });
        }
        return super.performOk();
    }

    protected IRunnableWithProgress getRefreshRunnable() {
        return new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                DependencyModelManager.getInstance().refresh(monitor);
            }
        };
    }

    private void setAllTechExtensions(boolean bool) {
        for (ITechnologyExtensionIdentifier ite : this.techExtensions) {
            this.preferences.setTechnologyExtensionActiveForDiscovery(ite.getId(), ite.getVersion(), bool);
            this.preferences.setTechnologyExtensionActiveForCollection(ite.getId(), ite.getVersion(), bool);
        }
    }

    public void init(IWorkbench workbench) {
    }

    private class TechnologyExtensionContentProvider
    implements IStructuredContentProvider {
        private TechnologyExtensionContentProvider() {
        }

        public void dispose() {
        }

        public Object[] getElements(Object inputElement) {
            return DependencyPreferencePage.this.techExtensions.toArray();
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    private class TechnologyLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        private TechnologyLabelProvider() {
        }

        public String getText(Object element) {
            if (element == null) {
                return "";
            }
            if (element instanceof ITechnologyExtensionIdentifier) {
                return ((ITechnologyExtensionIdentifier)element).getDisplayName();
            }
            return super.getText(element);
        }

        private Image getImage(boolean checked) {
            if (checked && DependencyPreferencePage.this.techExtTable.isEnabled()) {
                return Activator.Images.CHECKED_TABLE.getImage();
            }
            if (checked) {
                return Activator.Images.CHECKED_TABLE_DISABLED.getImage();
            }
            if (DependencyPreferencePage.this.techExtTable.isEnabled()) {
                return Activator.Images.UNCHECKED_TABLE.getImage();
            }
            return Activator.Images.UNCHECKED_TABLE_DISABLED.getImage();
        }

        public Image getColumnImage(Object element, int columnIndex) {
            ITechnologyExtensionIdentifier ite = (ITechnologyExtensionIdentifier)element;
            if (columnIndex == 1) {
                boolean enabled = DependencyPreferencePage.this.preferences.isTechnologyExtensionActiveForDiscovery(ite.getId(), ite.getVersion());
                return this.getImage(enabled);
            }
            if (columnIndex == 2) {
                boolean enabled = DependencyPreferencePage.this.preferences.isTechnologyExtensionActiveForCollection(ite.getId(), ite.getVersion());
                return this.getImage(enabled);
            }
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            if (columnIndex == 0) {
                return this.getText(element);
            }
            return null;
        }
    }
}

