/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.common.services.ui.dependency.editor.property;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;
import oracle.eclipse.tools.common.services.ui.Activator;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertySource;

public abstract class BeanPropertySource
implements IPropertySource {
    private List<? extends IPropertyDescriptor> properties;
    private Object value;

    public BeanPropertySource(Object value, List<? extends IPropertyDescriptor> properties) {
        this.value = value;
        this.properties = properties;
    }

    public void setPropertyValue(Object id, Object value) {
    }

    public void resetPropertyValue(Object id) {
    }

    public boolean isPropertySet(Object id) {
        return false;
    }

    public Object getPropertyValue(Object id) {
        Class<?> clazz = this.value.getClass();
        try {
            BeanInfo beanInfo = Introspector.getBeanInfo(clazz);
            PropertyDescriptor[] propertyDescriptorArray = beanInfo.getPropertyDescriptors();
            int n = propertyDescriptorArray.length;
            int n2 = 0;
            while (n2 < n) {
                Method readMethod;
                PropertyDescriptor desc = propertyDescriptorArray[n2];
                if (desc.getName().equals(id) && (readMethod = desc.getReadMethod()) != null) {
                    return readMethod.invoke(this.value, new Object[0]);
                }
                ++n2;
            }
        }
        catch (IntrospectionException e) {
            Activator.log("Trying to introspect bean", e);
        }
        catch (IllegalArgumentException e) {
            Activator.log("Trying to introspect bean", e);
        }
        catch (IllegalAccessException e) {
            Activator.log("Trying to introspect bean", e);
        }
        catch (InvocationTargetException e) {
            Activator.log("Trying to introspect bean", e);
        }
        return null;
    }

    public IPropertyDescriptor[] getPropertyDescriptors() {
        return this.properties.toArray(new IPropertyDescriptor[0]);
    }

    public Object getEditableValue() {
        return null;
    }
}

