/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.common.services.ui.dependency.editor.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Set;
import oracle.eclipse.tools.common.services.dependency.artifact.ArtifactController;
import oracle.eclipse.tools.common.services.dependency.artifact.ArtifactOwnershipReference;
import oracle.eclipse.tools.common.services.dependency.artifact.ArtifactTypeFilter;
import oracle.eclipse.tools.common.services.dependency.artifact.IArtifact;
import oracle.eclipse.tools.common.services.dependency.artifact.IArtifactReference;
import oracle.eclipse.tools.common.services.ui.dependency.ArtifactLabelProvider;
import oracle.eclipse.tools.common.services.ui.dependency.editor.DependencyFilter;
import oracle.eclipse.tools.common.services.ui.dependency.editor.model.ArtifactNode;
import oracle.eclipse.tools.common.services.ui.dependency.editor.model.ArtifactNodeRelationship;
import oracle.eclipse.tools.common.ui.diagram.model.Node;
import oracle.eclipse.tools.common.ui.diagram.model.NodeDiagramModel;
import oracle.eclipse.tools.common.ui.diagram.model.NodeRelationship;
import org.eclipse.core.resources.IProject;

public class DependencyEditorModel
extends NodeDiagramModel {
    private IArtifact _artifact;
    private HashMap<IArtifact, ArtifactNode> _artifactNodeMap = new HashMap();
    private DependencyFilter _filter;
    private ArtifactController _controller;
    private static ArtifactLabelProvider _labelProvider;
    private final Comparator<ArtifactNode> _comparator = new Comparator<ArtifactNode>(){

        @Override
        public int compare(ArtifactNode node1, ArtifactNode node2) {
            String type2;
            IArtifact artifact1 = node1.getArtifact();
            IArtifact artifact2 = node2.getArtifact();
            String type1 = artifact1.getType();
            if (type1.equals(type2 = artifact2.getType())) {
                String text1 = DependencyEditorModel.getArtifactLabelProvider().getText(artifact1);
                String text2 = DependencyEditorModel.getArtifactLabelProvider().getText(artifact2);
                return text1.compareTo(text2);
            }
            return type1.compareTo(type2);
        }
    };

    private static ArtifactLabelProvider getArtifactLabelProvider() {
        if (_labelProvider == null) {
            _labelProvider = new ArtifactLabelProvider();
        }
        return _labelProvider;
    }

    public DependencyEditorModel(ArtifactController controller, IArtifact artifact, DependencyFilter filter, boolean updateFilter) {
        this._controller = controller;
        this._artifact = artifact;
        this._filter = filter;
        if (updateFilter) {
            ArrayList<String> types = new ArrayList<String>();
            Set<ArtifactTypeFilter> typeFilters = this.getArtifactTypeFilter();
            for (ArtifactTypeFilter flt : typeFilters) {
                if (flt.shouldShowType(null)) continue;
                types.add(flt.getId());
                flt.setShouldShowType(null, false);
            }
            this._filter.setTypes(types);
        }
        this.setModelName(artifact.getName());
        this.buildModel();
    }

    public Set<ArtifactTypeFilter> getArtifactTypeFilter() {
        IProject project = this._artifact.getProject();
        return this._controller.getFilters(project);
    }

    public Node getModelObject(Object obj) {
        if (obj == null) {
            return null;
        }
        assert (obj instanceof IArtifact);
        return (Node)this._artifactNodeMap.get(obj);
    }

    private void buildModel() {
        ArtifactNode node = new ArtifactNode(this._artifact);
        node.setFocal(true);
        node.setShowLeftExpander(true);
        node.setLeftExpanded(true);
        node.setShowRightExpander(true);
        node.setRightExpanded(true);
        this._artifactNodeMap.put(this._artifact, node);
        if (this._artifact.isMissing()) {
            node.setHasError(true);
        }
        this.addNode((Node)node);
        this.addReferences(node);
        this.addReferers(node);
    }

    public void addReferences(ArtifactNode node) {
        ArrayList<ArtifactNode> nodes = new ArrayList<ArtifactNode>();
        for (IArtifactReference ref : node.getArtifact().getReferences()) {
            IArtifact artifact2 = ref.getTargetArtifact();
            if (artifact2 == null || this._filter != null && this._filter.isFiltered(artifact2)) continue;
            ArtifactNode node2 = new ArtifactNode(artifact2, ref);
            this._artifactNodeMap.put(artifact2, node2);
            if (ref.isMissing() || artifact2.isMissing()) {
                node2.setHasError(true);
            }
            nodes.add(node2);
        }
        for (IArtifact child : this._controller.getArtifactChildren(node.getArtifact())) {
            if (child == null || this._filter != null && this._filter.isFiltered(child)) continue;
            ArtifactNode node2 = new ArtifactNode(child, (IArtifactReference)new ArtifactOwnershipReference(child, node.getArtifact()));
            this._artifactNodeMap.put(child, node2);
            if (child.isMissing()) {
                node2.setHasError(true);
            }
            nodes.add(node2);
        }
        Collections.sort(nodes, this._comparator);
        for (ArtifactNode node2 : nodes) {
            this.addNode((Node)node2);
            node2.setShowRightExpander(true);
            new ArtifactNodeRelationship((Node)node, (Node)node2, this.findArtifactReference(node2.getArtifact(), node.getArtifact()), false, this._filter);
        }
    }

    private IArtifactReference findArtifactReference(IArtifact targetArtifact, IArtifact srcArtifact) {
        for (IArtifactReference ref : this._controller.getArtifactReferers(targetArtifact)) {
            IArtifact owner = ref.getOwner();
            if (!owner.equals(srcArtifact)) continue;
            return ref;
        }
        IArtifact owner = targetArtifact.getOwner();
        if (owner != null && owner.equals(srcArtifact)) {
            return new ArtifactOwnershipReference(targetArtifact, owner);
        }
        return null;
    }

    public void removeReferences(Node node) {
        for (NodeRelationship relation : node.getReferences()) {
            Node refNode = relation.getTarget();
            refNode.removeReferer(relation);
            this.removeReferences(refNode);
            this.removeNode(refNode);
        }
        node.removeAllReferences();
    }

    public boolean hasReferences(ArtifactNode node) {
        for (IArtifactReference ref : node.getArtifact().getReferences()) {
            IArtifact artifact2 = ref.getTargetArtifact();
            if (this._filter != null && this._filter.isFiltered(artifact2)) continue;
            return true;
        }
        for (IArtifact child : this._controller.getArtifactChildren(node.getArtifact())) {
            if (this._filter != null && this._filter.isFiltered(child)) continue;
            return true;
        }
        return false;
    }

    public void addReferers(ArtifactNode node) {
        ArrayList<ArtifactNode> nodes = new ArrayList<ArtifactNode>();
        for (IArtifactReference ref : this._controller.getArtifactReferers(node.getArtifact())) {
            IArtifact artifact2 = ref.getOwner();
            if (this._filter != null && this._filter.isFiltered(artifact2)) continue;
            ArtifactNode node2 = new ArtifactNode(artifact2, ref);
            this._artifactNodeMap.put(artifact2, node2);
            nodes.add(node2);
        }
        Collections.sort(nodes, this._comparator);
        for (ArtifactNode node2 : nodes) {
            this.addNode((Node)node2);
            node2.setShowLeftExpander(true);
            new ArtifactNodeRelationship((Node)node2, (Node)node, node2.getArtifactReference(), true, this._filter);
        }
    }

    public void removeReferers(Node node) {
        for (NodeRelationship relation : node.getReferers()) {
            Node refNode = relation.getSrc();
            refNode.removeReferer(relation);
            this.removeReferers(refNode);
            this.removeNode(refNode);
        }
        node.removeAllReferers();
    }

    public boolean hasReferers(ArtifactNode node) {
        for (IArtifactReference ref : this._controller.getArtifactReferers(node.getArtifact())) {
            IArtifact artifact2 = ref.getOwner();
            if (this._filter != null && this._filter.isFiltered(artifact2)) continue;
            return true;
        }
        return false;
    }

    public DependencyFilter getDependencyFilter() {
        return this._filter;
    }

    public IArtifact getArtifact() {
        return this._artifact;
    }
}

