/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.common.services.ui.dependency.editor.model;

import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Set;
import oracle.eclipse.tools.common.services.dependency.artifact.IArtifactReference;
import oracle.eclipse.tools.common.services.dependency.artifact.IArtifactReferenceLocation;
import oracle.eclipse.tools.common.services.dependency.artifact.Range;
import oracle.eclipse.tools.common.services.dependency.artifact.ResourceLocation;
import oracle.eclipse.tools.common.services.dependency.structuredmodel.IVisitableDOMModel;
import oracle.eclipse.tools.common.services.dependency.structuredmodel.StructuredModelFactory;
import oracle.eclipse.tools.common.services.ui.dependency.editor.DependencyFilter;
import oracle.eclipse.tools.common.services.ui.dependency.editor.action.OpenResourceLocationAction;
import oracle.eclipse.tools.common.ui.diagram.model.IMenuProvider;
import oracle.eclipse.tools.common.ui.diagram.model.Node;
import oracle.eclipse.tools.common.ui.diagram.model.NodeRelationship;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.wst.sse.core.internal.provisional.IndexedRegion;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMElement;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;

public class ArtifactNodeRelationship
extends NodeRelationship
implements IAdaptable {
    private static final String WTP_MODEL_PROVIDER = "org.eclipse.wst.sse.core.StructuredModelManager";
    private IArtifactReference _artifactReference;
    private boolean _atSrc;
    private DependencyFilter _filter;

    public ArtifactNodeRelationship(Node src, Node target, IArtifactReference artifactReference, boolean atSrc, DependencyFilter filter) {
        super(src, target);
        this._artifactReference = artifactReference;
        this._atSrc = atSrc;
        this._filter = filter;
        int size = 0;
        if (artifactReference != null && this._artifactReference.getLocations() != null && this._artifactReference.getLocations().size() > 0) {
            size = this._artifactReference.getLocations().size();
            if (atSrc) {
                this.setSrcLabel(Integer.toString(size));
            } else {
                this.setTargetLabel(Integer.toString(size));
            }
        }
    }

    public boolean isReferenceAtSrc() {
        return this._atSrc;
    }

    public Object getAdapter(Class adapter) {
        if (adapter == IMenuProvider.class) {
            return new RelationshipMenuProvider();
        }
        return null;
    }

    public IArtifactReference getArtifactReference() {
        return this._artifactReference;
    }

    private class RelationshipMenuProvider
    implements IMenuProvider {
        private RelationshipMenuProvider() {
        }

        public void buildContextMenu(IMenuManager menuMgr) {
            if (ArtifactNodeRelationship.this._artifactReference != null) {
                String type = ArtifactNodeRelationship.this._artifactReference.getType();
                boolean bindingref = false;
                LinkedHashMap<Range, ElementInfo> map = null;
                if (type.equals("adfm-pagedef-binding") || type.equals("adfm-pagedef-iterator-id") || type.equals("adfm-pagedef-searchregion")) {
                    bindingref = true;
                    map = new LinkedHashMap<Range, ElementInfo>();
                }
                boolean grpADFBindings = ArtifactNodeRelationship.this._filter.getGroupADFBindings();
                Set locations = ArtifactNodeRelationship.this._artifactReference.getLocations();
                if (locations != null && locations.size() > 0) {
                    for (IArtifactReferenceLocation refLocation : locations) {
                        ResourceLocation resLoc = refLocation.getResourceLocation();
                        if (resLoc == null || !(resLoc.getResource() instanceof IFile)) continue;
                        if (grpADFBindings && bindingref) {
                            Range range = resLoc.getRange();
                            ElementInfo elemInfo = this.getParentElemLocationOfELExpr((IFile)resLoc.getResource(), range);
                            if (elemInfo == null || map == null) continue;
                            ElementInfo mapElemInfo = (ElementInfo)map.get(elemInfo.range);
                            if (mapElemInfo == null) {
                                map.put(elemInfo.range, elemInfo);
                                ElementInfo elementInfo = elemInfo;
                                elementInfo.count = elementInfo.count + 1;
                                continue;
                            }
                            ElementInfo elementInfo = mapElemInfo;
                            elementInfo.count = elementInfo.count + 1;
                            continue;
                        }
                        menuMgr.add((IAction)new OpenResourceLocationAction(resLoc));
                    }
                    if (grpADFBindings && bindingref && map != null) {
                        for (ElementInfo elementInfo : map.values()) {
                            OpenResourceLocationAction action = new OpenResourceLocationAction(new ResourceLocation(elementInfo.resource, elementInfo.range));
                            action.setText("<" + elementInfo.elemName + ">(" + elementInfo.count + ")");
                            menuMgr.add((IAction)action);
                        }
                    }
                }
            }
        }

        private ElementInfo getParentElemLocationOfELExpr(IFile file, Range range) {
            IVisitableDOMModel vModel = null;
            try {
                IndexedRegion inode;
                IDOMModel domModel;
                if (range != null && (vModel = StructuredModelFactory.getVisitableModelForRead((IFile)file, (String)ArtifactNodeRelationship.WTP_MODEL_PROVIDER)) != null && (domModel = vModel.getModel()) != null && (inode = domModel.getIndexedRegion((int)range.getOffset())) instanceof IDOMNode) {
                    IDOMNode node;
                    IDOMNode element = node = (IDOMNode)inode;
                    if (!(node instanceof IDOMElement)) {
                        element = (IDOMNode)node.getParentNode();
                    }
                    if (element instanceof IDOMElement) {
                        int start = element.getStartOffset();
                        int end = element.getEndOffset();
                        Range elemRange = new Range((long)start, (long)(end - start));
                        ElementInfo elementInfo = new ElementInfo(element.getNodeName(), elemRange, (IResource)file);
                        return elementInfo;
                    }
                }
                return null;
            }
            catch (CoreException coreException) {
                return null;
            }
            catch (IOException iOException) {
                return null;
            }
            finally {
                if (vModel != null) {
                    vModel.dispose();
                }
            }
        }

        private class ElementInfo {
            private String elemName;
            private Range range;
            private int count;
            private IResource resource;

            ElementInfo(String elemName, Range range, IResource resource) {
                this.elemName = elemName;
                this.range = range;
                this.resource = resource;
            }

            public boolean equals(Object other) {
                return this.elemName.equals(((ElementInfo)other).elemName) && this.range.getOffset() == ((ElementInfo)other).range.getOffset();
            }
        }
    }
}

