/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.common.services.ui.dependency.editor.layout;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import oracle.eclipse.tools.common.services.ui.dependency.editor.parts.ArtifactNodePart;
import oracle.eclipse.tools.common.ui.diagram.parts.NodeDiagramPart;
import oracle.eclipse.tools.common.ui.diagram.parts.NodeRelationshipPart;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.EditPart;

class TreeLayoutVisitor {
    private static final Insets PADDING = new Insets(6, 24, 6, 24);
    private Map<ArtifactNodePart, TreeNode> _partToTreeNodesMap;
    private int _height;

    TreeLayoutVisitor() {
    }

    public void layoutDiagram(NodeDiagramPart diagram) {
        this._partToTreeNodesMap = new HashMap<ArtifactNodePart, TreeNode>();
        this.buildTreeNodes(diagram);
        TreeNode focal = this.getFocalNode();
        focal._eldest = true;
        focal._youngest = true;
        this._height = focal._height;
        ArrayList<List<TreeNode>> leftColumns = new ArrayList<List<TreeNode>>();
        this.buildEdges(focal, 0, false, leftColumns);
        this.layoutNodes(leftColumns);
        int leftFocalRow = ((TreeNode)((List)leftColumns.get((int)0)).get((int)0))._row;
        ArrayList<List<TreeNode>> columns = new ArrayList<List<TreeNode>>();
        this.buildEdges(focal, 0, true, columns);
        this.layoutNodes(columns);
        this.placeFocalNode(leftFocalRow, leftColumns, columns);
        int x = this.revertPlaceNodes(leftColumns);
        this.placeNodes(x, columns);
        this.applyResults();
    }

    private void buildTreeNodes(NodeDiagramPart diagram) {
        List childParts = diagram.getChildren();
        int i = 0;
        while (i < childParts.size()) {
            if (childParts.get(i) instanceof ArtifactNodePart) {
                ArtifactNodePart part = (ArtifactNodePart)((Object)childParts.get(i));
                TreeNode treeNode = new TreeNode(part);
                Dimension dim = part.getFigure().getPreferredSize(-1, -1);
                treeNode._width = dim.width > 160 ? dim.width : 160;
                treeNode._height = dim.height;
                this._partToTreeNodesMap.put(part, treeNode);
            }
            ++i;
        }
    }

    private TreeNode getFocalNode() {
        for (TreeNode node : this._partToTreeNodesMap.values()) {
            if (!node._nodePart.getArtifactNode().isFocal()) continue;
            return node;
        }
        return null;
    }

    private void buildEdges(TreeNode node, int column, boolean toSource, List<List<TreeNode>> columns) {
        ArrayList<TreeNode> children;
        if (columns.size() - 1 < column) {
            columns.add(new ArrayList());
        }
        List outgoing = toSource ? node._nodePart.getSourceConnections() : node._nodePart.getTargetConnections();
        int size = outgoing.size();
        ArrayList<TreeNode> arrayList = children = size > 0 ? new ArrayList<TreeNode>(size) : null;
        if (children != null) {
            int i = 0;
            while (i < size) {
                NodeRelationshipPart relationshipPart = (NodeRelationshipPart)outgoing.get(i);
                EditPart toPart = toSource ? relationshipPart.getTarget() : relationshipPart.getSource();
                TreeNode toNode = this._partToTreeNodesMap.get(toPart);
                toNode._parent = node;
                if (i == 0) {
                    toNode._eldest = true;
                }
                if (i == size - 1) {
                    toNode._youngest = true;
                }
                children.add(toNode);
                this.buildEdges(toNode, column + 1, toSource, columns);
                ++i;
            }
        }
        node._children = children;
        List<TreeNode> columnList = columns.get(column);
        node._row = columnList.size();
        columnList.add(node);
    }

    private boolean layoutNodes(List<List<TreeNode>> columns) {
        int count = columns.size();
        boolean shifted = false;
        int i = count - 1;
        while (i >= 0) {
            if (this.layoutColumn(i, columns)) {
                shifted = true;
            }
            this.optimizeParent(i, columns);
            --i;
        }
        return shifted;
    }

    private void optimizeParent(int column, List<List<TreeNode>> columns) {
        int minRow = -1;
        int maxRow = -1;
        List<TreeNode> columnList = columns.get(column);
        int i = 0;
        while (i < columnList.size()) {
            TreeNode node = columnList.get(i);
            if (node._eldest) {
                minRow = node._row;
            }
            if (node._youngest) {
                maxRow = node._row;
            }
            if (minRow != -1 && maxRow != -1) {
                if (node._parent != null) {
                    int centerRow;
                    List<TreeNode> parentColumnList = columns.get(column - 1);
                    int parentIndex = this.findNodeIndex(parentColumnList, node._parent);
                    int parentNextRow = Integer.MAX_VALUE;
                    if (parentColumnList.size() - 1 > parentIndex) {
                        parentNextRow = parentColumnList.get((int)(parentIndex + 1))._row;
                    }
                    int parentPrevRow = -1;
                    if (parentIndex > 0) {
                        parentPrevRow = parentColumnList.get((int)(parentIndex - 1))._row;
                    }
                    if ((centerRow = (maxRow - minRow) / 2 + minRow) > parentPrevRow + 1 && centerRow < parentNextRow - 1) {
                        node._parent._row = centerRow;
                    }
                }
                minRow = -1;
                maxRow = -1;
            }
            ++i;
        }
    }

    private boolean layoutColumn(int column, List<List<TreeNode>> columns) {
        int minRow = -1;
        int maxRow = -1;
        int minIndex = -1;
        List<TreeNode> columnList = columns.get(column);
        boolean shifted = false;
        int i = 0;
        while (i < columnList.size()) {
            TreeNode node = columnList.get(i);
            if (node._eldest) {
                minRow = node._row;
                minIndex = i;
            }
            if (node._youngest) {
                maxRow = node._row;
            }
            if (minRow != -1 && maxRow != -1) {
                if (node._parent != null) {
                    int parentRow = node._parent._row;
                    if (maxRow < parentRow) {
                        this.shiftRow(columnList, minIndex, parentRow - maxRow, true);
                        shifted = true;
                    } else if (minRow > parentRow) {
                        List<TreeNode> parentColumnList = columns.get(column - 1);
                        int parentIndex = this.findNodeIndex(parentColumnList, node._parent);
                        assert (parentIndex >= 0);
                        this.shiftRow(parentColumnList, parentIndex, minRow - parentRow, false);
                        shifted = true;
                    }
                }
                minRow = -1;
                maxRow = -1;
            }
            ++i;
        }
        return shifted;
    }

    private void shiftRow(List<TreeNode> columnList, int startIndex, int shift, boolean shiftChildren) {
        int i = startIndex;
        while (i < columnList.size()) {
            TreeNode node = columnList.get(i);
            node._row += shift;
            if (shiftChildren) {
                this.shiftChildren(node, shift);
            }
            ++i;
        }
    }

    private void shiftChildren(TreeNode node, int shift) {
        if (node._children != null) {
            for (TreeNode child : node._children) {
                child._row += shift;
                this.shiftChildren(child, shift);
            }
        }
    }

    private int findNodeIndex(List<TreeNode> columnList, TreeNode node) {
        int i = 0;
        while (i < columnList.size()) {
            if (node.equals(columnList.get(i))) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    private void placeNodes(int x, List<List<TreeNode>> columns) {
        int curx = x;
        int rowHeight = TreeLayoutVisitor.PADDING.top + this._height + TreeLayoutVisitor.PADDING.bottom;
        int i = 1;
        while (i < columns.size()) {
            List<TreeNode> columnList = columns.get(i);
            int width = this.getColumnWidth(columnList);
            int j = 0;
            while (j < columnList.size()) {
                TreeNode node = columnList.get(j);
                int y = node._row * rowHeight + TreeLayoutVisitor.PADDING.top;
                node._rect = new Rectangle(curx, y, width, this._height);
                ++j;
            }
            curx += width + TreeLayoutVisitor.PADDING.right + TreeLayoutVisitor.PADDING.left;
            ++i;
        }
    }

    private int revertPlaceNodes(List<List<TreeNode>> columns) {
        int rowHeight = TreeLayoutVisitor.PADDING.top + this._height + TreeLayoutVisitor.PADDING.bottom;
        int x = TreeLayoutVisitor.PADDING.left;
        int size = columns.size();
        int i = size - 1;
        while (i >= 0) {
            List<TreeNode> columnList = columns.get(i);
            int width = this.getColumnWidth(columnList);
            int j = 0;
            while (j < columnList.size()) {
                TreeNode node = columnList.get(j);
                int y = node._row * rowHeight + TreeLayoutVisitor.PADDING.top;
                node._rect = new Rectangle(x, y, width, this._height);
                ++j;
            }
            x += width + TreeLayoutVisitor.PADDING.right + TreeLayoutVisitor.PADDING.left;
            --i;
        }
        return x;
    }

    private void placeFocalNode(int leftFocalRow, List<List<TreeNode>> leftColumns, List<List<TreeNode>> columns) {
        TreeNode focalNode = columns.get(0).get(0);
        int rightFocalRow = focalNode._row;
        int focalRow = rightFocalRow != 0 && leftFocalRow != 0 ? (rightFocalRow + leftFocalRow) / 2 : Math.max(rightFocalRow, leftFocalRow);
        focalNode._row = focalRow;
        if (focalRow > leftFocalRow) {
            this.shiftAll(leftColumns, focalRow - leftFocalRow);
        }
        if (focalRow > rightFocalRow) {
            this.shiftAll(columns, focalRow - rightFocalRow);
        }
    }

    private void shiftAll(List<List<TreeNode>> columns, int shift) {
        int i = 1;
        while (i < columns.size()) {
            List<TreeNode> columnList = columns.get(i);
            int j = 0;
            while (j < columnList.size()) {
                TreeNode node = columnList.get(j);
                node._row += shift;
                ++j;
            }
            ++i;
        }
    }

    private int getColumnWidth(List<TreeNode> columnList) {
        int width = 0;
        for (TreeNode node : columnList) {
            if (node._width <= width) continue;
            width = node._width;
        }
        return width;
    }

    private void applyResults() {
        for (TreeNode node : this._partToTreeNodesMap.values()) {
            node._nodePart.getFigure().setBounds(node._rect);
        }
    }

    private static class TreeNode {
        ArtifactNodePart _nodePart;
        TreeNode _parent;
        List<TreeNode> _children;
        int _width;
        int _height;
        Rectangle _rect;
        int _row = 0;
        boolean _eldest = false;
        boolean _youngest = false;

        public TreeNode(ArtifactNodePart nodePart) {
            this._nodePart = nodePart;
        }

        public String toString() {
            return this._nodePart.toString();
        }
    }
}

