/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.common.services.ui.dependency.editor.figures;

import oracle.eclipse.tools.common.services.dependency.artifact.IArtifact;
import oracle.eclipse.tools.common.services.ui.Activator;
import oracle.eclipse.tools.common.services.ui.dependency.ArtifactLabelProvider;
import oracle.eclipse.tools.common.services.ui.dependency.editor.model.ArtifactNode;
import oracle.eclipse.tools.common.services.ui.dependency.editor.parts.ArtifactNodePart;
import oracle.eclipse.tools.common.services.ui.dependency.util.OverlayImageDescriptor;
import oracle.eclipse.tools.common.services.util.StringUtil;
import oracle.eclipse.tools.common.ui.diagram.figures.INodeFigure;
import oracle.eclipse.tools.common.ui.diagram.figures.NodeDiagramStyleSheets;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.GridData;
import org.eclipse.draw2d.GridLayout;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.MouseEvent;
import org.eclipse.draw2d.MouseListener;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.swt.graphics.Image;

public class ArtifactNodeFigure
extends Figure
implements INodeFigure {
    private static final int MAX_LENGTH = 24;
    private boolean _selected;
    private boolean _hasFocus;
    private Label _nodeLabel;
    private Label _rightExpander;
    private Label _leftExpander;
    private ArtifactNodePart _nodePart;
    private ArtifactNode _node;
    private Image _errorImage = null;

    public ArtifactNodeFigure(ArtifactNodePart nodePart, ArtifactNode node) {
        this._nodePart = nodePart;
        this._node = node;
        GridLayout gl = new GridLayout(3, false);
        gl.marginWidth = 7;
        this.setLayoutManager((LayoutManager)gl);
        ArtifactLabelProvider lp = new ArtifactLabelProvider();
        IArtifact artifact = node.getArtifact();
        Image image = lp.getImage(artifact);
        if (image == null) {
            image = Activator.Images.GENERIC_ARTIFACT.getImage();
        }
        if (node.hasError()) {
            OverlayImageDescriptor imageDescriptor = new OverlayImageDescriptor(image, 1);
            this._errorImage = image = imageDescriptor.createImage();
        }
        String text = lp.getText(artifact);
        text = StringUtil.truncate((String)text, (int)24);
        this._nodeLabel = new Label(text, image);
        this._nodeLabel.setFont(NodeDiagramStyleSheets.getChildLabelFont());
        this._nodeLabel.setForegroundColor(NodeDiagramStyleSheets.CHILD_LABEL_COLOR);
        String desc = lp.getDescriptionText(artifact);
        if (desc != null) {
            Label tooltip = new Label(desc);
            tooltip.setBorder(TOOL_TIP_BORDER);
            this._nodeLabel.setToolTip((IFigure)tooltip);
        }
        if (node.isShowLeftExpander() && this._nodePart.hasReferers()) {
            this._leftExpander = new Label();
            this.add((IFigure)this._leftExpander);
        }
        this.add((IFigure)this._nodeLabel, new GridData(512));
        if (node.isShowRightExpander() && this._nodePart.hasReferences()) {
            this._rightExpander = new Label();
            this.add((IFigure)this._rightExpander);
        }
        this.addListeners();
    }

    private void addListeners() {
        if (this._leftExpander != null) {
            this._leftExpander.addMouseListener(new MouseListener(){

                public void mouseDoubleClicked(MouseEvent me) {
                }

                public void mousePressed(MouseEvent me) {
                    if (ArtifactNodeFigure.this._node.isLeftExpanded()) {
                        ArtifactNodeFigure.this._node.setLeftExpanded(false);
                        ArtifactNodeFigure.this._nodePart.removeReferers();
                    } else {
                        ArtifactNodeFigure.this._node.setLeftExpanded(true);
                        ArtifactNodeFigure.this._nodePart.addReferers();
                    }
                    me.consume();
                }

                public void mouseReleased(MouseEvent me) {
                }
            });
        }
        if (this._rightExpander != null) {
            this._rightExpander.addMouseListener(new MouseListener(){

                public void mouseDoubleClicked(MouseEvent me) {
                }

                public void mousePressed(MouseEvent me) {
                    if (ArtifactNodeFigure.this._node.isRightExpanded()) {
                        ArtifactNodeFigure.this._node.setRightExpanded(false);
                        ArtifactNodeFigure.this._nodePart.removeReferences();
                    } else {
                        ArtifactNodeFigure.this._node.setRightExpanded(true);
                        ArtifactNodeFigure.this._nodePart.addReferences();
                    }
                    me.consume();
                }

                public void mouseReleased(MouseEvent me) {
                }
            });
        }
    }

    protected void paintFigure(Graphics graphics) {
        if (this._leftExpander != null) {
            if (this._node.isLeftExpanded()) {
                this._leftExpander.setIcon(Activator.Images.MINUS_ICON_IMAGE.getImage());
            } else {
                this._leftExpander.setIcon(Activator.Images.PLUS_ICON_IMAGE.getImage());
            }
        }
        if (this._rightExpander != null) {
            if (this._node.isRightExpanded()) {
                this._rightExpander.setIcon(Activator.Images.MINUS_ICON_IMAGE.getImage());
            } else {
                this._rightExpander.setIcon(Activator.Images.PLUS_ICON_IMAGE.getImage());
            }
        }
        super.paintClientArea(graphics);
        graphics.pushState();
        Rectangle rect = this.getBounds().getCopy();
        if (this._node.isFocal()) {
            Image centerImage = Activator.Images.HEADER_BKGND_CENTER_IMAGE.getImage();
            org.eclipse.swt.graphics.Rectangle imageRect = centerImage.getBounds();
            graphics.drawImage(centerImage, 0, 0, imageRect.width, imageRect.height, rect.x + 1, rect.y + 1, rect.width - 3, rect.height - 2);
        }
        if (this._selected) {
            graphics.setLineWidth(2);
            rect.expand(new Insets(-2, -2, -2, -3));
        } else {
            graphics.setLineWidth(1);
            rect.expand(new Insets(-1, -1, -1, -2));
        }
        graphics.setForegroundColor(NodeDiagramStyleSheets.ROOT_NODE_OUTLINE_HILITE_COLOR);
        graphics.drawRoundRectangle(rect, 6, 6);
        graphics.popState();
        super.paintFigure(graphics);
    }

    public void setSelected(boolean b) {
        this._selected = b;
        this.repaint();
    }

    public boolean isSelected() {
        return this._selected;
    }

    public void setFocus(boolean b) {
        this._hasFocus = b;
        this.repaint();
    }

    public boolean hasFocus() {
        return this._hasFocus;
    }

    public void destroy() {
        if (this._errorImage != null) {
            this._errorImage.dispose();
            this._errorImage = null;
        }
    }
}

