/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.common.services.ui.dependency.editor.action;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import oracle.eclipse.tools.common.services.dependency.artifact.ArtifactTypeFilter;
import oracle.eclipse.tools.common.services.ui.Activator;
import oracle.eclipse.tools.common.services.ui.dependency.ArtifactLabelProvider;
import oracle.eclipse.tools.common.services.ui.dependency.editor.DependencyEditor;
import oracle.eclipse.tools.common.services.ui.dependency.editor.DependencyEditorMessages;
import oracle.eclipse.tools.common.services.ui.dependency.editor.DependencyFilter;
import oracle.eclipse.tools.common.services.ui.dependency.editor.model.DependencyEditorModel;
import oracle.eclipse.tools.common.ui.CommonImages;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.TrayDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

public class FilterDependenciesAction
extends Action {
    private DependencyEditor _editor;
    private DependencyFilter _filter;
    private Set<ArtifactTypeFilter> _typeFilters;
    private ArtifactLabelProvider _labelProvider = new ArtifactLabelProvider();
    private static final String[] EXTENSIONS = new String[]{"css", "gif", "htm", "html", "jpeg", "jpg", "js", "jspf", "png", "properties", "tab"};

    public FilterDependenciesAction(DependencyEditor dependencyEditor) {
        this._editor = dependencyEditor;
        this._filter = dependencyEditor.getDependencyFilter();
        this._typeFilters = ((DependencyEditorModel)this._editor.getModel()).getArtifactTypeFilter();
        this.setText(DependencyEditorMessages.filter_dependency);
        this.setImageDescriptor(Activator.Images.FILTER_DEPENDENCIES_IMAGE.getImageDescriptor());
    }

    public void run() {
        FilterDependenciesDialog dialog = new FilterDependenciesDialog(Display.getDefault().getActiveShell());
        dialog.open();
    }

    private static class ExtensionsContentProvider
    implements IStructuredContentProvider {
        private ExtensionsContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            return EXTENSIONS;
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    private class FilterDependenciesDialog
    extends TrayDialog {
        private CheckboxTableViewer _typesViewer;
        private CheckboxTableViewer _extensionsViewer;
        private Button _grpAdfBindingsBtn;
        private Text _customText;
        private static final String HELPID = "oracle.eclipse.tools.common.services.ui.FilterDependencyDialog";

        protected FilterDependenciesDialog(Shell shell) {
            super(shell);
        }

        protected void configureShell(Shell newShell) {
            newShell.setText(DependencyEditorMessages.filter_dependency);
            super.configureShell(newShell);
            PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)newShell, HELPID);
        }

        protected Control createDialogArea(Composite parent) {
            Composite container = (Composite)super.createDialogArea(parent);
            TabFolder folder = new TabFolder(container, 128);
            TabItem typesItem = new TabItem(folder, 0);
            typesItem.setText(DependencyEditorMessages.filter_dependency_artifact_types);
            typesItem.setControl(this.createTypesControl((Composite)folder));
            TabItem extensionsItem = new TabItem(folder, 0);
            extensionsItem.setText(DependencyEditorMessages.filter_dependency_file_extensions);
            extensionsItem.setControl(this.createExtensionsControl((Composite)folder));
            TabItem adfItem = new TabItem(folder, 0);
            adfItem.setText(DependencyEditorMessages.FilterDependenciesAction_adfSettingsTabItemTitle);
            adfItem.setControl((Control)this.createADFSettingsControl((Composite)folder));
            Dialog.applyDialogFont((Control)container);
            return container;
        }

        private Control createTypesControl(Composite parent) {
            Composite composite = new Composite(parent, 0);
            GridLayout layout = new GridLayout(2, false);
            composite.setLayout((Layout)layout);
            composite.setData((Object)new GridData(4, 4, true, true));
            Label desc = new Label(composite, 64);
            desc.setText(DependencyEditorMessages.filter_dependency_desc);
            GridData layoutData = new GridData(1, 1, true, false);
            layoutData.horizontalSpan = 2;
            desc.setLayoutData((Object)layoutData);
            Label label = new Label(composite, 0);
            label.setText(DependencyEditorMessages.filter_dependency_artifact_types_label);
            layoutData = new GridData(1, 1, true, false);
            layoutData.horizontalSpan = 2;
            layoutData.verticalIndent = 5;
            label.setLayoutData((Object)layoutData);
            this._typesViewer = CheckboxTableViewer.newCheckList((Composite)composite, (int)2048);
            this._typesViewer.setContentProvider((IContentProvider)new TypesContentProvider());
            this._typesViewer.setLabelProvider((IBaseLabelProvider)new TypesLabelProvider());
            this._typesViewer.setComparator((ViewerComparator)new TypesComparator());
            layoutData = new GridData(4, 4, true, true);
            layoutData.widthHint = 200;
            layoutData.heightHint = 160;
            this._typesViewer.getTable().setLayoutData((Object)layoutData);
            this._typesViewer.setInput((Object)this);
            this.initTypes();
            this.createButtonComposite(composite, this._typesViewer);
            return composite;
        }

        private ArtifactTypeFilter getArtifactTypeFilter(String type) {
            for (ArtifactTypeFilter typeFilter : FilterDependenciesAction.this._typeFilters) {
                if (!type.equals(typeFilter.getId())) continue;
                return typeFilter;
            }
            return null;
        }

        private void initTypes() {
            List<String> types = FilterDependenciesAction.this._filter.getTypes();
            if (types != null) {
                for (String type : types) {
                    ArtifactTypeFilter typeFilter = this.getArtifactTypeFilter(type);
                    if (typeFilter == null) continue;
                    this._typesViewer.setChecked((Object)typeFilter, true);
                }
            }
        }

        private Control createExtensionsControl(Composite parent) {
            Composite composite = new Composite(parent, 0);
            GridLayout layout = new GridLayout(2, false);
            composite.setLayout((Layout)layout);
            Label desc = new Label(composite, 64);
            desc.setText(DependencyEditorMessages.filter_dependency_file_extensions_desc);
            GridData layoutData = new GridData(1, 1, true, false);
            layoutData.horizontalSpan = 2;
            desc.setLayoutData((Object)layoutData);
            Label label = new Label(composite, 0);
            label.setText(DependencyEditorMessages.filter_dependency_file_extensions_label);
            layoutData = new GridData(1, 1, true, false);
            layoutData.horizontalSpan = 2;
            layoutData.verticalIndent = 5;
            label.setLayoutData((Object)layoutData);
            this._extensionsViewer = CheckboxTableViewer.newCheckList((Composite)composite, (int)2048);
            this._extensionsViewer.setContentProvider((IContentProvider)new ExtensionsContentProvider());
            this._extensionsViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider());
            layoutData = new GridData(4, 4, true, true);
            layoutData.widthHint = 200;
            layoutData.heightHint = 160;
            this._extensionsViewer.getTable().setLayoutData((Object)layoutData);
            this._extensionsViewer.setInput((Object)this);
            this.createButtonComposite(composite, this._extensionsViewer);
            Label customLabel = new Label(composite, 0);
            customLabel.setText(DependencyEditorMessages.filter_dependency_custom_filter_extensions);
            layoutData = new GridData(1, 1, true, false);
            layoutData.horizontalSpan = 2;
            layoutData.verticalIndent = 5;
            customLabel.setLayoutData((Object)layoutData);
            this._customText = new Text(composite, 2048);
            layoutData = new GridData(4, 1, true, false);
            layoutData.horizontalSpan = 2;
            this._customText.setLayoutData((Object)layoutData);
            String customFileExtensions = FilterDependenciesAction.this._filter.getCustomFileExtensions();
            if (customFileExtensions != null) {
                this._customText.setText(customFileExtensions);
            }
            Label exampleCustomLabel = new Label(composite, 0);
            exampleCustomLabel.setText(DependencyEditorMessages.filter_dependency_custom_example);
            exampleCustomLabel.setForeground(this.getShell().getDisplay().getSystemColor(16));
            layoutData = new GridData(1, 1, true, false);
            layoutData.horizontalSpan = 2;
            exampleCustomLabel.setLayoutData((Object)layoutData);
            this.initExtensions();
            return composite;
        }

        private Composite createADFSettingsControl(Composite parent) {
            Composite composite = new Composite(parent, 0);
            GridLayout layout = new GridLayout(1, false);
            composite.setLayout((Layout)layout);
            this._grpAdfBindingsBtn = new Button(composite, 32);
            this._grpAdfBindingsBtn.setText(DependencyEditorMessages.FilterDependenciesAction_grpElBndsBtn);
            this._grpAdfBindingsBtn.setSelection(FilterDependenciesAction.this._filter.getGroupADFBindings());
            return composite;
        }

        private void initExtensions() {
            List<String> extensions = FilterDependenciesAction.this._filter.getFileExtensions();
            if (extensions != null) {
                for (String extension : extensions) {
                    this._extensionsViewer.setChecked((Object)extension, true);
                }
            }
        }

        private void createButtonComposite(Composite composite, final CheckboxTableViewer viewer) {
            Composite buttonComposite = new Composite(composite, 0);
            GridLayout buttonLayout = new GridLayout(1, false);
            buttonComposite.setLayout((Layout)buttonLayout);
            GridData data = new GridData(4, 1, false, false);
            buttonComposite.setLayoutData((Object)data);
            Button selectAllButton = new Button(buttonComposite, 8);
            selectAllButton.setImage(CommonImages.createImage((ImageDescriptor)CommonImages.DESC_BUTTON_SELECT_ALL));
            selectAllButton.setToolTipText(DependencyEditorMessages.select_all);
            data = new GridData(4, 1, false, false);
            selectAllButton.setLayoutData((Object)data);
            selectAllButton.addSelectionListener(new SelectionListener(){

                public void widgetDefaultSelected(SelectionEvent e) {
                }

                public void widgetSelected(SelectionEvent e) {
                    viewer.setAllChecked(true);
                }
            });
            Button deselectAllButton = new Button(buttonComposite, 8);
            deselectAllButton.setImage(CommonImages.createImage((ImageDescriptor)CommonImages.DESC_BUTTON_DESELECT_ALL));
            deselectAllButton.setToolTipText(DependencyEditorMessages.deselect_all);
            data = new GridData(4, 1, false, false);
            deselectAllButton.setLayoutData((Object)data);
            deselectAllButton.addSelectionListener(new SelectionListener(){

                public void widgetDefaultSelected(SelectionEvent e) {
                }

                public void widgetSelected(SelectionEvent e) {
                    viewer.setAllChecked(false);
                }
            });
        }

        protected void okPressed() {
            ArrayList<String> types = new ArrayList<String>();
            for (ArtifactTypeFilter filter : FilterDependenciesAction.this._typeFilters) {
                if (this._typesViewer.getChecked((Object)filter)) {
                    types.add(filter.getId());
                    if (filter.shouldShowType(null)) continue;
                    filter.setShouldShowType(null, true);
                    continue;
                }
                if (!filter.shouldShowType(null)) continue;
                filter.setShouldShowType(null, false);
            }
            FilterDependenciesAction.this._filter.setTypes(types);
            ArrayList<String> extensions = new ArrayList<String>();
            int i = 0;
            while (i < EXTENSIONS.length) {
                if (this._extensionsViewer.getChecked((Object)EXTENSIONS[i])) {
                    extensions.add(EXTENSIONS[i]);
                }
                ++i;
            }
            FilterDependenciesAction.this._filter.setFileExtensions(extensions);
            FilterDependenciesAction.this._filter.setCustomFileExtensions(this._customText.getText());
            FilterDependenciesAction.this._filter.setGroupADFBindings(this._grpAdfBindingsBtn.getSelection());
            FilterDependenciesAction.this._editor.refreshNewFilter(FilterDependenciesAction.this._filter);
            super.okPressed();
        }
    }

    private class TypesComparator
    extends ViewerComparator {
        private TypesComparator() {
        }

        public int compare(Viewer viewer, Object e1, Object e2) {
            if (e1 instanceof ArtifactTypeFilter && e2 instanceof ArtifactTypeFilter) {
                String s1 = FilterDependenciesAction.this._labelProvider.getText(e1);
                String s2 = FilterDependenciesAction.this._labelProvider.getText(e2);
                if (s1 != null) {
                    return s1.compareTo(s2);
                }
            }
            return super.compare(viewer, e1, e2);
        }
    }

    private class TypesContentProvider
    implements IStructuredContentProvider {
        private TypesContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            return FilterDependenciesAction.this._typeFilters.toArray();
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    private class TypesLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        private TypesLabelProvider() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return FilterDependenciesAction.this._labelProvider.getImage(element);
        }

        public String getColumnText(Object element, int columnIndex) {
            if (element instanceof ArtifactTypeFilter) {
                return FilterDependenciesAction.this._labelProvider.getText(element);
            }
            return element.toString();
        }
    }
}

