/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.common.services.ui.dependency.editor;

import oracle.eclipse.tools.common.services.ui.Activator;
import oracle.eclipse.tools.common.services.ui.dependency.editor.DependencyEditor;
import oracle.eclipse.tools.common.services.ui.dependency.editor.DependencyEditorMessages;
import oracle.eclipse.tools.common.services.ui.dependency.editor.action.FilterDependenciesAction;
import oracle.eclipse.tools.common.ui.diagram.editor.NodeDiagramToolbarPane;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.FigureCanvas;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.MouseEvent;
import org.eclipse.draw2d.MouseListener;
import org.eclipse.draw2d.MouseMotionListener;
import org.eclipse.draw2d.XYLayout;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;

class DependencyToolbarPane
extends NodeDiagramToolbarPane {
    private FigureCanvas leftFillToolBarCanvas;
    private FigureCanvas leftToolBarCanvas;
    private Figure leftToolBarBGFigure;
    private Label filterDependenciesBtn;
    private Image filterDependenciesImg = Activator.Images.FILTER_DEPENDENCIES_IMAGE.getImage();
    private Image filterDependenciesHoverImg = Activator.Images.FILTER_DEPENDENCIES_HOVER_IMAGE.getImage();
    protected static final int IMAGE_HEIGHT_ = 20;
    private static final int LEFT_TOOLBAR_WIDTH = 35;
    private static int wrappingMinSize = 225;
    protected int labelWidth = -1;
    protected int labelYPos = -1;

    public DependencyToolbarPane(Composite parent) {
        this.toolbarCanvas = new Canvas(parent, 0);
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        this.toolbarCanvas.setLayoutData((Object)gd);
        this.toolbarCanvas.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent event) {
                org.eclipse.swt.graphics.Rectangle imageRect = DependencyToolbarPane.this.toolbarBgImage.getBounds();
                org.eclipse.swt.graphics.Rectangle rect = DependencyToolbarPane.this.toolbarCanvas.getClientArea();
                event.gc.drawImage(DependencyToolbarPane.this.toolbarBgImage, 0, 0, imageRect.width, imageRect.height, rect.x, rect.y, rect.width, rect.height);
            }
        });
        parent.addControlListener((ControlListener)new DependencyToolbarControlListener());
        this.setSizeVariables();
        this.createLeftFillCanvas();
        this.createLeftToolBar();
        this.createZoomCombo((Composite)this.toolbarCanvas);
        this.createRightToolBar();
    }

    public DependencyEditor getDependencyEditor() {
        return (DependencyEditor)this.editor;
    }

    private void createLeftFillCanvas() {
        this.leftFillToolBarCanvas = new FigureCanvas((Composite)this.toolbarCanvas);
        this.leftFillToolBarCanvas.setHorizontalScrollBarVisibility(FigureCanvas.NEVER);
        this.leftFillToolBarCanvas.setVerticalScrollBarVisibility(FigureCanvas.NEVER);
        NodeDiagramToolbarPane.ToolBarFigure leftFillBGFigure = new NodeDiagramToolbarPane.ToolBarFigure((NodeDiagramToolbarPane)this);
        leftFillBGFigure.setLayoutManager((LayoutManager)new XYLayout());
        leftFillBGFigure.setMinimumSize(new Dimension(35, this.paneHeight));
        leftFillBGFigure.setPreferredSize(new Dimension(35, this.paneHeight));
        this.leftFillToolBarCanvas.setContents((IFigure)leftFillBGFigure);
    }

    private void createLeftToolBar() {
        this.leftToolBarCanvas = new FigureCanvas((Composite)this.toolbarCanvas);
        this.leftToolBarCanvas.setHorizontalScrollBarVisibility(FigureCanvas.NEVER);
        this.leftToolBarCanvas.setVerticalScrollBarVisibility(FigureCanvas.NEVER);
        this.leftToolBarBGFigure = new NodeDiagramToolbarPane.ToolBarFigureWithSeparator((NodeDiagramToolbarPane)this, false);
        this.leftToolBarBGFigure.setLayoutManager((LayoutManager)new XYLayout());
        this.leftToolBarBGFigure.setMinimumSize(new Dimension(35, this.paneHeight));
        this.leftToolBarBGFigure.setPreferredSize(new Dimension(35, this.paneHeight));
        this.leftToolBarCanvas.setContents((IFigure)this.leftToolBarBGFigure);
        this.createLeftToolBarButtons();
        this.layoutLeftToolBarButtons();
    }

    private void createLeftToolBarButtons() {
        this.createFilterDependenciesBtn();
    }

    private void createFilterDependenciesBtn() {
        this.filterDependenciesBtn = new Label(this.filterDependenciesImg);
        this.filterDependenciesBtn.setToolTip((IFigure)new Label(DependencyEditorMessages.filter_dependency));
        this.filterDependenciesBtn.setOpaque(false);
        this.filterDependenciesBtn.addMouseMotionListener((MouseMotionListener)new NodeDiagramToolbarPane.ToolBarMouseMotionListener((NodeDiagramToolbarPane)this, this.filterDependenciesBtn, this.filterDependenciesImg, this.filterDependenciesHoverImg, new NodeDiagramToolbarPane.HoverCondition((NodeDiagramToolbarPane)this)));
        this.filterDependenciesBtn.addMouseListener((MouseListener)new MouseListener.Stub(){

            public void mousePressed(MouseEvent me) {
                FilterDependenciesAction action = new FilterDependenciesAction(DependencyToolbarPane.this.getDependencyEditor());
                action.run();
                DependencyToolbarPane.this.viewer.getControl().forceFocus();
            }
        });
    }

    private void layoutLeftToolBarButtons() {
        int y = (this.paneHeight - 20) / 2;
        Rectangle r = new Rectangle(5, y, 24, 20);
        this.leftToolBarBGFigure.add((IFigure)this.filterDependenciesBtn, (Object)r);
    }

    private class DependencyToolbarControlListener
    implements ControlListener {
        private DependencyToolbarControlListener() {
        }

        public void controlMoved(ControlEvent e) {
        }

        public void controlResized(ControlEvent e) {
            int width = ((DependencyToolbarPane)DependencyToolbarPane.this).toolbarCanvas.getParent().getSize().x;
            int height = 0;
            int nRows = 1;
            if (width < wrappingMinSize) {
                nRows = width >= 130 ? 2 : 3;
            }
            height = nRows * DependencyToolbarPane.this.paneHeight;
            GridData gd = new GridData();
            gd.horizontalAlignment = 4;
            gd.heightHint = height;
            gd.widthHint = width;
            DependencyToolbarPane.this.toolbarCanvas.setLayoutData((Object)gd);
            DependencyToolbarPane.this.toolbarCanvas.getParent().layout();
            int topMargin = (DependencyToolbarPane.this.paneHeight - 16) / 2;
            if (nRows == 1) {
                int x = width;
                DependencyToolbarPane.this.rightToolBarCanvas.setBounds(x - 95, 0, 95, DependencyToolbarPane.this.paneHeight);
                DependencyToolbarPane.this.comboParent.setBounds((x -= 95) - 95, topMargin, 95, 16);
                DependencyToolbarPane.this.leftToolBarCanvas.setBounds((x -= 95) - 35, 0, 35, DependencyToolbarPane.this.paneHeight);
                DependencyToolbarPane.this.leftFillToolBarCanvas.setBounds(0, 0, x - 35, DependencyToolbarPane.this.paneHeight);
            } else if (nRows == 2) {
                DependencyToolbarPane.this.leftToolBarCanvas.setBounds(0, 0, 35, DependencyToolbarPane.this.paneHeight);
                int rightWidth = width - 35;
                DependencyToolbarPane.this.rightToolBarCanvas.setBounds(width - rightWidth, 0, rightWidth, DependencyToolbarPane.this.paneHeight);
                int x = Math.max(width - 95, 0);
                DependencyToolbarPane.this.comboParent.setBounds(0, DependencyToolbarPane.this.paneHeight + topMargin, 95, 16);
                DependencyToolbarPane.this.leftFillToolBarCanvas.setBounds(95, DependencyToolbarPane.this.paneHeight, x, DependencyToolbarPane.this.paneHeight);
            } else {
                DependencyToolbarPane.this.leftToolBarCanvas.setBounds(0, 0, width, DependencyToolbarPane.this.paneHeight);
                DependencyToolbarPane.this.rightToolBarCanvas.setBounds(0, DependencyToolbarPane.this.paneHeight, width, DependencyToolbarPane.this.paneHeight);
                int x = Math.max(width - 95, 0);
                DependencyToolbarPane.this.comboParent.setBounds(0, DependencyToolbarPane.this.paneHeight * 2 + topMargin, 95, 16);
                DependencyToolbarPane.this.leftFillToolBarCanvas.setBounds(95, DependencyToolbarPane.this.paneHeight * 2, x, DependencyToolbarPane.this.paneHeight);
            }
        }
    }
}

